/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class TraversalDocument {
  @JsFunction
  public interface CreateNodeIteratorCallbackFn {
    NodeIterator onInvoke(Node p0, double p1, NodeFilter p2, boolean p3);
  }

  @JsFunction
  public interface CreateTreeWalkerCallbackFn {
    TreeWalker onInvoke(Node p0, double p1, NodeFilter p2, boolean p3);
  }

  public CreateNodeIteratorCallbackFn createNodeIterator;
  public CreateTreeWalkerCallbackFn createTreeWalker;
}
