/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, name = "Object", namespace = JsPackage.GLOBAL)
public class JsObject {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface EntriesArrayArrayUnionType<T> {
    @JsOverlay
    static EntriesArrayArrayUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default T asT() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  public static native JsObject assign(JsObject target, JsObject... var_args);

  public static native JsObject create(JsObject proto, JsObject properties);

  public static native JsObject create(JsObject proto);

  public static native JsObject defineProperties(JsObject obj, JsObject props);

  public static native JsObject defineProperty(JsObject obj, String prop, JsObject descriptor);

  public static native <T> EntriesArrayArrayUnionType<T>[][] entries(JsPropertyMap<T> obj);

  public static native <T> T freeze(T obj);

  public static native <T> ObjectPropertyDescriptor<T> getOwnPropertyDescriptor(T obj, String prop);

  public static native JsPropertyMap<ObjectPropertyDescriptor> getOwnPropertyDescriptors(
      JsObject obj);

  public static native String[] getOwnPropertyNames(JsObject obj);

  public static native Object[] getOwnPropertySymbols(JsObject obj);

  public static native JsObject getPrototypeOf(JsObject obj);

  public static native boolean is(Object p0, Object p1);

  public static native boolean isExtensible(JsObject obj);

  public static native boolean isFrozen(JsObject obj);

  public static native boolean isSealed(JsObject obj);

  public static native String[] keys(JsObject obj);

  public static native JsObject observe(JsObject object, Function callback, String[] acceptList);

  public static native JsObject observe(JsObject object, Function callback);

  public static native <T> T preventExtensions(T obj);

  public static native <T> T seal(T obj);

  public static native JsObject setPrototypeOf(JsObject obj, Object proto);

  public static native JsObject unobserve(JsObject object, Function callback);

  public static native <T> T[] values(JsPropertyMap<T> obj);

  public JsObject __parent__;
  public JsObject __proto__;
  public Function constructor;

  public JsObject() {}

  public JsObject(Object value) {}

  public native void __defineGetter__(String sprop, Function fun);

  public native void __defineSetter__(String sprop, Function fun);

  public native Function __lookupGetter__(String sprop);

  public native Function __lookupSetter__(String sprop);

  public native boolean hasOwnProperty(Object propertyName);

  public native boolean isPrototypeOf(JsObject other);

  public native boolean propertyIsEnumerable(String propertyName);

  public native Object toJSON();

  public native Object toJSON(String key);

  public native String toLocaleString();

  public native String toSource();

  public native String toString();

  public native Object valueOf();
}
