/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.uberfire.client.mvp.ActivityAndMetaInfo;
import org.uberfire.client.mvp.CategoriesManagerCache;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.workbench.category.Category;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class ResourceTypeManagerCache {
    private List<ActivityAndMetaInfo> resourceActivities = new ArrayList<ActivityAndMetaInfo>();
    private CategoriesManagerCache categoriesManagerCache;

    @Inject
    public ResourceTypeManagerCache(CategoriesManagerCache categoriesManagerCache) {
        this.categoriesManagerCache = categoriesManagerCache;
    }

    public void addAll(List<ClientResourceType> resourceTypeDefinitions) {
        this.categoriesManagerCache.addAllFromResourceTypes(resourceTypeDefinitions);
    }

    public Set<ResourceTypeDefinition> getResourceTypeDefinitions() {
        return this.resourceActivities.stream().map(activityAndMetaInfo -> this.getResourceTypes((ActivityAndMetaInfo)activityAndMetaInfo)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public List<ActivityAndMetaInfo> getResourceActivities() {
        return this.resourceActivities;
    }

    public void addResourceActivity(ActivityAndMetaInfo activityAndMetaInfo) {
        this.getResourceActivities().add(activityAndMetaInfo);
        List<ClientResourceType> resourceTypes = this.getResourceTypes(activityAndMetaInfo);
        this.addAll(resourceTypes);
    }

    private List<ClientResourceType> getResourceTypes(ActivityAndMetaInfo activityAndMetaInfo) {
        return Arrays.stream(activityAndMetaInfo.getResourceTypes()).collect(Collectors.toList());
    }

    public List<ResourceTypeDefinition> getResourceTypeDefinitionsByCategory(Category category) {
        return this.getResourceTypeDefinitions().stream().filter(resourceTypeDefinition -> {
            if (category != null) {
                return category.equals((Object)resourceTypeDefinition.getCategory());
            }
            return true;
        }).collect(Collectors.toList());
    }

    public void sortResourceActivitiesByPriority() {
        Collections.sort(this.resourceActivities, (o1, o2) -> {
            if (o1.getPriority() < o2.getPriority()) {
                return 1;
            }
            if (o1.getPriority() > o2.getPriority()) {
                return -1;
            }
            return 0;
        });
    }
}

