/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.JsObject;
import elemental2.promise.Promise;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Window implements EventTarget {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface FetchInputUnionType {
    @JsOverlay
    static FetchInputUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Request asRequest() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isRequest() {
      return (Object) this instanceof Request;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface FrameElementUnionType {
    @JsOverlay
    static FrameElementUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default HTMLIFrameElement asHTMLIFrameElement() {
      return Js.cast(this);
    }

    @JsOverlay
    default HTMLObjectElement asHTMLObjectElement() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isHTMLIFrameElement() {
      return (Object) this instanceof HTMLIFrameElement;
    }

    @JsOverlay
    default boolean isHTMLObjectElement() {
      return (Object) this instanceof HTMLObjectElement;
    }
  }

  @JsFunction
  public interface OnabortCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnbeforeunloadCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnblurCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnchangeCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnclickCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OncloseCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OncontextmenuCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OndblclickCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OndragdropCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnerrorCallbackFn {
    Object onInvoke(String p0, String p1, double p2);
  }

  @JsFunction
  public interface OnfocusCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnhashchangeCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnkeydownCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnkeypressCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnkeyupCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnloadCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnmousedownCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnmousemoveCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnmouseoutCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnmouseoverCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnmouseupCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnmousewheelCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnpaintCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnpopstateCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnresetCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnresizeCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnscrollCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnselectCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnsubmitCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnunloadCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnwheelCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OpenDatabaseCallbackFn {
    Object onInvoke(Database p0);
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface OpenDatabaseCallbackUnionType {
    @JsOverlay
    static OpenDatabaseCallbackUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default DatabaseCallback asDatabaseCallback() {
      return Js.cast(this);
    }

    @JsOverlay
    default OpenDatabaseCallbackFn asOpenDatabaseCallbackFn() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isOpenDatabaseCallbackFn() {
      return (Object) this instanceof OpenDatabaseCallbackFn;
    }
  }

  public CSSInterface CSS;
  public Object Window;
  public DOMApplicationCache applicationCache;
  public CacheStorage caches;
  public boolean closed;
  public Console console;
  public FrameElementUnionType frameElement;
  public JsObject frames;
  public History history;
  public double innerHeight;
  public double innerWidth;
  public double length;
  public Location location;
  public Object locationbar;
  public Object menubar;
  public String name;
  public Navigator navigator;
  public OnabortCallbackFn onabort;
  public OnbeforeunloadCallbackFn onbeforeunload;
  public OnblurCallbackFn onblur;
  public OnchangeCallbackFn onchange;
  public OnclickCallbackFn onclick;
  public OncloseCallbackFn onclose;
  public OncontextmenuCallbackFn oncontextmenu;
  public OndblclickCallbackFn ondblclick;
  public OndragdropCallbackFn ondragdrop;
  public OnerrorCallbackFn onerror;
  public OnfocusCallbackFn onfocus;
  public OnhashchangeCallbackFn onhashchange;
  public OnkeydownCallbackFn onkeydown;
  public OnkeypressCallbackFn onkeypress;
  public OnkeyupCallbackFn onkeyup;
  public OnloadCallbackFn onload;
  public OnmousedownCallbackFn onmousedown;
  public OnmousemoveCallbackFn onmousemove;
  public OnmouseoutCallbackFn onmouseout;
  public OnmouseoverCallbackFn onmouseover;
  public OnmouseupCallbackFn onmouseup;
  public OnmousewheelCallbackFn onmousewheel;
  public OnpaintCallbackFn onpaint;
  public OnpopstateCallbackFn onpopstate;
  public OnresetCallbackFn onreset;
  public OnresizeCallbackFn onresize;
  public OnscrollCallbackFn onscroll;
  public OnselectCallbackFn onselect;
  public OnsubmitCallbackFn onsubmit;
  public OnunloadCallbackFn onunload;
  public OnwheelCallbackFn onwheel;
  public Window opener;
  public double outerHeight;
  public double outerWidth;
  public double pageXOffset;
  public double pageYOffset;
  public Window parent;
  public Performance performance;
  public Object personalbar;
  public double screenX;
  public double screenY;
  public double scrollX;
  public double scrollY;
  public Window self;
  public String status;
  public Object statusbar;
  public Object toolbar;
  public Window top;
  public NotificationCenter webkitNotifications;
  public Window window;

  public native void addEventListener(
      String type, EventListener listener, EventTarget.AddEventListenerOptionsUnionType options);

  public native void addEventListener(String type, EventListener listener);

  public native Object alert(Object message);

  public native Object blur();

  public native Object close();

  public native Object confirm();

  public native Object confirm(String message);

  public native boolean dispatchEvent(Event evt);

  public native Promise<Response> fetch(FetchInputUnionType input, RequestInit init);

  public native Promise<Response> fetch(FetchInputUnionType input);

  @JsOverlay
  public final Promise<Response> fetch(Request input, RequestInit init) {
    return fetch(Js.<FetchInputUnionType>uncheckedCast(input), init);
  }

  @JsOverlay
  public final Promise<Response> fetch(Request input) {
    return fetch(Js.<FetchInputUnionType>uncheckedCast(input));
  }

  @JsOverlay
  public final Promise<Response> fetch(String input, RequestInit init) {
    return fetch(Js.<FetchInputUnionType>uncheckedCast(input), init);
  }

  @JsOverlay
  public final Promise<Response> fetch(String input) {
    return fetch(Js.<FetchInputUnionType>uncheckedCast(input));
  }

  public native Object focus();

  public native void importScripts(String... var_args);

  public native MediaQueryList matchMedia(String media_query_list);

  public native Window open();

  public native Window open(Object url, String windowName, String windowFeatures, boolean replace);

  public native Window open(Object url, String windowName, String windowFeatures);

  public native Window open(Object url, String windowName);

  public native Window open(Object url);

  @JsOverlay
  public final Database openDatabase(
      String name, String version, String description, double size, DatabaseCallback callback) {
    return openDatabase(
        name,
        version,
        description,
        size,
        Js.<OpenDatabaseCallbackUnionType>uncheckedCast(callback));
  }

  @JsOverlay
  public final Database openDatabase(
      String name,
      String version,
      String description,
      double size,
      OpenDatabaseCallbackFn callback) {
    return openDatabase(
        name,
        version,
        description,
        size,
        Js.<OpenDatabaseCallbackUnionType>uncheckedCast(callback));
  }

  public native Database openDatabase(
      String name,
      String version,
      String description,
      double size,
      OpenDatabaseCallbackUnionType callback);

  public native Database openDatabase(String name, String version, String description, double size);

  public native Object print();

  public native Object prompt();

  public native Object prompt(String message, String default_);

  public native Object prompt(String message);

  public native void removeEventListener(
      String type, EventListener listener, EventTarget.RemoveEventListenerOptionsUnionType options);

  public native void removeEventListener(String type, EventListener listener);

  public native void scroll(double x, double y);

  public native void scrollBy(double x, double y);

  public native void scrollTo(double x, double y);

  public native Object stop();
}
