/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class GetCommonAncestorCommit {
    private final Git git;
    private final RevCommit commitA;
    private final RevCommit commitB;

    public GetCommonAncestorCommit(Git git, RevCommit commitA, RevCommit commitB) {
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.commitA = (RevCommit)PortablePreconditions.checkNotNull((String)"commitA", (Object)commitA);
        this.commitB = (RevCommit)PortablePreconditions.checkNotNull((String)"commitB", (Object)commitB);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RevCommit execute() {
        try (RevWalk revWalk = new RevWalk(this.git.getRepository());){
            RevCommit validatedCommitA = revWalk.lookupCommit((AnyObjectId)this.commitA);
            RevCommit validatedCommitB = revWalk.lookupCommit((AnyObjectId)this.commitB);
            revWalk.setRevFilter(RevFilter.MERGE_BASE);
            revWalk.markStart(validatedCommitA);
            revWalk.markStart(validatedCommitB);
            RevCommit revCommit = revWalk.next();
            return revCommit;
        }
        catch (Exception e) {
            throw new GitException("Error when trying to get common ancestor", e);
        }
    }
}

