/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.BusLifecycleAdapter;
import org.jboss.errai.bus.client.api.BusLifecycleEvent;
import org.jboss.errai.bus.client.api.BusLifecycleListener;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.slf4j.Logger;
import org.uberfire.client.workbench.WorkbenchServicesProxy;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;

@EntryPoint
public class WorkbenchBackendEntryPoint {
    private static final int MAX_RETRIES = 5;
    private Logger logger;
    private ClientMessageBus bus;
    private WorkbenchServicesProxy workbenchServices;
    private ErrorPopupPresenter errorPopupPresenter;
    private boolean isWorkbenchOnCluster = false;
    private boolean showedError = false;
    private boolean isOpen = false;
    private int retries = 5;

    public WorkbenchBackendEntryPoint() {
    }

    @Inject
    public WorkbenchBackendEntryPoint(Logger logger, ClientMessageBus bus, WorkbenchServicesProxy workbenchServices, ErrorPopupPresenter errorPopupPresenter) {
        this.logger = logger;
        this.bus = bus;
        this.workbenchServices = workbenchServices;
        this.errorPopupPresenter = errorPopupPresenter;
    }

    @PostConstruct
    public void init() {
        this.bus.addLifecycleListener((BusLifecycleListener)new BusLifecycleAdapter(){

            public void busOnline(BusLifecycleEvent e) {
                WorkbenchBackendEntryPoint.this.logger.info("Bus is back online.");
                WorkbenchBackendEntryPoint.this.setShowedError(false);
                WorkbenchBackendEntryPoint.this.resetRetries();
            }

            public void busOffline(BusLifecycleEvent e) {
                if (WorkbenchBackendEntryPoint.this.isShowedError()) {
                    return;
                }
                WorkbenchBackendEntryPoint.this.logger.error("Bus is offline. [" + e.getReason().getErrorMessage() + "]");
                if (!(WorkbenchBackendEntryPoint.this.isWorkbenchOnCluster || WorkbenchBackendEntryPoint.this.hasMoreRetries() || WorkbenchBackendEntryPoint.this.isOpen())) {
                    WorkbenchBackendEntryPoint.this.errorPopupPresenter.showMessage("You've been disconnected.", () -> WorkbenchBackendEntryPoint.this.isOpen = true, () -> WorkbenchBackendEntryPoint.this.isOpen = false);
                    WorkbenchBackendEntryPoint.this.setShowedError(true);
                }
                WorkbenchBackendEntryPoint.this.decrementRetries();
            }
        });
        this.workbenchServices.isWorkbenchOnCluster(parameter -> {
            this.isWorkbenchOnCluster = parameter != null && !parameter.equals(Boolean.FALSE);
        });
    }

    protected boolean isOpen() {
        return this.isOpen;
    }

    protected void setShowedError(boolean value) {
        this.showedError = value;
    }

    protected boolean isShowedError() {
        return this.showedError;
    }

    protected boolean hasMoreRetries() {
        return this.retries > 0;
    }

    protected void decrementRetries() {
        if (this.retries > 0) {
            --this.retries;
        }
    }

    protected void resetRetries() {
        this.retries = 5;
    }
}

