/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.spi.config;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.util.BeanUtils;

public abstract class BaseConfigPropertyProducer {
    protected String getStringPropertyValue(InjectionPoint injectionPoint) {
        ConfigProperty configProperty = this.getAnnotation(injectionPoint, ConfigProperty.class);
        if (configProperty == null) {
            throw new IllegalStateException("producer method called without @ConfigProperty being present!");
        }
        return this.getPropertyValue(injectionPoint, String.class);
    }

    protected <T> T getPropertyValue(InjectionPoint injectionPoint, Class<T> ipCls) {
        String parameterizedBy;
        ConfigProperty configProperty = this.getAnnotation(injectionPoint, ConfigProperty.class);
        if (configProperty == null) {
            throw new IllegalStateException("producer method called without @ConfigProperty being present!");
        }
        ConfigResolver.TypedResolver<T> resolver = ConfigResolver.resolve(configProperty.name()).as(ipCls).withCurrentProjectStage(configProperty.projectStageAware());
        String stringDefault = configProperty.defaultValue();
        if (!"org.apache.deltaspike.NullValueMarker".equals(stringDefault)) {
            resolver.withStringDefault(stringDefault);
        }
        if (!"org.apache.deltaspike.NullValueMarker".equals(parameterizedBy = configProperty.parameterizedBy())) {
            resolver.parameterizedBy(parameterizedBy);
        }
        return resolver.getValue();
    }

    protected String getPropertyValue(String propertyName, String defaultValue) {
        String configuredValue = "org.apache.deltaspike.NullValueMarker".equals(defaultValue) ? ConfigResolver.getProjectStageAwarePropertyValue(propertyName) : ConfigResolver.getProjectStageAwarePropertyValue(propertyName, defaultValue);
        return configuredValue;
    }

    protected <T extends Annotation> T getAnnotation(InjectionPoint injectionPoint, Class<T> targetType) {
        return BeanUtils.extractAnnotation(injectionPoint.getAnnotated(), targetType);
    }
}

