/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config.keys;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.RejectAllPublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class AuthorizedKeysAuthenticator
extends ModifiableFileWatcher
implements PublickeyAuthenticator {
    public static final String STD_AUTHORIZED_KEYS_FILENAME = "authorized_keys";
    private final AtomicReference<PublickeyAuthenticator> delegateHolder = new AtomicReference<RejectAllPublickeyAuthenticator>(RejectAllPublickeyAuthenticator.INSTANCE);

    public AuthorizedKeysAuthenticator(File file) {
        this(Objects.requireNonNull(file, "No file to watch").toPath());
    }

    public AuthorizedKeysAuthenticator(Path file) {
        this(file, IoUtils.EMPTY_LINK_OPTIONS);
    }

    public AuthorizedKeysAuthenticator(Path file, LinkOption ... options) {
        super(file, options);
    }

    @Override
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        if (!this.isValidUsername(username, session)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate(" + username + ")[" + session + "][" + key.getAlgorithm() + "] invalid user name - file = " + this.getPath());
            }
            return false;
        }
        try {
            PublickeyAuthenticator delegate = Objects.requireNonNull(this.resolvePublickeyAuthenticator(username, session), "No delegate");
            boolean accepted = delegate.authenticate(username, key, session);
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate(" + username + ")[" + session + "][" + key.getAlgorithm() + "] accepted " + accepted + " from " + this.getPath());
            }
            return accepted;
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate(" + username + ")[" + session + "][" + this.getPath() + "]" + " failed (" + e.getClass().getSimpleName() + ")" + " to resolve delegate: " + e.getMessage());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("authenticate(" + username + ")[" + session + "][" + this.getPath() + "] failure details", e);
            }
            return false;
        }
    }

    protected boolean isValidUsername(String username, ServerSession session) {
        return GenericUtils.isNotEmpty(username);
    }

    protected PublickeyAuthenticator resolvePublickeyAuthenticator(String username, ServerSession session) throws IOException, GeneralSecurityException {
        if (this.checkReloadRequired()) {
            this.delegateHolder.set(RejectAllPublickeyAuthenticator.INSTANCE);
            Path path = this.getPath();
            if (this.exists()) {
                Collection<AuthorizedKeyEntry> entries = this.reloadAuthorizedKeys(path, username, session);
                if (GenericUtils.size(entries) > 0) {
                    this.delegateHolder.set(AuthorizedKeyEntry.fromAuthorizedEntries(this.getFallbackPublicKeyEntryResolver(), entries));
                }
            } else {
                this.log.info("resolvePublickeyAuthenticator(" + username + ")[" + session + "] no authorized keys file at " + path);
            }
        }
        return this.delegateHolder.get();
    }

    protected PublicKeyEntryResolver getFallbackPublicKeyEntryResolver() {
        return PublicKeyEntryResolver.IGNORING;
    }

    protected Collection<AuthorizedKeyEntry> reloadAuthorizedKeys(Path path, String username, ServerSession session) throws IOException {
        List<AuthorizedKeyEntry> entries = AuthorizedKeyEntry.readAuthorizedKeys(path, new OpenOption[0]);
        this.log.info("reloadAuthorizedKeys(" + username + ")[" + session + "] loaded " + GenericUtils.size(entries) + " keys from " + path);
        this.updateReloadAttributes();
        return entries;
    }

    public static Path getDefaultAuthorizedKeysFile() {
        return LazyDefaultAuthorizedKeysFileHolder.KEYS_FILE;
    }

    public static List<AuthorizedKeyEntry> readDefaultAuthorizedKeys(OpenOption ... options) throws IOException {
        Path keysFile = AuthorizedKeysAuthenticator.getDefaultAuthorizedKeysFile();
        if (Files.exists(keysFile, IoUtils.EMPTY_LINK_OPTIONS)) {
            return AuthorizedKeyEntry.readAuthorizedKeys(keysFile, new OpenOption[0]);
        }
        return Collections.emptyList();
    }

    private static final class LazyDefaultAuthorizedKeysFileHolder {
        private static final Path KEYS_FILE = PublicKeyEntry.getDefaultKeysFolderPath().resolve("authorized_keys");

        private LazyDefaultAuthorizedKeysFileHolder() {
        }
    }
}

