/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.JsObject;
import java.lang.Boolean;
import java.lang.Object;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface MediaStreamConstraintsInterface_ {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetAudioUnionType {
    @JsOverlay
    static GetAudioUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default boolean asBoolean() {
      return Js.castToBoolean(this);
    }

    @JsOverlay
    default JsObject asJsObject() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isBoolean() {
      return (Object) this instanceof Boolean;
    }

    @JsOverlay
    default boolean isJsObject() {
      return (Object) this instanceof JsObject;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetVideoUnionType {
    @JsOverlay
    static GetVideoUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default boolean asBoolean() {
      return Js.castToBoolean(this);
    }

    @JsOverlay
    default JsObject asJsObject() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isBoolean() {
      return (Object) this instanceof Boolean;
    }

    @JsOverlay
    default boolean isJsObject() {
      return (Object) this instanceof JsObject;
    }
  }

  @JsProperty
  GetAudioUnionType getAudio();

  @JsProperty
  GetVideoUnionType getVideo();

  @JsProperty
  void setAudio(GetAudioUnionType audio);

  @JsOverlay
  default void setAudio(JsObject audio) {
    setAudio(Js.<GetAudioUnionType>uncheckedCast(audio));
  }

  @JsOverlay
  default void setAudio(boolean audio) {
    setAudio(Js.<GetAudioUnionType>uncheckedCast(audio));
  }

  @JsProperty
  void setVideo(GetVideoUnionType video);

  @JsOverlay
  default void setVideo(JsObject video) {
    setVideo(Js.<GetVideoUnionType>uncheckedCast(video));
  }

  @JsOverlay
  default void setVideo(boolean video) {
    setVideo(Js.<GetVideoUnionType>uncheckedCast(video));
  }
}
