/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.util.Map;
import java.util.Optional;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.BaseCreateCommitTree;
import org.uberfire.java.nio.fs.jgit.util.model.CopyCommitContent;

public class CreateCopyCommitTree
extends BaseCreateCommitTree<CopyCommitContent> {
    public CreateCopyCommitTree(Git git, ObjectId headId, ObjectInserter inserter, CopyCommitContent commitContent) {
        super(git, headId, inserter, commitContent);
    }

    public Optional<ObjectId> execute() {
        Map<String, String> content = ((CopyCommitContent)this.commitContent).getContent();
        DirCacheEditor editor = DirCache.newInCore().editor();
        try {
            this.iterateOverTreeWalk(this.git, this.headId, (walkPath, hTree) -> {
                String toPath = (String)content.get(walkPath);
                this.addToTemporaryInCoreIndex(editor, new DirCacheEntry(walkPath), hTree.getEntryObjectId(), hTree.getEntryFileMode());
                if (toPath != null) {
                    this.addToTemporaryInCoreIndex(editor, new DirCacheEntry(toPath), hTree.getEntryObjectId(), hTree.getEntryFileMode());
                }
            });
            editor.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.buildTree(editor);
    }
}

