/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.logs.ActiveMQUtilLogger;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.jboss.logging.Logger;

public class NetworkHealthCheck
extends ActiveMQScheduledComponent {
    private static final Logger logger = Logger.getLogger(NetworkHealthCheck.class);
    private final Set<ActiveMQComponent> componentList = new ConcurrentHashSet<ActiveMQComponent>();
    private final Set<InetAddress> addresses = new ConcurrentHashSet<InetAddress>();
    private final Set<URL> urls = new ConcurrentHashSet<URL>();
    private NetworkInterface networkInterface;
    public static final String IPV6_DEFAULT_COMMAND = "ping6 -c 1 %2$s";
    public static final String IPV4_DEFAULT_COMMAND = "ping -c 1 -t %d %s";
    private String ipv4Command = "ping -c 1 -t %d %s";
    private String ipv6Command = "ping6 -c 1 %2$s";
    private boolean ignoreLoopback = false;
    private int networkTimeout;

    public NetworkHealthCheck() {
        this(null, 1000L, 1000);
    }

    public NetworkHealthCheck(String nicName, long checkPeriod, int networkTimeout) {
        super(null, null, checkPeriod, TimeUnit.MILLISECONDS, false);
        this.networkTimeout = networkTimeout;
        this.setNICName(nicName);
    }

    public NetworkHealthCheck setNICName(String nicName) {
        NetworkInterface netToUse;
        try {
            netToUse = nicName != null ? NetworkInterface.getByName(nicName) : null;
        }
        catch (Exception e) {
            ActiveMQUtilLogger.LOGGER.failedToSetNIC(e, nicName == null ? " " : nicName);
            netToUse = null;
        }
        this.networkInterface = netToUse;
        return this;
    }

    public boolean isIgnoreLoopback() {
        return this.ignoreLoopback;
    }

    public NetworkHealthCheck setIgnoreLoopback(boolean ignoreLoopback) {
        this.ignoreLoopback = ignoreLoopback;
        return this;
    }

    public Set<InetAddress> getAddresses() {
        return this.addresses;
    }

    public Set<URL> getUrls() {
        return this.urls;
    }

    public String getNICName() {
        if (this.networkInterface != null) {
            return this.networkInterface.getName();
        }
        return null;
    }

    public NetworkHealthCheck parseAddressList(String addressList) {
        if (addressList != null) {
            String[] addresses;
            for (String address : addresses = addressList.split(",")) {
                if (address.trim().isEmpty()) continue;
                try {
                    this.addAddress(InetAddress.getByName(address.trim()));
                }
                catch (Exception e) {
                    ActiveMQUtilLogger.LOGGER.failedToParseAddressList(e, addressList);
                }
            }
        }
        return this;
    }

    public NetworkHealthCheck parseURIList(String addressList) {
        if (addressList != null) {
            String[] addresses;
            for (String address : addresses = addressList.split(",")) {
                if (address.trim().isEmpty()) continue;
                try {
                    this.addURL(new URL(address.trim()));
                }
                catch (Exception e) {
                    ActiveMQUtilLogger.LOGGER.failedToParseUrlList(e, addressList);
                }
            }
        }
        return this;
    }

    @Override
    protected ActiveMQThreadFactory getThreadFactory() {
        return new ActiveMQThreadFactory("NetworkChecker", "Network-Checker-", false, this.getThisClassLoader());
    }

    private ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return NetworkHealthCheck.this.getClass().getClassLoader();
            }
        });
    }

    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    @Override
    public NetworkHealthCheck setPeriod(long period) {
        super.setPeriod(period);
        return this;
    }

    @Override
    public NetworkHealthCheck setTimeUnit(TimeUnit timeUnit) {
        super.setTimeUnit(timeUnit);
        return this;
    }

    public NetworkHealthCheck setNetworkTimeout(int networkTimeout) {
        this.networkTimeout = networkTimeout;
        return this;
    }

    public NetworkHealthCheck addComponent(ActiveMQComponent component) {
        this.componentList.add(component);
        this.checkStart();
        return this;
    }

    public NetworkHealthCheck clearComponents() {
        this.componentList.clear();
        return this;
    }

    public NetworkHealthCheck addAddress(InetAddress address) {
        if (!this.check(address)) {
            ActiveMQUtilLogger.LOGGER.addressWasntReacheable(address.toString());
        }
        if (!this.ignoreLoopback && address.isLoopbackAddress()) {
            ActiveMQUtilLogger.LOGGER.addressloopback(address.toString());
        } else {
            this.addresses.add(address);
            this.checkStart();
        }
        return this;
    }

    public NetworkHealthCheck removeAddress(InetAddress address) {
        this.addresses.remove(address);
        return this;
    }

    public NetworkHealthCheck clearAddresses() {
        this.addresses.clear();
        return this;
    }

    public NetworkHealthCheck addURL(URL url) {
        if (!this.check(url)) {
            ActiveMQUtilLogger.LOGGER.urlWasntReacheable(url.toString());
        }
        this.urls.add(url);
        this.checkStart();
        return this;
    }

    public NetworkHealthCheck removeURL(URL url) {
        this.urls.remove(url);
        return this;
    }

    public NetworkHealthCheck clearURL() {
        this.urls.clear();
        return this;
    }

    public String getIpv4Command() {
        return this.ipv4Command;
    }

    public NetworkHealthCheck setIpv4Command(String ipv4Command) {
        this.ipv4Command = ipv4Command;
        return this;
    }

    public String getIpv6Command() {
        return this.ipv6Command;
    }

    public NetworkHealthCheck setIpv6Command(String ipv6Command) {
        this.ipv6Command = ipv6Command;
        return this;
    }

    private void checkStart() {
        if (!(this.isStarted() || this.addresses.isEmpty() && this.urls.isEmpty() || this.componentList.isEmpty())) {
            this.start();
        }
    }

    @Override
    public void run() {
        boolean healthy = this.check();
        if (healthy) {
            for (ActiveMQComponent component : this.componentList) {
                if (component.isStarted()) continue;
                try {
                    ActiveMQUtilLogger.LOGGER.startingService(component.toString());
                    component.start();
                }
                catch (Exception e) {
                    ActiveMQUtilLogger.LOGGER.errorStartingComponent(e, component.toString());
                }
            }
        } else {
            for (ActiveMQComponent component : this.componentList) {
                if (!component.isStarted()) continue;
                try {
                    ActiveMQUtilLogger.LOGGER.stoppingService(component.toString());
                    component.stop();
                }
                catch (Exception e) {
                    ActiveMQUtilLogger.LOGGER.errorStoppingComponent(e, component.toString());
                }
            }
        }
    }

    public boolean check() {
        if (this.isEmpty()) {
            return true;
        }
        for (InetAddress address : this.addresses) {
            if (!this.check(address)) continue;
            return true;
        }
        for (URL url : this.urls) {
            if (!this.check(url)) continue;
            return true;
        }
        return false;
    }

    public boolean check(InetAddress address) {
        try {
            if (address.isReachable(this.networkInterface, 0, this.networkTimeout)) {
                if (logger.isTraceEnabled()) {
                    logger.tracef(address + " OK", new Object[0]);
                }
                return true;
            }
            return this.purePing(address);
        }
        catch (Exception e) {
            ActiveMQUtilLogger.LOGGER.failedToCheckAddress(e, address == null ? " " : address.toString());
            return false;
        }
    }

    public boolean purePing(InetAddress address) throws IOException, InterruptedException {
        long timeout = Math.max(1L, TimeUnit.MILLISECONDS.toSeconds(this.networkTimeout));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("purePing on canonical address " + address.getCanonicalHostName()));
        }
        ProcessBuilder processBuilder = address instanceof Inet6Address ? this.buildProcess(this.ipv6Command, timeout, address.getCanonicalHostName()) : this.buildProcess(this.ipv4Command, timeout, address.getCanonicalHostName());
        Process pingProcess = processBuilder.start();
        this.readStream(pingProcess.getInputStream(), false);
        this.readStream(pingProcess.getErrorStream(), true);
        return pingProcess.waitFor() == 0;
    }

    private ProcessBuilder buildProcess(String expressionCommand, long timeout, String host) {
        String command = String.format(expressionCommand, timeout, host);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("executing ping:: " + command));
        }
        ProcessBuilder builder = new ProcessBuilder(command.split(" "));
        return builder;
    }

    private void readStream(InputStream stream, boolean error) throws IOException {
        String inputLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((inputLine = reader.readLine()) != null) {
            if (error) {
                ActiveMQUtilLogger.LOGGER.failedToReadFromStream(inputLine == null ? " " : inputLine);
                continue;
            }
            logger.trace((Object)inputLine);
        }
        reader.close();
    }

    public boolean check(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setReadTimeout(this.networkTimeout);
            InputStream is = connection.getInputStream();
            is.close();
            return true;
        }
        catch (Exception e) {
            ActiveMQUtilLogger.LOGGER.failedToCheckURL(e, url == null ? " " : url.toString());
            return false;
        }
    }

    public boolean isEmpty() {
        return this.addresses.isEmpty() && this.urls.isEmpty();
    }
}

