/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import java.lang.Object;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Set<VALUE> implements Iterable<VALUE> {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ConstructorIterableUnionType<VALUE> {
    @JsOverlay
    static ConstructorIterableUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Iterable<VALUE> asIterable() {
      return Js.cast(this);
    }

    @JsOverlay
    default VALUE[] asVALUEArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isVALUEArray() {
      return (Object) this instanceof Object[];
    }
  }

  @JsFunction
  public interface ForEachP0CallbackFn<VALUE> {
    Object onInvoke(VALUE p0, VALUE p1, Set<VALUE> p2);
  }

  public double size;

  public Set() {}

  public Set(ConstructorIterableUnionType<VALUE> iterable) {}

  public Set(Iterable<VALUE> iterable) {}

  public Set(VALUE[] iterable) {}

  public native Set<VALUE> add(VALUE p0);

  public native void clear();

  public native boolean delete(VALUE p0);

  public native IteratorIterable<VALUE[]> entries();

  public native Object forEach(ForEachP0CallbackFn<VALUE> p0, Object p1);

  public native Object forEach(ForEachP0CallbackFn<VALUE> p0);

  public native boolean has(VALUE p0);

  public native IteratorIterable<VALUE> keys();

  public native IteratorIterable<VALUE> values();
}
