/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.web.bindery.event.shared.EventBus;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.util.BusToolsCli;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.BookmarkableUrlHelper;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceRequestHistoryMapper;
import org.uberfire.client.workbench.docks.UberfireDocksInteractionEvent;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.model.ActivityResourceType;

@ApplicationScoped
public class PlaceHistoryHandler {
    private static final Logger log = Logger.getLogger(PlaceHistoryHandler.class.getName());
    private final Historian historian;
    @Inject
    private PlaceRequestHistoryMapper mapper;
    private PlaceManager placeManager;
    private PlaceRequest defaultPlaceRequest = PlaceRequest.NOWHERE;
    private String currentBookmarkableURLStatus = "";

    public PlaceHistoryHandler() {
        this.historian = (Historian)GWT.create(DefaultHistorian.class);
    }

    public void handleCurrentHistory() {
        this.handleHistoryToken(this.historian.getToken());
    }

    public com.google.web.bindery.event.shared.HandlerRegistration initialize(PlaceManager placeManager, EventBus eventBus, PlaceRequest defaultPlaceRequest) {
        this.placeManager = placeManager;
        this.defaultPlaceRequest = defaultPlaceRequest;
        HandlerRegistration historyReg = this.historian.addValueChangeHandler((ValueChangeHandler<String>)((ValueChangeHandler)event -> {}));
        return () -> this.lambda$initialize$1((com.google.web.bindery.event.shared.HandlerRegistration)historyReg);
    }

    private void updateHistoryBar() {
        if (this.currentBookmarkableURLStatus.endsWith("$")) {
            this.currentBookmarkableURLStatus = this.currentBookmarkableURLStatus.substring(0, this.currentBookmarkableURLStatus.length() - 1);
        }
        if (BusToolsCli.isRemoteCommunicationEnabled()) {
            this.historian.newItem(this.currentBookmarkableURLStatus, false);
        }
    }

    Logger log() {
        return log;
    }

    public String getCurrentBookmarkableURLStatus() {
        return this.currentBookmarkableURLStatus;
    }

    private void handleHistoryToken(String token) {
        PlaceRequest newPlaceRequest = null;
        if ("".equals(token)) {
            newPlaceRequest = this.defaultPlaceRequest;
        }
        if (newPlaceRequest == null) {
            newPlaceRequest = this.mapper.getPlaceRequest(token);
        }
        if (newPlaceRequest == null) {
            this.log().warning("Unrecognized history token: " + token);
            newPlaceRequest = this.defaultPlaceRequest;
        }
        this.placeManager.goTo(newPlaceRequest);
    }

    private String tokenForPlace(PlaceRequest newPlaceRequest) {
        if (this.defaultPlaceRequest.equals(newPlaceRequest)) {
            return "";
        }
        return this.currentBookmarkableURLStatus;
    }

    private boolean isScreenClosed(String screen) {
        return BookmarkableUrlHelper.isScreenClosed(screen, this.currentBookmarkableURLStatus);
    }

    public PlaceRequest getPerspectiveFromPlace(PlaceRequest place) {
        return BookmarkableUrlHelper.getPerspectiveFromPlace(place);
    }

    public void registerOpen(Activity activity, PlaceRequest place) {
        if (place.isUpdateLocationBarAllowed()) {
            if (activity.isType(ActivityResourceType.PERSPECTIVE.name())) {
                this.currentBookmarkableURLStatus = BookmarkableUrlHelper.registerOpenedPerspective(this.currentBookmarkableURLStatus, place);
            } else if (activity.isType(ActivityResourceType.SCREEN.name())) {
                this.currentBookmarkableURLStatus = BookmarkableUrlHelper.registerOpenedScreen(this.currentBookmarkableURLStatus, place);
            } else if (activity.isType(ActivityResourceType.EDITOR.name())) {
                this.currentBookmarkableURLStatus = BookmarkableUrlHelper.registerOpenedScreen(this.currentBookmarkableURLStatus, place);
            }
            this.updateHistoryBar();
        }
    }

    public void registerClose(Activity activity, PlaceRequest place) {
        if (place.isUpdateLocationBarAllowed()) {
            if (place instanceof PathPlaceRequest) {
                this.currentBookmarkableURLStatus = BookmarkableUrlHelper.registerCloseEditor(this.currentBookmarkableURLStatus, place);
            } else {
                String id = place.getIdentifier();
                if (activity.isType(ActivityResourceType.SCREEN.name())) {
                    String token = BookmarkableUrlHelper.getUrlToken(this.currentBookmarkableURLStatus, id);
                    this.currentBookmarkableURLStatus = BookmarkableUrlHelper.registerClose(this.currentBookmarkableURLStatus, token);
                }
            }
            this.updateHistoryBar();
        }
    }

    public void flush() {
        this.currentBookmarkableURLStatus = "";
    }

    public String getToken() {
        return this.historian.getToken();
    }

    public void registerOpenDock(@Observes UberfireDocksInteractionEvent event) {
        if (event.getType() == UberfireDocksInteractionEvent.InteractionType.OPENED) {
            this.currentBookmarkableURLStatus = BookmarkableUrlHelper.registerOpenedDock(this.currentBookmarkableURLStatus, event.getTargetDock());
            this.updateHistoryBar();
        }
    }

    public void registerCloseDock(@Observes UberfireDocksInteractionEvent event) {
        if (event.getType() == UberfireDocksInteractionEvent.InteractionType.CLOSED) {
            this.currentBookmarkableURLStatus = BookmarkableUrlHelper.registerClosedDock(this.currentBookmarkableURLStatus, event.getTargetDock());
            this.updateHistoryBar();
        }
    }

    private /* synthetic */ void lambda$initialize$1(com.google.web.bindery.event.shared.HandlerRegistration historyReg) {
        this.defaultPlaceRequest = DefaultPlaceRequest.NOWHERE;
        this.placeManager = null;
        historyReg.removeHandler();
    }

    public static class DefaultHistorian
    implements Historian {
        @Override
        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> valueChangeHandler) {
            return History.addValueChangeHandler(valueChangeHandler);
        }

        @Override
        public String getToken() {
            return History.getToken();
        }

        @Override
        public void newItem(String token, boolean issueEvent) {
            History.newItem((String)token, (boolean)issueEvent);
        }
    }

    public static interface Historian {
        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> var1);

        public String getToken();

        public void newItem(String var1, boolean var2);
    }
}

