/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.validation;

import javax.xml.transform.dom.DOMResult;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.PSVIAttrNSImpl;
import org.apache.xerces.dom.PSVIDocumentImpl;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.jaxp.validation.DOMDocumentHandler;
import org.apache.xerces.jaxp.validation.DOMValidatorHelper;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

final class DOMResultAugmentor
implements DOMDocumentHandler {
    private final DOMValidatorHelper fDOMValidatorHelper;
    private Document fDocument;
    private CoreDocumentImpl fDocumentImpl;
    private boolean fStorePSVI;
    private boolean fIgnoreChars;
    private final QName fAttributeQName = new QName();

    public DOMResultAugmentor(DOMValidatorHelper helper) {
        this.fDOMValidatorHelper = helper;
    }

    public void setDOMResult(DOMResult result) {
        this.fIgnoreChars = false;
        if (result != null) {
            Node target = result.getNode();
            this.fDocument = target.getNodeType() == 9 ? (Document)target : target.getOwnerDocument();
            this.fDocumentImpl = this.fDocument instanceof CoreDocumentImpl ? (CoreDocumentImpl)this.fDocument : null;
            this.fStorePSVI = this.fDocument instanceof PSVIDocumentImpl;
            return;
        }
        this.fDocument = null;
        this.fDocumentImpl = null;
        this.fStorePSVI = false;
    }

    public void doctypeDecl(DocumentType node) throws XNIException {
    }

    public void characters(Text node) throws XNIException {
    }

    public void cdata(CDATASection node) throws XNIException {
    }

    public void comment(Comment node) throws XNIException {
    }

    public void processingInstruction(ProcessingInstruction node) throws XNIException {
    }

    public void setIgnoringCharacters(boolean ignore) {
        this.fIgnoreChars = ignore;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        block7: {
            int newLength;
            int i;
            Element currentElement = (Element)this.fDOMValidatorHelper.getCurrentElement();
            NamedNodeMap attrMap = currentElement.getAttributes();
            int oldLength = attrMap.getLength();
            if (this.fDocumentImpl != null) {
                for (i = 0; i < oldLength; ++i) {
                    AttrImpl attr = (AttrImpl)attrMap.item(i);
                    AttributePSVI attrPSVI = (AttributePSVI)attributes.getAugmentations(i).getItem("ATTRIBUTE_PSVI");
                    if (attrPSVI == null || !this.processAttributePSVI(attr, attrPSVI)) continue;
                    ((ElementImpl)currentElement).setIdAttributeNode(attr, true);
                }
            }
            if ((newLength = attributes.getLength()) <= oldLength) break block7;
            if (this.fDocumentImpl == null) {
                for (i = oldLength; i < newLength; ++i) {
                    attributes.getName(i, this.fAttributeQName);
                    currentElement.setAttributeNS(this.fAttributeQName.uri, this.fAttributeQName.rawname, attributes.getValue(i));
                }
            } else {
                for (i = oldLength; i < newLength; ++i) {
                    attributes.getName(i, this.fAttributeQName);
                    AttrImpl attr = (AttrImpl)this.fDocumentImpl.createAttributeNS(this.fAttributeQName.uri, this.fAttributeQName.rawname, this.fAttributeQName.localpart);
                    attr.setValue(attributes.getValue(i));
                    currentElement.setAttributeNodeNS(attr);
                    AttributePSVI attrPSVI = (AttributePSVI)attributes.getAugmentations(i).getItem("ATTRIBUTE_PSVI");
                    if (attrPSVI != null && this.processAttributePSVI(attr, attrPSVI)) {
                        ((ElementImpl)currentElement).setIdAttributeNode(attr, true);
                    }
                    attr.setSpecified(false);
                }
            }
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (!this.fIgnoreChars) {
            Element currentElement = (Element)this.fDOMValidatorHelper.getCurrentElement();
            currentElement.appendChild(this.fDocument.createTextNode(text.toString()));
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.characters(text, augs);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        ElementPSVI elementPSVI;
        Node currentElement = this.fDOMValidatorHelper.getCurrentElement();
        if (augs != null && this.fDocumentImpl != null && (elementPSVI = (ElementPSVI)augs.getItem("ELEMENT_PSVI")) != null) {
            XSTypeDefinition type;
            if (this.fStorePSVI) {
                ((PSVIElementNSImpl)currentElement).setPSVI(elementPSVI);
            }
            if ((type = elementPSVI.getMemberTypeDefinition()) == null) {
                type = elementPSVI.getTypeDefinition();
            }
            ((ElementNSImpl)currentElement).setType(type);
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
    }

    public void endCDATA(Augmentations augs) throws XNIException {
    }

    public void endDocument(Augmentations augs) throws XNIException {
    }

    public void setDocumentSource(XMLDocumentSource source) {
    }

    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    private boolean processAttributePSVI(AttrImpl attr, AttributePSVI attrPSVI) {
        XSTypeDefinition type;
        if (this.fStorePSVI) {
            ((PSVIAttrNSImpl)attr).setPSVI(attrPSVI);
        }
        if ((type = attrPSVI.getMemberTypeDefinition()) == null) {
            type = attrPSVI.getTypeDefinition();
            if (type != null) {
                attr.setType(type);
                return ((XSSimpleType)type).isIDType();
            }
        } else {
            attr.setType(type);
            return ((XSSimpleType)type).isIDType();
        }
        return false;
    }
}

