/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileTimeImpl;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionAttributes;
import org.uberfire.java.nio.base.version.VersionHistory;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.model.CommitHistory;
import org.uberfire.java.nio.fs.jgit.util.model.PathInfo;
import org.uberfire.java.nio.fs.jgit.util.model.PathType;

public class JGitVersionAttributeView
extends VersionAttributeView<JGitPathImpl> {
    private VersionAttributes attrs = null;

    public JGitVersionAttributeView(JGitPathImpl path) {
        super((Path)path);
    }

    public VersionAttributes readAttributes() throws IOException {
        if (this.attrs == null) {
            this.attrs = this.buildAttrs((JGitFileSystem)((JGitPathImpl)this.path).getFileSystem(), ((JGitPathImpl)this.path).getRefTree(), ((JGitPathImpl)this.path).getPath());
        }
        return this.attrs;
    }

    public Class<? extends BasicFileAttributeView>[] viewTypes() {
        return new Class[]{VersionAttributeView.class, JGitVersionAttributeView.class};
    }

    private VersionAttributes buildAttrs(final JGitFileSystem fs, String branchName, String path) {
        final PathInfo pathInfo = fs.getGit().getPathInfo(branchName, path);
        if (pathInfo == null || pathInfo.getPathType().equals((Object)PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path);
        }
        Ref refId = fs.getGit().getRef(branchName);
        final ArrayList<1> records = new ArrayList<1>();
        if (refId != null) {
            try {
                CommitHistory history = fs.getGit().listCommits(refId, pathInfo.getPath());
                for (final RevCommit commit : history.getCommits()) {
                    final String recordPath = history.trackedFileNameChangeFor((AnyObjectId)commit.getId());
                    records.add(new VersionRecord(){

                        public String id() {
                            return commit.name();
                        }

                        public String author() {
                            return commit.getAuthorIdent().getName();
                        }

                        public String email() {
                            return commit.getAuthorIdent().getEmailAddress();
                        }

                        public String comment() {
                            return commit.getFullMessage();
                        }

                        public Date date() {
                            return commit.getAuthorIdent().getWhen();
                        }

                        public String uri() {
                            return fs.getPath(commit.name(), new String[]{recordPath}).toUri().toString();
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Collections.reverse(records);
        return new VersionAttributes(){

            public VersionHistory history() {
                return () -> records;
            }

            public FileTime lastModifiedTime() {
                if (records.size() > 0) {
                    return new FileTimeImpl(((VersionRecord)records.get(records.size() - 1)).date().getTime());
                }
                return null;
            }

            public FileTime lastAccessTime() {
                return this.lastModifiedTime();
            }

            public FileTime creationTime() {
                if (records.size() > 0) {
                    return new FileTimeImpl(((VersionRecord)records.get(0)).date().getTime());
                }
                return null;
            }

            public boolean isRegularFile() {
                return pathInfo.getPathType().equals((Object)PathType.FILE);
            }

            public boolean isDirectory() {
                return pathInfo.getPathType().equals((Object)PathType.DIRECTORY);
            }

            public boolean isSymbolicLink() {
                return false;
            }

            public boolean isOther() {
                return false;
            }

            public long size() {
                return pathInfo.getSize();
            }

            public Object fileKey() {
                return pathInfo.getObjectId() == null ? null : pathInfo.getObjectId().toString();
            }
        };
    }
}

