/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.jsbridge.client;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.ScriptInjector;
import elemental2.dom.DomGlobal;
import elemental2.promise.IThenable;
import elemental2.promise.Promise;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.client.ErraiBus;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.enterprise.client.cdi.api.CDI;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.jsbridge.client.loading.AppFormerJsActivityLoader;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class AppFormerJsBridge {
    private final Workbench workbench;
    private final AppFormerJsActivityLoader appFormerJsLoader;
    private final Promises promises;

    @Inject
    public AppFormerJsBridge(Workbench workbench, AppFormerJsActivityLoader appFormerJsLoader, Promises promises) {
        this.workbench = workbench;
        this.appFormerJsLoader = appFormerJsLoader;
        this.promises = promises;
    }

    public void init(String gwtModuleName) {
        this.workbench.addStartupBlocker(AppFormerJsBridge.class);
        this.exposeBridgeAsNativeJs();
        this.loadAppFormerJsAndReactScripts(gwtModuleName).then(i -> {
            try {
                this.appFormerJsLoader.init(gwtModuleName);
            }
            finally {
                this.workbench.removeStartupBlocker(AppFormerJsBridge.class);
            }
            return this.promises.resolve();
        }).catch_(e -> {
            this.workbench.removeStartupBlocker(AppFormerJsBridge.class);
            return this.promises.resolve();
        });
    }

    public void exposeBridgeAsNativeJs() {
        this.exposeBridge();
    }

    public Promise<Void> loadAppFormerJsAndReactScripts(String gwtModuleName) {
        return this.promises.create((res, rej) -> {
            Consumer<Exception> onError = ex -> {
                this.workbench.removeStartupBlocker(AppFormerJsBridge.class);
                rej.onInvoke(null);
            };
            CallbackProducer<Void> callback = new CallbackProducer<Void>(onError);
            ScriptInjector.fromUrl((String)(gwtModuleName + "/react.production.min.js")).setWindow(ScriptInjector.TOP_WINDOW).setCallback(callback.withSuccess(v -> ScriptInjector.fromUrl((String)(gwtModuleName + "/react-dom.production.min.js")).setWindow(ScriptInjector.TOP_WINDOW).setCallback(callback.withSuccess(v1 -> ScriptInjector.fromUrl((String)(gwtModuleName + "/appformer.js")).setWindow(ScriptInjector.TOP_WINDOW).setCallback(callback.withSuccess(v2 -> ScriptInjector.fromUrl((String)(gwtModuleName + "/AppFormerComponentsRegistry.js")).setWindow(ScriptInjector.TOP_WINDOW).setCallback(callback.withSuccess(v3 -> res.onInvoke((IThenable)null))).inject())).inject())).inject())).inject();
        });
    }

    private native void exposeBridge();

    public void fireEvent(String eventJson) {
        CDI.fireEvent((Object)Marshalling.fromJSON((String)eventJson), (Annotation[])new Annotation[0]);
    }

    public void goTo(String place) {
        SyncBeanManager beanManager = IOC.getBeanManager();
        PlaceManager placeManager = (PlaceManager)beanManager.lookupBean(PlaceManager.class, new Annotation[0]).getInstance();
        placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(place));
    }

    public void goToPath(String uri) {
        SyncBeanManager beanManager = IOC.getBeanManager();
        PlaceManager placeManager = (PlaceManager)beanManager.lookupBean(PlaceManager.class, new Annotation[0]).getInstance();
        PathFactory.PathImpl path = new PathFactory.PathImpl(uri.split("//")[uri.split("//").length - 1], uri);
        placeManager.goTo((Path)path);
    }

    public String translate(String key, Object[] args) {
        SyncBeanManager beanManager = IOC.getBeanManager();
        TranslationService translationService = (TranslationService)beanManager.lookupBean(TranslationService.class, new Annotation[0]).getInstance();
        return translationService.format(key, args);
    }

    public void registerPerspective(Object jsObject) {
        SyncBeanManager beanManager = IOC.getBeanManager();
        AppFormerJsActivityLoader jsLoader = (AppFormerJsActivityLoader)beanManager.lookupBean(AppFormerJsActivityLoader.class, new Annotation[0]).getInstance();
        jsLoader.onComponentLoaded(jsObject);
    }

    public void registerScreen(Object jsObject) {
        SyncBeanManager beanManager = IOC.getBeanManager();
        AppFormerJsActivityLoader jsLoader = (AppFormerJsActivityLoader)beanManager.lookupBean(AppFormerJsActivityLoader.class, new Annotation[0]).getInstance();
        jsLoader.onComponentLoaded(jsObject);
    }

    public Promise<Object> rpc(String path, Object[] params) {
        String[] parts = path.split("\\|");
        String serviceFqcn = parts[0];
        String method = parts[1];
        Annotation[] qualifiers = new Annotation[]{};
        Function<Object, Object> jsonToGwt = object -> {
            try {
                return Marshalling.fromJSON((String)((String)object));
            }
            catch (Exception e) {
                DomGlobal.console.info(new Object[]{"Error converting JS obj to GWT obj", e});
                throw e;
            }
        };
        Function<Object, Object> gwtToJson = value -> value != null ? Marshalling.toJSON((Object)value) : null;
        Object[] gwtParams = Arrays.stream(params).map(jsonToGwt).toArray();
        return new Promise((res, rej) -> MessageBuilder.createCall().call(serviceFqcn).endpoint(method, qualifiers, gwtParams).respondTo(Object.class, value -> res.onInvoke(gwtToJson.apply(value))).errorsHandledBy((e, a) -> {
            rej.onInvoke(e);
            return true;
        }).sendNowWith(ErraiBus.get()));
    }

    private static class CallbackProducer<T> {
        private final Consumer<Exception> onFailure;

        CallbackProducer(Consumer<Exception> onFailure) {
            this.onFailure = onFailure;
        }

        Callback<T, Exception> withSuccess(final Consumer<T> onSuccess) {
            return new Callback<T, Exception>(){

                public void onFailure(Exception e) {
                    onFailure.accept(e);
                }

                public void onSuccess(T t) {
                    onSuccess.accept(t);
                }
            };
        }
    }
}

