/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cdi.workspace;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.inject.Vetoed;
import org.uberfire.backend.server.cdi.workspace.WorkspaceNameResolver;
import org.uberfire.workspace.WorkspaceContext;

@Vetoed
public class WorkspaceExecutorService
implements ExecutorService {
    private WorkspaceNameResolver workspaceNameResolver;
    private ExecutorService executorService;

    public WorkspaceExecutorService() {
    }

    public WorkspaceExecutorService(WorkspaceNameResolver workspaceNameResolver, ExecutorService executorService) {
        this.workspaceNameResolver = workspaceNameResolver;
        this.executorService = executorService;
    }

    private String getWorkspaceName() {
        return this.getWorkspaceNameResolver().getWorkspaceName();
    }

    @Override
    public void shutdown() {
        this.getExecutorService().shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.getExecutorService().shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.getExecutorService().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.getExecutorService().isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.getExecutorService().awaitTermination(l, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.getExecutorService().submit(this.generateCallable(callable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.getExecutorService().submit(this.generateRunnable(runnable), t);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.getExecutorService().submit(this.generateRunnable(runnable));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        return this.getExecutorService().invokeAll(collection);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.getExecutorService().invokeAll(collection, l, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        return this.getExecutorService().invokeAny(collection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getExecutorService().invokeAny(collection, l, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        this.getExecutorService().execute(this.generateRunnable(runnable));
    }

    private Runnable generateRunnable(Runnable runnable) {
        String workspace = this.getWorkspaceName();
        return () -> {
            WorkspaceContext.set((String)workspace);
            runnable.run();
        };
    }

    private <T> Callable<T> generateCallable(Callable<T> callable) {
        String workspace = this.getWorkspaceName();
        return () -> {
            WorkspaceContext.set((String)workspace);
            return callable.call();
        };
    }

    private ExecutorService getExecutorService() {
        return this.executorService;
    }

    private WorkspaceNameResolver getWorkspaceNameResolver() {
        return this.workspaceNameResolver;
    }
}

