/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl.validation;

import java.util.Collections;
import java.util.function.Predicate;
import org.uberfire.preferences.shared.PropertyValidator;
import org.uberfire.preferences.shared.impl.validation.ValidationResult;

public class StringPropertyValidator
implements PropertyValidator<String> {
    private Predicate<String> predicate;
    private String errorIfNotValid;

    public StringPropertyValidator(Predicate<String> predicate, String errorIfNotValid) {
        this.predicate = predicate;
        this.errorIfNotValid = errorIfNotValid;
    }

    @Override
    public ValidationResult validate(String value) {
        boolean isValid = this.predicate.test(value);
        if (isValid) {
            return new ValidationResult(true, Collections.emptyList());
        }
        return new ValidationResult(false, Collections.singletonList(this.errorIfNotValid));
    }
}

