/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import org.apache.sshd.common.config.keys.loader.PrivateKeyObfuscator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class AbstractPrivateKeyObfuscator
implements PrivateKeyObfuscator {
    private final String algName;

    protected AbstractPrivateKeyObfuscator(String name) {
        this.algName = ValidateUtils.checkNotNullAndNotEmpty(name, "No name specified");
    }

    @Override
    public final String getCipherName() {
        return this.algName;
    }

    @Override
    public byte[] generateInitializationVector(PrivateKeyEncryptionContext encContext) throws GeneralSecurityException {
        return this.generateInitializationVector(this.resolveKeyLength(encContext));
    }

    @Override
    public <A extends Appendable> A appendPrivateKeyEncryptionContext(A sb, PrivateKeyEncryptionContext encContext) throws IOException {
        if (encContext == null) {
            return sb;
        }
        sb.append("DEK-Info: ").append(encContext.getCipherName()).append('-').append(encContext.getCipherType()).append('-').append(encContext.getCipherMode());
        byte[] initVector = encContext.getInitVector();
        Objects.requireNonNull(initVector, "No encryption init vector");
        ValidateUtils.checkTrue(initVector.length > 0, "Empty encryption init vector");
        BufferUtils.appendHex(sb.append(','), '\u0000', initVector);
        sb.append(System.lineSeparator());
        return sb;
    }

    protected byte[] generateInitializationVector(int keyLength) {
        int keySize = keyLength / 8;
        if (keyLength % 8 != 0) {
            ++keySize;
        }
        byte[] initVector = new byte[keySize];
        SecureRandom randomizer = new SecureRandom();
        ((Random)randomizer).nextBytes(initVector);
        return initVector;
    }

    protected abstract int resolveKeyLength(PrivateKeyEncryptionContext var1) throws GeneralSecurityException;

    protected byte[] deriveEncryptionKey(PrivateKeyEncryptionContext encContext, int outputKeyLength) throws GeneralSecurityException {
        Objects.requireNonNull(encContext, "No encryption context");
        ValidateUtils.checkNotNullAndNotEmpty(encContext.getCipherName(), "No cipher name");
        ValidateUtils.checkNotNullAndNotEmpty(encContext.getCipherType(), "No cipher type");
        ValidateUtils.checkNotNullAndNotEmpty(encContext.getCipherMode(), "No cipher mode");
        byte[] initVector = Objects.requireNonNull(encContext.getInitVector(), "No encryption init vector");
        ValidateUtils.checkTrue(initVector.length > 0, "Empty encryption init vector");
        String password = ValidateUtils.checkNotNullAndNotEmpty(encContext.getPassword(), "No encryption password");
        byte[] passBytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] keyValue = new byte[outputKeyLength];
        MessageDigest hash = SecurityUtils.getMessageDigest("md5");
        byte[] prevHash = GenericUtils.EMPTY_BYTE_ARRAY;
        int index = 0;
        int remLen = keyValue.length;
        while (index < keyValue.length) {
            hash.reset();
            hash.update(prevHash, 0, prevHash.length);
            hash.update(passBytes, 0, passBytes.length);
            hash.update(initVector, 0, Math.min(initVector.length, 8));
            prevHash = hash.digest();
            System.arraycopy(prevHash, 0, keyValue, index, Math.min(remLen, prevHash.length));
            index += prevHash.length;
            remLen -= prevHash.length;
        }
        return keyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] applyPrivateKeyCipher(byte[] bytes, PrivateKeyEncryptionContext encContext, int numBits, byte[] keyValue, boolean encryptIt) throws GeneralSecurityException {
        Objects.requireNonNull(encContext, "No encryption context");
        String cipherName = ValidateUtils.checkNotNullAndNotEmpty(encContext.getCipherName(), "No cipher name");
        ValidateUtils.checkNotNullAndNotEmpty(encContext.getCipherType(), "No cipher type");
        String cipherMode = ValidateUtils.checkNotNullAndNotEmpty(encContext.getCipherMode(), "No cipher mode");
        Objects.requireNonNull(bytes, "No source data");
        Objects.requireNonNull(keyValue, "No encryption key");
        ValidateUtils.checkTrue(keyValue.length > 0, "Empty encryption key");
        byte[] initVector = Objects.requireNonNull(encContext.getInitVector(), "No encryption init vector");
        ValidateUtils.checkTrue(initVector.length > 0, "Empty encryption init vector");
        String xform = cipherName + "/" + cipherMode + "/NoPadding";
        int maxAllowedBits = Cipher.getMaxAllowedKeyLength(xform);
        if (numBits > maxAllowedBits) {
            throw new InvalidKeySpecException("applyPrivateKeyCipher(" + xform + ")[encrypt=" + encryptIt + "]" + " required key length (" + numBits + ")" + " exceeds max. available: " + maxAllowedBits);
        }
        SecretKeySpec skeySpec = new SecretKeySpec(keyValue, cipherName);
        IvParameterSpec ivspec = new IvParameterSpec(initVector);
        Cipher cipher = SecurityUtils.getCipher(xform);
        int blockSize = cipher.getBlockSize();
        int dataSize = bytes.length;
        cipher.init(encryptIt ? 1 : 2, (Key)skeySpec, ivspec);
        if (blockSize <= 0) {
            return cipher.doFinal(bytes);
        }
        int remLen = dataSize % blockSize;
        if (remLen <= 0) {
            return cipher.doFinal(bytes);
        }
        int updateSize = dataSize - remLen;
        byte[] lastBlock = new byte[blockSize];
        Arrays.fill(lastBlock, (byte)10);
        System.arraycopy(bytes, updateSize, lastBlock, 0, remLen);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(dataSize);
        try {
            try {
                byte[] buf = cipher.update(bytes, 0, updateSize);
                baos.write(buf);
                buf = cipher.doFinal(lastBlock);
                baos.write(buf);
            }
            finally {
                baos.close();
            }
        }
        catch (IOException e) {
            throw new GeneralSecurityException("applyPrivateKeyCipher(" + xform + ")[encrypt=" + encryptIt + "]" + " failed (" + e.getClass().getSimpleName() + ")" + " to split-write: " + e.getMessage(), e);
        }
        return baos.toByteArray();
    }
}

