/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.subsystem.sftp;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.subsystem.sftp.SftpException;
import org.apache.sshd.common.subsystem.sftp.SftpUniversalOwnerAndGroup;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.subsystem.sftp.DefaultGroupPrincipal;
import org.apache.sshd.server.subsystem.sftp.InvalidHandleException;
import org.apache.sshd.server.subsystem.sftp.UnixDateFormat;

public final class SftpHelper {
    public static final String APPEND_END_OF_LIST_INDICATOR = "sftp-append-eol-indicator";
    public static final boolean DEFAULT_APPEND_END_OF_LIST_INDICATOR = true;

    private SftpHelper() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static Boolean getEndOfFileIndicatorValue(Buffer buffer, int version) {
        return version < 6 || buffer.available() < 1 ? null : Boolean.valueOf(buffer.getBoolean());
    }

    public static Boolean getEndOfListIndicatorValue(Buffer buffer, int version) {
        return version < 6 || buffer.available() < 1 ? null : Boolean.valueOf(buffer.getBoolean());
    }

    public static Boolean indicateEndOfNamesList(Buffer buffer, int version, PropertyResolver resolver) {
        return SftpHelper.indicateEndOfNamesList(buffer, version, resolver, Boolean.TRUE);
    }

    public static Boolean indicateEndOfNamesList(Buffer buffer, int version, PropertyResolver resolver, Boolean indicatorValue) {
        if (version < 6 || indicatorValue == null) {
            return null;
        }
        if (!resolver.getBooleanProperty(APPEND_END_OF_LIST_INDICATOR, true)) {
            return null;
        }
        buffer.putBoolean(indicatorValue);
        return indicatorValue;
    }

    public static void writeAttrs(Buffer buffer, int version, Map<String, ?> attributes) {
        if (version == 3) {
            SftpHelper.writeAttrsV3(buffer, version, attributes);
        } else if (version >= 4) {
            SftpHelper.writeAttrsV4(buffer, version, attributes);
        } else {
            throw new IllegalStateException("Unsupported SFTP version: " + version);
        }
    }

    public static void writeAttrsV3(Buffer buffer, int version, Map<String, ?> attributes) {
        ValidateUtils.checkTrue(version == 3, "Illegal version: %d", version);
        boolean isReg = SftpHelper.getBool((Boolean)attributes.get("isRegularFile"));
        boolean isDir = SftpHelper.getBool((Boolean)attributes.get("isDirectory"));
        boolean isLnk = SftpHelper.getBool((Boolean)attributes.get("isSymbolicLink"));
        Collection perms = (Collection)attributes.get("permissions");
        Number size = (Number)attributes.get("size");
        FileTime lastModifiedTime = (FileTime)attributes.get("lastModifiedTime");
        FileTime lastAccessTime = (FileTime)attributes.get("lastAccessTime");
        Map extensions = (Map)attributes.get("extended");
        int flags = ((isReg || isLnk) && size != null ? 1 : 0) | (attributes.containsKey("uid") && attributes.containsKey("gid") ? 2 : 0) | (perms != null ? 4 : 0) | (lastModifiedTime != null && lastAccessTime != null ? 8 : 0) | (extensions != null ? Integer.MIN_VALUE : 0);
        buffer.putInt(flags);
        if ((flags & 1) != 0) {
            buffer.putLong(size.longValue());
        }
        if ((flags & 2) != 0) {
            buffer.putInt(((Number)attributes.get("uid")).intValue());
            buffer.putInt(((Number)attributes.get("gid")).intValue());
        }
        if ((flags & 4) != 0) {
            buffer.putInt(SftpHelper.attributesToPermissions(isReg, isDir, isLnk, perms));
        }
        if ((flags & 8) != 0) {
            SftpHelper.writeTime(buffer, version, flags, lastAccessTime);
            SftpHelper.writeTime(buffer, version, flags, lastModifiedTime);
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            SftpHelper.writeExtensions(buffer, extensions);
        }
    }

    public static void writeAttrsV4(Buffer buffer, int version, Map<String, ?> attributes) {
        ValidateUtils.checkTrue(version >= 4, "Illegal version: %d", version);
        boolean isReg = SftpHelper.getBool((Boolean)attributes.get("isRegularFile"));
        boolean isDir = SftpHelper.getBool((Boolean)attributes.get("isDirectory"));
        boolean isLnk = SftpHelper.getBool((Boolean)attributes.get("isSymbolicLink"));
        Collection perms = (Collection)attributes.get("permissions");
        Number size = (Number)attributes.get("size");
        FileTime lastModifiedTime = (FileTime)attributes.get("lastModifiedTime");
        FileTime lastAccessTime = (FileTime)attributes.get("lastAccessTime");
        FileTime creationTime = (FileTime)attributes.get("creationTime");
        Collection acl = (Collection)attributes.get("acl");
        Map extensions = (Map)attributes.get("extended");
        int flags = ((isReg || isLnk) && size != null ? 1 : 0) | (attributes.containsKey("owner") && attributes.containsKey("group") ? 128 : 0) | (perms != null ? 4 : 0) | (lastModifiedTime != null ? 32 : 0) | (creationTime != null ? 16 : 0) | (lastAccessTime != null ? 8 : 0) | (acl != null ? 64 : 0) | (extensions != null ? Integer.MIN_VALUE : 0);
        buffer.putInt(flags);
        buffer.putByte((byte)(isReg ? 1 : (isDir ? 2 : (isLnk ? 3 : 5))));
        if ((flags & 1) != 0) {
            buffer.putLong(size.longValue());
        }
        if ((flags & 0x80) != 0) {
            buffer.putString(Objects.toString(attributes.get("owner"), SftpUniversalOwnerAndGroup.Owner.getName()));
            buffer.putString(Objects.toString(attributes.get("group"), SftpUniversalOwnerAndGroup.Group.getName()));
        }
        if ((flags & 4) != 0) {
            buffer.putInt(SftpHelper.attributesToPermissions(isReg, isDir, isLnk, perms));
        }
        if ((flags & 8) != 0) {
            SftpHelper.writeTime(buffer, version, flags, lastAccessTime);
        }
        if ((flags & 0x10) != 0) {
            SftpHelper.writeTime(buffer, version, flags, lastAccessTime);
        }
        if ((flags & 0x20) != 0) {
            SftpHelper.writeTime(buffer, version, flags, lastModifiedTime);
        }
        if ((flags & 0x40) != 0) {
            SftpHelper.writeACLs(buffer, version, acl);
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            SftpHelper.writeExtensions(buffer, extensions);
        }
    }

    public static boolean getBool(Boolean bool) {
        return bool != null && bool != false;
    }

    public static int attributesToPermissions(boolean isReg, boolean isDir, boolean isLnk, Collection<PosixFilePermission> perms) {
        int pf = 0;
        if (perms != null) {
            for (PosixFilePermission p : perms) {
                switch (p) {
                    case OWNER_READ: {
                        pf |= 0x100;
                        break;
                    }
                    case OWNER_WRITE: {
                        pf |= 0x80;
                        break;
                    }
                    case OWNER_EXECUTE: {
                        pf |= 0x40;
                        break;
                    }
                    case GROUP_READ: {
                        pf |= 0x20;
                        break;
                    }
                    case GROUP_WRITE: {
                        pf |= 0x10;
                        break;
                    }
                    case GROUP_EXECUTE: {
                        pf |= 8;
                        break;
                    }
                    case OTHERS_READ: {
                        pf |= 4;
                        break;
                    }
                    case OTHERS_WRITE: {
                        pf |= 2;
                        break;
                    }
                    case OTHERS_EXECUTE: {
                        pf |= 1;
                        break;
                    }
                }
            }
        }
        pf |= isReg ? 32768 : 0;
        pf |= isDir ? 16384 : 0;
        return pf |= isLnk ? 40960 : 0;
    }

    public static int permissionsToFileType(int perms) {
        if ((0xA000 & perms) == 40960) {
            return 3;
        }
        if ((0x8000 & perms) == 32768) {
            return 1;
        }
        if ((0x4000 & perms) == 16384) {
            return 2;
        }
        if ((0xC000 & perms) == 49152) {
            return 6;
        }
        if ((0x6000 & perms) == 24576) {
            return 8;
        }
        if ((0x2000 & perms) == 8192) {
            return 7;
        }
        if ((0x1000 & perms) == 4096) {
            return 9;
        }
        return 5;
    }

    public static int fileTypeToPermission(int type) {
        switch (type) {
            case 1: {
                return 32768;
            }
            case 2: {
                return 16384;
            }
            case 3: {
                return 40960;
            }
            case 6: {
                return 49152;
            }
            case 8: {
                return 24576;
            }
            case 7: {
                return 8192;
            }
            case 9: {
                return 4096;
            }
        }
        return 0;
    }

    public static Set<PosixFilePermission> permissionsToAttributes(int perms) {
        EnumSet<PosixFilePermission> p = EnumSet.noneOf(PosixFilePermission.class);
        if ((perms & 0x100) != 0) {
            p.add(PosixFilePermission.OWNER_READ);
        }
        if ((perms & 0x80) != 0) {
            p.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((perms & 0x40) != 0) {
            p.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((perms & 0x20) != 0) {
            p.add(PosixFilePermission.GROUP_READ);
        }
        if ((perms & 0x10) != 0) {
            p.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((perms & 8) != 0) {
            p.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((perms & 4) != 0) {
            p.add(PosixFilePermission.OTHERS_READ);
        }
        if ((perms & 2) != 0) {
            p.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((perms & 1) != 0) {
            p.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return p;
    }

    public static int resolveSubstatus(Throwable t) {
        if (t instanceof NoSuchFileException || t instanceof FileNotFoundException) {
            return 2;
        }
        if (t instanceof InvalidHandleException) {
            return 9;
        }
        if (t instanceof FileAlreadyExistsException) {
            return 11;
        }
        if (t instanceof DirectoryNotEmptyException) {
            return 18;
        }
        if (t instanceof NotDirectoryException) {
            return 19;
        }
        if (t instanceof AccessDeniedException) {
            return 3;
        }
        if (t instanceof EOFException) {
            return 1;
        }
        if (t instanceof OverlappingFileLockException) {
            return 17;
        }
        if (t instanceof UnsupportedOperationException) {
            return 8;
        }
        if (t instanceof InvalidPathException) {
            return 20;
        }
        if (t instanceof IllegalArgumentException) {
            return 23;
        }
        if (t instanceof UnsupportedOperationException) {
            return 8;
        }
        if (t instanceof UserPrincipalNotFoundException) {
            return 16;
        }
        if (t instanceof FileSystemLoopException) {
            return 21;
        }
        if (t instanceof SftpException) {
            return ((SftpException)t).getStatus();
        }
        return 4;
    }

    public static String resolveStatusMessage(Throwable t) {
        if (t == null) {
            return "";
        }
        if (t instanceof SftpException) {
            return t.toString();
        }
        return "Internal " + t.getClass().getSimpleName() + ": " + t.getMessage();
    }

    public static Map<String, Object> readAttrs(Buffer buffer, int version) {
        TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        int flags = buffer.getInt();
        if (version >= 4) {
            int type = buffer.getUByte();
            switch (type) {
                case 1: {
                    attrs.put("isRegular", Boolean.TRUE);
                    break;
                }
                case 2: {
                    attrs.put("isDirectory", Boolean.TRUE);
                    break;
                }
                case 3: {
                    attrs.put("isSymbolicLink", Boolean.TRUE);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    attrs.put("isOther", Boolean.TRUE);
                    break;
                }
            }
        }
        if ((flags & 1) != 0) {
            attrs.put("size", buffer.getLong());
        }
        if (version == 3) {
            if ((flags & 2) != 0) {
                attrs.put("uid", buffer.getInt());
                attrs.put("gid", buffer.getInt());
            }
        } else {
            if (version >= 6 && (flags & 0x400) != 0) {
                long type = buffer.getLong();
            }
            if ((flags & 0x80) != 0) {
                attrs.put("owner", new DefaultGroupPrincipal(buffer.getString()));
                attrs.put("group", new DefaultGroupPrincipal(buffer.getString()));
            }
        }
        if ((flags & 4) != 0) {
            attrs.put("permissions", SftpHelper.permissionsToAttributes(buffer.getInt()));
        }
        if (version == 3) {
            if ((flags & 8) != 0) {
                attrs.put("lastAccessTime", SftpHelper.readTime(buffer, version, flags));
                attrs.put("lastModifiedTime", SftpHelper.readTime(buffer, version, flags));
            }
        } else if (version >= 4) {
            if ((flags & 8) != 0) {
                attrs.put("lastAccessTime", SftpHelper.readTime(buffer, version, flags));
            }
            if ((flags & 0x10) != 0) {
                attrs.put("creationTime", SftpHelper.readTime(buffer, version, flags));
            }
            if ((flags & 0x20) != 0) {
                attrs.put("lastModifiedTime", SftpHelper.readTime(buffer, version, flags));
            }
            if (version >= 6 && (flags & 0x8000) != 0) {
                attrs.put("ctime", SftpHelper.readTime(buffer, version, flags));
            }
            if ((flags & 0x40) != 0) {
                attrs.put("acl", SftpHelper.readACLs(buffer, version));
            }
            if ((flags & 0x200) != 0) {
                int bits = buffer.getInt();
                int valid = -1;
                if (version >= 6) {
                    valid = buffer.getInt();
                }
            }
            if (version >= 6) {
                if ((flags & 0x800) != 0) {
                    boolean bl = buffer.getBoolean();
                }
                if ((flags & 0x1000) != 0) {
                    String string = buffer.getString();
                }
                if ((flags & 0x2000) != 0) {
                    int n = buffer.getInt();
                }
                if ((flags & 0x4000) != 0) {
                    String string = buffer.getString();
                }
            }
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            attrs.put("extended", SftpHelper.readExtensions(buffer));
        }
        return attrs;
    }

    public static Map<String, byte[]> readExtensions(Buffer buffer) {
        int count = buffer.getInt();
        TreeMap<String, byte[]> extended = new TreeMap<String, byte[]>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < count; ++i) {
            byte[] val;
            String key = buffer.getString();
            byte[] prev = extended.put(key, val = buffer.getBytes());
            ValidateUtils.checkTrue(prev == null, "Duplicate values for extended key=%s", (Object)key);
        }
        return extended;
    }

    public static void writeExtensions(Buffer buffer, Map<?, ?> extensions) {
        int numExtensions = GenericUtils.size(extensions);
        buffer.putInt(numExtensions);
        if (numExtensions > 0) {
            extensions.forEach((key, value) -> {
                Objects.requireNonNull(key, "No extension type");
                Objects.requireNonNull(value, "No extension value");
                buffer.putString(key.toString());
                if (value instanceof byte[]) {
                    buffer.putBytes((byte[])value);
                } else {
                    buffer.putString(value.toString());
                }
            });
        }
    }

    public static Map<String, String> toStringExtensions(Map<String, ?> extensions) {
        if (GenericUtils.isEmpty(extensions)) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        extensions.forEach((key, value) -> {
            ValidateUtils.checkNotNull(value, "No value for extension=%s", key);
            String prev = map.put((String)key, value instanceof byte[] ? new String((byte[])value, StandardCharsets.UTF_8) : value.toString());
            ValidateUtils.checkTrue(prev == null, "Multiple values for extension=%s", key);
        });
        return map;
    }

    public static Map<String, byte[]> toBinaryExtensions(Map<String, String> extensions) {
        if (GenericUtils.isEmpty(extensions)) {
            return Collections.emptyMap();
        }
        TreeMap<String, byte[]> map = new TreeMap<String, byte[]>(String.CASE_INSENSITIVE_ORDER);
        extensions.forEach((key, value) -> {
            ValidateUtils.checkNotNull(value, "No value for extension=%s", key);
            byte[] prev = map.put((String)key, value.getBytes(StandardCharsets.UTF_8));
            ValidateUtils.checkTrue(prev == null, "Multiple values for extension=%s", key);
        });
        return map;
    }

    public static List<AclEntry> readACLs(Buffer buffer, int version) {
        int aclSize = buffer.getInt();
        int startPos = buffer.rpos();
        ByteArrayBuffer aclBuffer = new ByteArrayBuffer(buffer.array(), startPos, aclSize, true);
        List<AclEntry> acl = SftpHelper.decodeACLs(aclBuffer, version);
        buffer.rpos(startPos + aclSize);
        return acl;
    }

    public static List<AclEntry> decodeACLs(Buffer buffer, int version) {
        int count;
        int aclFlags = 0;
        if (version >= 6) {
            aclFlags = buffer.getInt();
        }
        ValidateUtils.checkTrue((count = buffer.getInt()) >= 0, "Invalid ACL entries count: %d", count);
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<AclEntry> acls = new ArrayList<AclEntry>(count);
        for (int i = 0; i < count; ++i) {
            int aclType = buffer.getInt();
            int aclFlag = buffer.getInt();
            int aclMask = buffer.getInt();
            String aclWho = buffer.getString();
            acls.add(SftpHelper.buildAclEntry(aclType, aclFlag, aclMask, aclWho));
        }
        return acls;
    }

    public static AclEntry buildAclEntry(int aclType, int aclFlag, int aclMask, String aclWho) {
        DefaultGroupPrincipal who = new DefaultGroupPrincipal(aclWho);
        return AclEntry.newBuilder().setType(ValidateUtils.checkNotNull(SftpHelper.decodeAclEntryType(aclType), "Unknown ACL type: %d", aclType)).setFlags(SftpHelper.decodeAclFlags(aclFlag)).setPermissions(SftpHelper.decodeAclMask(aclMask)).setPrincipal(who).build();
    }

    public static AclEntryType decodeAclEntryType(int aclType) {
        switch (aclType) {
            case 0: {
                return AclEntryType.ALLOW;
            }
            case 1: {
                return AclEntryType.DENY;
            }
            case 2: {
                return AclEntryType.AUDIT;
            }
            case 3: {
                return AclEntryType.ALARM;
            }
        }
        return null;
    }

    public static Set<AclEntryFlag> decodeAclFlags(int aclFlag) {
        EnumSet<AclEntryFlag> flags = EnumSet.noneOf(AclEntryFlag.class);
        if ((aclFlag & 1) != 0) {
            flags.add(AclEntryFlag.FILE_INHERIT);
        }
        if ((aclFlag & 2) != 0) {
            flags.add(AclEntryFlag.DIRECTORY_INHERIT);
        }
        if ((aclFlag & 4) != 0) {
            flags.add(AclEntryFlag.NO_PROPAGATE_INHERIT);
        }
        if ((aclFlag & 8) != 0) {
            flags.add(AclEntryFlag.INHERIT_ONLY);
        }
        return flags;
    }

    public static Set<AclEntryPermission> decodeAclMask(int aclMask) {
        EnumSet<AclEntryPermission> mask = EnumSet.noneOf(AclEntryPermission.class);
        if ((aclMask & 1) != 0) {
            mask.add(AclEntryPermission.READ_DATA);
        }
        if ((aclMask & 1) != 0) {
            mask.add(AclEntryPermission.LIST_DIRECTORY);
        }
        if ((aclMask & 2) != 0) {
            mask.add(AclEntryPermission.WRITE_DATA);
        }
        if ((aclMask & 2) != 0) {
            mask.add(AclEntryPermission.ADD_FILE);
        }
        if ((aclMask & 4) != 0) {
            mask.add(AclEntryPermission.APPEND_DATA);
        }
        if ((aclMask & 4) != 0) {
            mask.add(AclEntryPermission.ADD_SUBDIRECTORY);
        }
        if ((aclMask & 8) != 0) {
            mask.add(AclEntryPermission.READ_NAMED_ATTRS);
        }
        if ((aclMask & 0x10) != 0) {
            mask.add(AclEntryPermission.WRITE_NAMED_ATTRS);
        }
        if ((aclMask & 0x20) != 0) {
            mask.add(AclEntryPermission.EXECUTE);
        }
        if ((aclMask & 0x40) != 0) {
            mask.add(AclEntryPermission.DELETE_CHILD);
        }
        if ((aclMask & 0x80) != 0) {
            mask.add(AclEntryPermission.READ_ATTRIBUTES);
        }
        if ((aclMask & 0x100) != 0) {
            mask.add(AclEntryPermission.WRITE_ATTRIBUTES);
        }
        if ((aclMask & 0x10000) != 0) {
            mask.add(AclEntryPermission.DELETE);
        }
        if ((aclMask & 0x20000) != 0) {
            mask.add(AclEntryPermission.READ_ACL);
        }
        if ((aclMask & 0x40000) != 0) {
            mask.add(AclEntryPermission.WRITE_ACL);
        }
        if ((aclMask & 0x80000) != 0) {
            mask.add(AclEntryPermission.WRITE_OWNER);
        }
        if ((aclMask & 0x100000) != 0) {
            mask.add(AclEntryPermission.SYNCHRONIZE);
        }
        return mask;
    }

    public static void writeACLs(Buffer buffer, int version, Collection<? extends AclEntry> acl) {
        int lenPos = buffer.wpos();
        buffer.putInt(0L);
        SftpHelper.encodeACLs(buffer, version, acl);
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
    }

    public static void encodeACLs(Buffer buffer, int version, Collection<? extends AclEntry> acl) {
        Objects.requireNonNull(acl, "No ACL");
        if (version >= 6) {
            buffer.putInt(0L);
        }
        int numEntries = GenericUtils.size(acl);
        buffer.putInt(numEntries);
        if (numEntries > 0) {
            for (AclEntry aclEntry : acl) {
                SftpHelper.writeAclEntry(buffer, aclEntry);
            }
        }
    }

    public static void writeAclEntry(Buffer buffer, AclEntry acl) {
        Objects.requireNonNull(acl, "No ACL");
        AclEntryType type = acl.type();
        int aclType = SftpHelper.encodeAclEntryType(type);
        ValidateUtils.checkTrue(aclType >= 0, "Unknown ACL type: %s", (Object)type);
        buffer.putInt(aclType);
        buffer.putInt(SftpHelper.encodeAclFlags(acl.flags()));
        buffer.putInt(SftpHelper.encodeAclMask(acl.permissions()));
        UserPrincipal user = acl.principal();
        buffer.putString(user.getName());
    }

    public static int encodeAclEntryType(AclEntryType type) {
        if (type == null) {
            return Integer.MIN_VALUE;
        }
        switch (type) {
            case ALARM: {
                return 3;
            }
            case ALLOW: {
                return 0;
            }
            case AUDIT: {
                return 2;
            }
            case DENY: {
                return 1;
            }
        }
        return -1;
    }

    public static long encodeAclFlags(Collection<AclEntryFlag> flags) {
        if (GenericUtils.isEmpty(flags)) {
            return 0L;
        }
        long aclFlag = 0L;
        if (flags.contains((Object)AclEntryFlag.FILE_INHERIT)) {
            aclFlag |= 1L;
        }
        if (flags.contains((Object)AclEntryFlag.DIRECTORY_INHERIT)) {
            aclFlag |= 2L;
        }
        if (flags.contains((Object)AclEntryFlag.NO_PROPAGATE_INHERIT)) {
            aclFlag |= 4L;
        }
        if (flags.contains((Object)AclEntryFlag.INHERIT_ONLY)) {
            aclFlag |= 8L;
        }
        return aclFlag;
    }

    public static long encodeAclMask(Collection<AclEntryPermission> mask) {
        if (GenericUtils.isEmpty(mask)) {
            return 0L;
        }
        long aclMask = 0L;
        if (mask.contains((Object)AclEntryPermission.READ_DATA)) {
            aclMask |= 1L;
        }
        if (mask.contains((Object)AclEntryPermission.LIST_DIRECTORY)) {
            aclMask |= 1L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_DATA)) {
            aclMask |= 2L;
        }
        if (mask.contains((Object)AclEntryPermission.ADD_FILE)) {
            aclMask |= 2L;
        }
        if (mask.contains((Object)AclEntryPermission.APPEND_DATA)) {
            aclMask |= 4L;
        }
        if (mask.contains((Object)AclEntryPermission.ADD_SUBDIRECTORY)) {
            aclMask |= 4L;
        }
        if (mask.contains((Object)AclEntryPermission.READ_NAMED_ATTRS)) {
            aclMask |= 8L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_NAMED_ATTRS)) {
            aclMask |= 0x10L;
        }
        if (mask.contains((Object)AclEntryPermission.EXECUTE)) {
            aclMask |= 0x20L;
        }
        if (mask.contains((Object)AclEntryPermission.DELETE_CHILD)) {
            aclMask |= 0x40L;
        }
        if (mask.contains((Object)AclEntryPermission.READ_ATTRIBUTES)) {
            aclMask |= 0x80L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_ATTRIBUTES)) {
            aclMask |= 0x100L;
        }
        if (mask.contains((Object)AclEntryPermission.DELETE)) {
            aclMask |= 0x10000L;
        }
        if (mask.contains((Object)AclEntryPermission.READ_ACL)) {
            aclMask |= 0x20000L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_ACL)) {
            aclMask |= 0x40000L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_OWNER)) {
            aclMask |= 0x80000L;
        }
        if (mask.contains((Object)AclEntryPermission.SYNCHRONIZE)) {
            aclMask |= 0x100000L;
        }
        return aclMask;
    }

    public static void writeTime(Buffer buffer, int version, int flags, FileTime time) {
        if (version >= 4) {
            buffer.putLong(time.to(TimeUnit.SECONDS));
            if ((flags & 0x100) != 0) {
                long nanos = time.to(TimeUnit.NANOSECONDS);
                buffer.putInt((int)(nanos %= TimeUnit.SECONDS.toNanos(1L)));
            }
        } else {
            buffer.putInt(time.to(TimeUnit.SECONDS));
        }
    }

    public static FileTime readTime(Buffer buffer, int version, int flags) {
        long secs = version >= 4 ? buffer.getLong() : buffer.getUInt();
        long millis = TimeUnit.SECONDS.toMillis(secs);
        if (version >= 4 && (flags & 0x100) != 0) {
            long nanoseconds = buffer.getUInt();
            millis += TimeUnit.NANOSECONDS.toMillis(nanoseconds);
        }
        return FileTime.from(millis, TimeUnit.MILLISECONDS);
    }

    public static String getLongName(String shortName, Map<String, ?> attributes) {
        int index;
        Number length;
        String owner = Objects.toString(attributes.get("owner"), null);
        String username = OsUtils.getCanonicalUser(owner);
        if (GenericUtils.isEmpty(username)) {
            username = SftpUniversalOwnerAndGroup.Owner.getName();
        }
        String group = Objects.toString(attributes.get("group"), null);
        if (GenericUtils.isEmpty(group = OsUtils.resolveCanonicalGroup(group, owner))) {
            group = SftpUniversalOwnerAndGroup.Group.getName();
        }
        if ((length = (Number)attributes.get("size")) == null) {
            length = 0L;
        }
        String lengthString = String.format("%1$8s", length);
        String linkCount = Objects.toString(attributes.get("nlink"), null);
        if (GenericUtils.isEmpty(linkCount)) {
            linkCount = "1";
        }
        Boolean isDirectory = (Boolean)attributes.get("isDirectory");
        Boolean isLink = (Boolean)attributes.get("isSymbolicLink");
        EnumSet<PosixFilePermission> perms = (EnumSet<PosixFilePermission>)attributes.get("permissions");
        if (perms == null) {
            perms = EnumSet.noneOf(PosixFilePermission.class);
        }
        String permsString = PosixFilePermissions.toString((Set<PosixFilePermission>)perms);
        String timeStamp = UnixDateFormat.getUnixDate((FileTime)attributes.get("lastModifiedTime"));
        StringBuilder sb = new StringBuilder(GenericUtils.length(linkCount) + GenericUtils.length(username) + GenericUtils.length(group) + GenericUtils.length(timeStamp) + GenericUtils.length(lengthString) + GenericUtils.length(permsString) + GenericUtils.length(shortName) + 32);
        sb.append((char)(SftpHelper.getBool(isDirectory) ? 100 : (SftpHelper.getBool(isLink) ? 108 : 45))).append(permsString);
        sb.append(' ');
        for (index = linkCount.length(); index < 3; ++index) {
            sb.append(' ');
        }
        sb.append(linkCount);
        sb.append(' ').append(username);
        for (index = username.length(); index < 8; ++index) {
            sb.append(' ');
        }
        sb.append(' ').append(group);
        for (index = group.length(); index < 8; ++index) {
            sb.append(' ');
        }
        sb.append(' ').append(lengthString).append(' ').append(timeStamp).append(' ').append(shortName);
        return sb.toString();
    }
}

