/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cdi.workspace;

import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.cdi.workspace.WorkspaceScopeContext;
import org.uberfire.backend.server.cdi.workspace.WorkspaceScoped;

public class WorkspaceScopedExtension
implements Extension {
    private Logger logger = LoggerFactory.getLogger(WorkspaceScopedExtension.class);

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Before bean discovery, adding WosrkspaceScoped");
        }
        bbd.addScope(WorkspaceScoped.class, true, false);
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("After bean discovery, adding WorkspaceScopeContext");
        }
        abd.addContext((Context)new WorkspaceScopeContext(beanManager));
    }
}

