/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.jsbridge.client.loading;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.ScriptInjector;
import elemental2.dom.DomGlobal;
import elemental2.promise.Promise;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.jboss.errai.ioc.client.QualifierUtil;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceManagerImpl;
import org.uberfire.client.mvp.WorkbenchEditorActivity;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.client.mvp.jsbridge.JsWorkbenchLazyActivity;
import org.uberfire.client.promise.Promises;
import org.uberfire.jsbridge.client.cdi.EditorActivityBeanDefinition;
import org.uberfire.jsbridge.client.cdi.SingletonBeanDefinition;
import org.uberfire.jsbridge.client.editor.JsNativeEditor;
import org.uberfire.jsbridge.client.editor.JsWorkbenchEditorActivity;
import org.uberfire.jsbridge.client.loading.ActivityLazyLoaded;
import org.uberfire.jsbridge.client.loading.AppFormerComponentsRegistry;
import org.uberfire.jsbridge.client.loading.JsWorkbenchLazyPerspectiveActivity;
import org.uberfire.jsbridge.client.loading.LazyLoadingScreen;
import org.uberfire.jsbridge.client.screen.JsNativeScreen;
import org.uberfire.jsbridge.client.screen.JsWorkbenchScreenActivity;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@EntryPoint
public class AppFormerJsActivityLoader
implements PlaceManagerImpl.AppFormerActivityLoader {
    private final Promises promises;
    private final ActivityManager activityManager;
    private final ActivityBeansCache activityBeansCache;
    private final PlaceManager placeManager;
    private final LazyLoadingScreen lazyLoadingScreen;
    private final Event<ActivityLazyLoaded> activityLazyLoadedEvent;
    private final Instance<JsWorkbenchEditorActivity> jsWorkbenchEditorActivityInstance;
    private final AppFormerComponentsRegistry appFormerComponentsRegistry;
    private final Map<String, String> components = new HashMap<String, String>();
    private final Set<String> loadedScripts = new HashSet<String>();
    final Map<String, AppFormerComponentsRegistry.Entry> editors = new HashMap<String, AppFormerComponentsRegistry.Entry>();
    private String gwtModuleName;

    @Inject
    public AppFormerJsActivityLoader(Promises promises, ActivityManager activityManager, ActivityBeansCache activityBeansCache, PlaceManager placeManager, LazyLoadingScreen lazyLoadingScreen, Event<ActivityLazyLoaded> activityLazyLoadedEvent, @Shadowed Instance<JsWorkbenchEditorActivity> jsWorkbenchEditorActivityInstance, AppFormerComponentsRegistry appFormerComponentsRegistry) {
        this.promises = promises;
        this.activityManager = activityManager;
        this.activityBeansCache = activityBeansCache;
        this.placeManager = placeManager;
        this.lazyLoadingScreen = lazyLoadingScreen;
        this.activityLazyLoadedEvent = activityLazyLoadedEvent;
        this.jsWorkbenchEditorActivityInstance = jsWorkbenchEditorActivityInstance;
        this.appFormerComponentsRegistry = appFormerComponentsRegistry;
    }

    public void init(String gwtModuleName) {
        this.gwtModuleName = gwtModuleName;
        Arrays.stream(this.appFormerComponentsRegistry.keys()).map(this::newRegistryEntry).forEach(this::registerComponent);
    }

    AppFormerComponentsRegistry.Entry newRegistryEntry(String componentId) {
        return new AppFormerComponentsRegistry.Entry(componentId, this.appFormerComponentsRegistry.get(componentId));
    }

    public void onComponentLoaded(Object jsObject) {
        String componentId = this.extractComponentId(jsObject);
        if (this.editors.containsKey(componentId)) {
            this.registerEditor(jsObject, componentId);
            return;
        }
        if (!this.components.containsKey(componentId)) {
            throw new IllegalArgumentException("Cannot find component " + componentId);
        }
        Activity activity = this.updateRealContent((JavaScriptObject)jsObject, componentId);
        this.activityLazyLoadedEvent.fire((Object)new ActivityLazyLoaded(componentId, activity));
    }

    Activity updateRealContent(JavaScriptObject jsObject, String componentId) {
        Activity activity = this.activityManager.getActivity((PlaceRequest)new DefaultPlaceRequest(componentId));
        JsWorkbenchLazyActivity lazyActivity = (JsWorkbenchLazyActivity)activity;
        lazyActivity.updateRealContent(jsObject);
        return activity;
    }

    public native String extractComponentId(Object var1);

    Promise<Void> loadScriptFor(String componentId) {
        Optional<String> scriptFilename = this.getScriptFileName(componentId);
        if (!scriptFilename.isPresent()) {
            throw new RuntimeException("No script found for " + componentId);
        }
        if (this.loadedScripts.contains(scriptFilename.get())) {
            return this.promises.resolve();
        }
        this.loadedScripts.add(scriptFilename.get());
        return this.loadScript(this.gwtModuleName + "/" + scriptFilename.get()).catch_(e -> {
            DomGlobal.console.info(new Object[]{"Error loading script for " + componentId});
            this.loadedScripts.remove(scriptFilename.get());
            return this.promises.reject(e);
        });
    }

    Optional<String> getScriptFileName(String componentId) {
        Optional<String> editorScriptUrl = Optional.ofNullable(this.editors.get(componentId)).map(AppFormerComponentsRegistry.Entry::getSource);
        return editorScriptUrl.isPresent() ? editorScriptUrl : Optional.ofNullable(this.components.get(componentId));
    }

    Promise<Void> loadScript(String scriptUrl) {
        return this.promises.create((res, rej) -> ScriptInjector.fromUrl((String)scriptUrl).setWindow(ScriptInjector.TOP_WINDOW).setCallback(this.getScriptInjectionCallback((Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<Void>)res, rej)).inject());
    }

    private Callback<Void, Exception> getScriptInjectionCallback(final Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<Void> res, final Promise.PromiseExecutorCallbackFn.RejectCallbackFn rej) {
        return new Callback<Void, Exception>(){

            public void onFailure(Exception e1) {
                rej.onInvoke((Object)e1);
            }

            public void onSuccess(Void v) {
                res.onInvoke((Object)v);
            }
        };
    }

    void registerComponent(AppFormerComponentsRegistry.Entry registryEntry) {
        switch (registryEntry.getType()) {
            case PERSPECTIVE: {
                this.registerPerspective(registryEntry);
                this.components.put(registryEntry.getComponentId(), registryEntry.getSource());
                break;
            }
            case SCREEN: {
                this.registerScreen(registryEntry);
                this.components.put(registryEntry.getComponentId(), registryEntry.getSource());
                break;
            }
            case EDITOR: {
                this.registerEditor(registryEntry);
            }
        }
    }

    public boolean triggerLoadOfMatchingEditors(Path path, Runnable successCallback) {
        if (path == null || path.toURI() == null) {
            return false;
        }
        List<Promise<Void>> loadingMatchingEditors = this.loadMatchingEditors(path.toURI());
        if (loadingMatchingEditors.size() <= 0) {
            return false;
        }
        this.finishLoadingMatchingEditors(loadingMatchingEditors, successCallback);
        return true;
    }

    List<Promise<Void>> loadMatchingEditors(String uri) {
        return this.editors.values().stream().filter(e -> e.matches(uri)).filter(e -> !this.loadedScripts.contains(e.getSource())).map(e -> this.loadScriptFor(e.getComponentId())).collect(Collectors.toList());
    }

    protected void finishLoadingMatchingEditors(List<Promise<Void>> loadingMatchingEditors, Runnable successCallback) {
        this.promises.resolve().then(i -> this.promises.all(loadingMatchingEditors, Function.identity()).then(s -> {
            successCallback.run();
            return this.promises.resolve();
        })).catch_(e -> this.promises.resolve());
    }

    void registerEditor(AppFormerComponentsRegistry.Entry registryEntry) {
        this.editors.put(registryEntry.getComponentId(), registryEntry);
    }

    void registerScreen(AppFormerComponentsRegistry.Entry registryEntry) {
        JsNativeScreen newScreen = new JsNativeScreen(registryEntry.getComponentId(), this::loadScriptFor, this.lazyLoadingScreen);
        JsWorkbenchScreenActivity activity = new JsWorkbenchScreenActivity(newScreen, this.placeManager);
        SingletonBeanDefinition<JsWorkbenchScreenActivity, JsWorkbenchScreenActivity> activityBean = new SingletonBeanDefinition<JsWorkbenchScreenActivity, JsWorkbenchScreenActivity>(activity, JsWorkbenchScreenActivity.class, new HashSet<Annotation>(Arrays.asList(QualifierUtil.DEFAULT_QUALIFIERS)), activity.getIdentifier(), true, WorkbenchScreenActivity.class, JsWorkbenchLazyActivity.class, Activity.class);
        this.activityBeansCache.addNewScreenActivity(activityBean);
        SyncBeanManager beanManager = IOC.getBeanManager();
        beanManager.registerBean(activityBean);
        beanManager.registerBeanTypeAlias(activityBean, WorkbenchScreenActivity.class);
        beanManager.registerBeanTypeAlias(activityBean, JsWorkbenchLazyActivity.class);
        beanManager.registerBeanTypeAlias(activityBean, Activity.class);
    }

    void registerPerspective(AppFormerComponentsRegistry.Entry registryEntry) {
        SyncBeanManager beanManager = IOC.getBeanManager();
        ActivityBeansCache activityBeansCache = (ActivityBeansCache)beanManager.lookupBean(ActivityBeansCache.class, new Annotation[0]).getInstance();
        PlaceManager placeManager = (PlaceManager)beanManager.lookupBean(PlaceManager.class, new Annotation[0]).getInstance();
        ActivityManager activityManager = (ActivityManager)beanManager.lookupBean(ActivityManager.class, new Annotation[0]).getInstance();
        JsWorkbenchLazyPerspectiveActivity activity = new JsWorkbenchLazyPerspectiveActivity(registryEntry, placeManager, activityManager, this::loadScriptFor);
        SingletonBeanDefinition<JsWorkbenchLazyPerspectiveActivity, JsWorkbenchLazyPerspectiveActivity> activityBean = new SingletonBeanDefinition<JsWorkbenchLazyPerspectiveActivity, JsWorkbenchLazyPerspectiveActivity>(activity, JsWorkbenchLazyPerspectiveActivity.class, new HashSet<Annotation>(Arrays.asList(QualifierUtil.DEFAULT_QUALIFIERS)), activity.getIdentifier(), true, PerspectiveActivity.class, JsWorkbenchLazyActivity.class, Activity.class);
        beanManager.registerBean(activityBean);
        beanManager.registerBeanTypeAlias(activityBean, PerspectiveActivity.class);
        beanManager.registerBeanTypeAlias(activityBean, JsWorkbenchLazyActivity.class);
        beanManager.registerBeanTypeAlias(activityBean, Activity.class);
        activityBeansCache.addNewPerspectiveActivity((SyncBeanDef)beanManager.lookupBeans(activity.getIdentifier()).iterator().next());
    }

    void registerEditor(Object jsObject, String componentId) {
        JsNativeEditor editor = new JsNativeEditor(componentId, jsObject);
        SyncBeanManager beanManager = IOC.getBeanManager();
        EditorActivityBeanDefinition activityBean = new EditorActivityBeanDefinition(() -> ((JsWorkbenchEditorActivity)((Object)((Object)this.jsWorkbenchEditorActivityInstance.get()))).withEditor(new JsNativeEditor(componentId, jsObject)));
        beanManager.registerBean(activityBean);
        beanManager.registerBeanTypeAlias(activityBean, WorkbenchEditorActivity.class);
        beanManager.registerBeanTypeAlias(activityBean, Activity.class);
        this.activityBeansCache.addNewEditorActivity(activityBean, editor.af_priority(), Arrays.asList(editor.af_resourceTypes()));
    }

    @Qualifier
    public static @interface Shadowed {
    }
}

