/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.migration.impl;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.uberfire.experimental.service.storage.migration.StorageMigration;
import org.uberfire.experimental.service.storage.migration.StorageMigrationService;
import org.uberfire.java.nio.file.FileSystem;

@Dependent
public class StorageMigrationServiceImpl
implements StorageMigrationService {
    private Set<StorageMigration> migrations = new TreeSet<StorageMigration>(Comparator.comparingInt(StorageMigration::getTargetVersion));

    @Inject
    public StorageMigrationServiceImpl(Instance<StorageMigration> instance) {
        for (StorageMigration migration : instance) {
            this.migrations.add(migration);
        }
    }

    @Override
    public void migrate(Integer targetVersion, FileSystem fileSystem) {
        this.migrations.iterator().forEachRemaining(migration -> {
            if (migration.getTargetVersion() <= targetVersion) {
                migration.migrate(fileSystem);
            }
        });
    }
}

