/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.service.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.workbench.widgets.menu.events.PerspectiveVisibiltiyChangeEvent;
import org.uberfire.experimental.client.service.ClientExperimentalFeaturesRegistryService;
import org.uberfire.experimental.client.service.auth.ExperimentalActivityReference;
import org.uberfire.experimental.client.util.ExperimentalUtils;
import org.uberfire.experimental.service.auth.ExperimentalActivitiesAuthorizationManager;
import org.uberfire.experimental.service.events.NonPortableExperimentalFeatureModifiedEvent;
import org.uberfire.experimental.service.events.PortableExperimentalFeatureModifiedEvent;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.ConditionalPlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;

@Singleton
public class ExperimentalActivitiesAuthorizationManagerImpl
implements ExperimentalActivitiesAuthorizationManager {
    private ClientExperimentalFeaturesRegistryService experimentalFeaturesRegistryService;
    private SyncBeanManager iocManager;
    private Supplier<String> uniqueIdSupplier;
    private Event<PerspectiveVisibiltiyChangeEvent> perspectiveVisibleEvent;
    private Map<String, String> activityIdToExperimentalFeatureId = new HashMap<String, String>();
    private Map<String, String> activityClassToExperimentalFeatureId = new HashMap<String, String>();
    private List<String> perspectiveIds = new ArrayList<String>();
    private List<String> screenIds = new ArrayList<String>();
    private List<String> editorIds = new ArrayList<String>();

    @Inject
    public ExperimentalActivitiesAuthorizationManagerImpl(SyncBeanManager iocManager, ClientExperimentalFeaturesRegistryService experimentalFeaturesRegistryService, Event<PerspectiveVisibiltiyChangeEvent> perspectiveVisibleEvent) {
        this(iocManager, experimentalFeaturesRegistryService, perspectiveVisibleEvent, () -> ExperimentalActivitiesAuthorizationManagerImpl.createUniqueId());
    }

    ExperimentalActivitiesAuthorizationManagerImpl(SyncBeanManager iocManager, ClientExperimentalFeaturesRegistryService experimentalFeaturesRegistryService, Event<PerspectiveVisibiltiyChangeEvent> perspectiveVisibleEvent, Supplier<String> uniqueIdSupplier) {
        this.iocManager = iocManager;
        this.uniqueIdSupplier = uniqueIdSupplier;
        this.perspectiveVisibleEvent = perspectiveVisibleEvent;
        this.experimentalFeaturesRegistryService = experimentalFeaturesRegistryService;
    }

    public void init() {
        Collection activities = this.iocManager.lookupBeans(ExperimentalActivityReference.class);
        activities.stream().map(SyncBeanDef::getInstance).forEach(activity -> {
            this.activityIdToExperimentalFeatureId.put(activity.getActivityId(), activity.getExperimentalFeatureId());
            this.activityClassToExperimentalFeatureId.put(activity.getActivityTypeName(), activity.getExperimentalFeatureId());
            switch (activity.getActivityType()) {
                case PERSPECTIVE: {
                    this.perspectiveIds.add(activity.getActivityId());
                    break;
                }
                case SCREEN: {
                    this.screenIds.add(activity.getActivityId());
                    break;
                }
                case EDITOR: {
                    this.editorIds.add(activity.getActivityId());
                }
            }
        });
    }

    public boolean authorizeActivity(Object activity) {
        return this.authorizeActivityClass(activity.getClass());
    }

    public boolean authorizeActivityClass(Class activityClass) {
        return this.authorizeByClassName(activityClass.getName());
    }

    public void securePart(PartDefinition part, PanelDefinition panel) {
        PlaceRequest request = part.getPlace();
        String identifier = request.getIdentifier();
        if (request instanceof PathPlaceRequest) {
            return;
        }
        Optional<String> optional = Optional.ofNullable(this.activityIdToExperimentalFeatureId.get(identifier));
        if (optional.isPresent()) {
            panel.removePart(part);
            DefaultPlaceRequest disabledRequest = new DefaultPlaceRequest("appformer.experimental.disabledFeatureTitle");
            disabledRequest.addParameter("randomId", this.uniqueIdSupplier.get());
            disabledRequest.addParameter("featureId", optional.get());
            part.setPlace(new ConditionalPlaceRequest(identifier, request.getParameters()).when(placeRequest -> this.authorizeActivityId(identifier)).orElse((PlaceRequest)disabledRequest));
        }
    }

    protected boolean authorizeByClassName(String activityClassName) {
        return this.doAuthorize(() -> this.activityClassToExperimentalFeatureId.get(activityClassName));
    }

    public boolean authorizeActivityId(String activityId) {
        return this.doAuthorize(() -> this.activityIdToExperimentalFeatureId.get(activityId));
    }

    protected boolean doAuthorize(Supplier<String> keySupplier) {
        Optional<String> optional = Optional.ofNullable(keySupplier.get());
        return optional.map(this::authorize).orElse(true);
    }

    protected boolean authorize(String experimentalFeatureId) {
        return this.experimentalFeaturesRegistryService.isFeatureEnabled(experimentalFeatureId);
    }

    private static String createUniqueId() {
        return ExperimentalUtils.createUniqueId();
    }

    public void onFeatureModified(@Observes PortableExperimentalFeatureModifiedEvent event) {
        this.onFeatureModified(event.getFeature());
    }

    public void onFeatureModified(@Observes NonPortableExperimentalFeatureModifiedEvent event) {
        this.onFeatureModified(event.getFeature());
    }

    private void onFeatureModified(ExperimentalFeature feature) {
        this.activityIdToExperimentalFeatureId.entrySet().stream().filter(entry -> this.perspectiveIds.contains(entry.getKey()) && ((String)entry.getValue()).equals(feature.getFeatureId())).findAny().map(Map.Entry::getKey).ifPresent(activityId -> this.perspectiveVisibleEvent.fire((Object)new PerspectiveVisibiltiyChangeEvent(activityId, feature.isEnabled())));
    }
}

