/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.io.CommonIOServiceDotFileTest;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchService;

public class BatchTest {
    final IOService ioService = new IOServiceDotFileImpl();
    private static File path = null;

    @Before
    public void setup() throws IOException {
        path = CommonIOServiceDotFileTest.createTempDirectory();
        System.setProperty("org.uberfire.nio.git.dir", path.getAbsolutePath());
        System.out.println(".niogit: " + path.getAbsolutePath());
        URI newRepo = URI.create("git://amend-repo-test");
        this.ioService.newFileSystem(newRepo, new HashMap());
    }

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        if (path != null) {
            FileUtils.deleteQuietly((File)path);
        }
    }

    @Test
    public void testBatch() throws IOException, InterruptedException {
        Path init = this.ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        WatchService ws = init.getFileSystem().newWatchService();
        this.ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        this.ioService.write(init, "init 2!", new OpenOption[]{new CommentedOption("User Tester", "message2")});
        List events = ws.poll().pollEvents();
        Assert.assertEquals((int)1, (int)events.size());
        Path init2 = this.ioService.get(URI.create("git://amend-repo-test/readme2.txt"));
        this.ioService.write(init2, "init 3!", new OpenOption[]{new CommentedOption("User Tester", "message3")});
        List events2 = ws.poll().pollEvents();
        Assert.assertEquals((int)1, (int)events2.size());
        this.ioService.write(init2, "init 4!", new OpenOption[]{new CommentedOption("User Tester", "message4")});
        events2 = ws.poll().pollEvents();
        Assert.assertEquals((int)1, (int)events2.size());
        VersionAttributeView vinit = (VersionAttributeView)this.ioService.getFileAttributeView(init, VersionAttributeView.class);
        VersionAttributeView vinit2 = (VersionAttributeView)this.ioService.getFileAttributeView(init, VersionAttributeView.class);
        Assert.assertEquals((String)"init 2!\n", (String)this.ioService.readAllString(init));
        TestCase.assertNotNull((Object)vinit);
        Assert.assertEquals((int)2, (int)vinit.readAttributes().history().records().size());
        TestCase.assertNotNull((Object)vinit2);
        Assert.assertEquals((int)2, (int)vinit2.readAttributes().history().records().size());
        this.ioService.startBatch(new Option[0]);
        Path path = this.ioService.get(URI.create("git://amend-repo-test/mybatch" + new Random(10L).nextInt() + ".txt"));
        Path path2 = this.ioService.get(URI.create("git://amend-repo-test/mybatch2" + new Random(10L).nextInt() + ".txt"));
        this.ioService.write(path, "ooooo!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        this.ioService.write(path, "ooooo wdfs fg sdf!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        this.ioService.write(path2, "ooooo222!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        this.ioService.write(path2, " sdfsdg sdg ooooo222!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        this.ioService.endBatch(new Option[0]);
        List events3 = ws.poll().pollEvents();
        Assert.assertEquals((int)2, (int)events3.size());
        VersionAttributeView v = (VersionAttributeView)this.ioService.getFileAttributeView(path, VersionAttributeView.class);
        VersionAttributeView v2 = (VersionAttributeView)this.ioService.getFileAttributeView(path2, VersionAttributeView.class);
        TestCase.assertNotNull((Object)v);
        TestCase.assertNotNull((Object)v2);
        Assert.assertEquals((int)1, (int)v.readAttributes().history().records().size());
        Assert.assertEquals((int)1, (int)v2.readAttributes().history().records().size());
    }
}

