/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.io.CommonIOServiceDotFileTest;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchService;

public class BatchTest {
    static final IOService ioService = new IOServiceDotFileImpl();
    private static File path = null;

    @BeforeClass
    public static void setup() throws IOException {
        path = CommonIOServiceDotFileTest.createTempDirectory();
        System.setProperty("org.uberfire.nio.git.dir", path.getAbsolutePath());
        System.out.println(".niogit: " + path.getAbsolutePath());
        URI newRepo = URI.create("git://amend-repo-test");
        ioService.newFileSystem(newRepo, new HashMap());
        URI newRepo2 = URI.create("git://check-amend-repo-test");
        ioService.newFileSystem(newRepo2, (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        });
    }

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        if (path != null) {
            FileUtils.deleteQuietly((File)path);
        }
    }

    @Test
    public void testBatch() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        WatchService ws = init.getFileSystem().newWatchService();
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.write(init, "init 2!", new OpenOption[]{new CommentedOption("User Tester", "message2")});
        List events = ws.poll().pollEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        Path init2 = ioService.get(URI.create("git://amend-repo-test/readme2.txt"));
        ioService.write(init2, "init 3!", new OpenOption[]{new CommentedOption("User Tester", "message3")});
        List events2 = ws.poll().pollEvents();
        Assert.assertEquals((long)1L, (long)events2.size());
        ioService.write(init2, "init 4!", new OpenOption[]{new CommentedOption("User Tester", "message4")});
        events2 = ws.poll().pollEvents();
        Assert.assertEquals((long)1L, (long)events2.size());
        VersionAttributeView vinit = (VersionAttributeView)ioService.getFileAttributeView(init, VersionAttributeView.class);
        VersionAttributeView vinit2 = (VersionAttributeView)ioService.getFileAttributeView(init, VersionAttributeView.class);
        Assert.assertEquals((Object)"init 2!", (Object)ioService.readAllString(init));
        Assert.assertNotNull((Object)vinit);
        Assert.assertEquals((long)2L, (long)vinit.readAttributes().history().records().size());
        Assert.assertNotNull((Object)vinit2);
        Assert.assertEquals((long)2L, (long)vinit2.readAttributes().history().records().size());
        ioService.startBatch(new Option[0]);
        Path path = ioService.get(URI.create("git://amend-repo-test/mybatch" + new Random(10L).nextInt() + ".txt"));
        Path path2 = ioService.get(URI.create("git://amend-repo-test/mybatch2" + new Random(10L).nextInt() + ".txt"));
        ioService.write(path, "ooooo!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(path, "ooooo wdfs fg sdf!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(path2, "ooooo222!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(path2, " sdfsdg sdg ooooo222!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.endBatch(new Option[0]);
        List events3 = ws.poll().pollEvents();
        Assert.assertEquals((long)2L, (long)events3.size());
        VersionAttributeView v = (VersionAttributeView)ioService.getFileAttributeView(path, VersionAttributeView.class);
        VersionAttributeView v2 = (VersionAttributeView)ioService.getFileAttributeView(path2, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((long)1L, (long)v.readAttributes().history().records().size());
        Assert.assertEquals((long)1L, (long)v2.readAttributes().history().records().size());
    }

    @Test
    public void testBatch2() throws IOException, InterruptedException {
        Path f1 = ioService.get(URI.create("git://check-amend-repo-test/f1.txt"));
        Path f2 = ioService.get(URI.create("git://check-amend-repo-test/f2.txt"));
        Path f3 = ioService.get(URI.create("git://check-amend-repo-test/f3.txt"));
        ioService.write(f1, "init f1!", new OpenOption[0]);
        ioService.write(f2, "init f2!", new OpenOption[0]);
        WatchService ws = f1.getFileSystem().newWatchService();
        ioService.startBatch(new Option[0]);
        ioService.write(f1, "f1-u1!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(f2, "f2-u1!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(f3, "f3-u1!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.endBatch(new Option[0]);
        List events = ws.poll().pollEvents();
        Assert.assertEquals((long)3L, (long)events.size());
        VersionAttributeView v = (VersionAttributeView)ioService.getFileAttributeView(f1, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)2L, (long)v.readAttributes().history().records().size());
        VersionAttributeView v2 = (VersionAttributeView)ioService.getFileAttributeView(f2, VersionAttributeView.class);
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((long)2L, (long)v2.readAttributes().history().records().size());
        VersionAttributeView v3 = (VersionAttributeView)ioService.getFileAttributeView(f3, VersionAttributeView.class);
        Assert.assertNotNull((Object)v3);
        Assert.assertEquals((long)1L, (long)v3.readAttributes().history().records().size());
        ioService.startBatch(new Option[0]);
        ioService.write(f1, "f1-u1!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(f2, "f2-u2!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(f3, "f3-u2!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.endBatch(new Option[0]);
        events = ws.poll().pollEvents();
        Assert.assertEquals((long)2L, (long)events.size());
        v = (VersionAttributeView)ioService.getFileAttributeView(f1, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)2L, (long)v.readAttributes().history().records().size());
        v2 = (VersionAttributeView)ioService.getFileAttributeView(f2, VersionAttributeView.class);
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((long)3L, (long)v2.readAttributes().history().records().size());
        v3 = (VersionAttributeView)ioService.getFileAttributeView(f3, VersionAttributeView.class);
        Assert.assertNotNull((Object)v3);
        Assert.assertEquals((long)2L, (long)v3.readAttributes().history().records().size());
    }
}

