/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.base.AbstractBasicFileAttributeView;
import org.uberfire.java.nio.base.AbstractPath;
import org.uberfire.java.nio.base.AttrHolder;
import org.uberfire.java.nio.base.NeedsPreloadedAttrs;
import org.uberfire.java.nio.base.dotfiles.DotFileUtils;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardOpenOption;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileTime;

public abstract class CommonIOServiceDotFileTest {
    protected final Date dateValue = new Date();
    protected static final List<File> tempFiles = new ArrayList<File>();
    protected static IOService ioService = null;

    @Test
    public void testFile() throws IOException {
        Path path = this.getFilePath();
        this.ioService().write(path, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return CommonIOServiceDotFileTest.this.dateValue;
            }
        }, new FileAttribute<String>(){

            public String name() {
                return "int.hello";
            }

            public String value() {
                return "world";
            }
        }, new FileAttribute<Integer>(){

            public String name() {
                return "int";
            }

            public Integer value() {
                return 10;
            }
        }});
        Map attrs = this.ioService().readAttributes(path);
        Assert.assertEquals((long)this.testFileAttrSize1(), (long)attrs.size());
        Assert.assertTrue((boolean)attrs.containsKey("int.hello"));
        Assert.assertTrue((boolean)attrs.containsKey("custom"));
        Assert.assertTrue((boolean)attrs.containsKey("int"));
        Assert.assertEquals((Object)10, attrs.get("int"));
        Assert.assertEquals((Object)this.dateValue, attrs.get("custom"));
        Assert.assertEquals((Object)"world", attrs.get("int.hello"));
        if (path instanceof AttrHolder) {
            ((AttrHolder)path).getAttrStorage().clear();
        }
        attrs = this.ioService().readAttributes(path);
        Assert.assertEquals((Object)10, attrs.get("int"));
        Assert.assertEquals((Object)this.dateValue, attrs.get("custom"));
        Assert.assertEquals((Object)"world", attrs.get("int.hello"));
        Map attrsValue = this.ioService().readAttributes(path);
        Assert.assertEquals((long)this.testFileAttrSize2(), (long)attrsValue.size());
        this.ioService().setAttributes(path, new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "my_new_key";
            }

            public Object value() {
                return null;
            }
        }});
        Map attrsValue2 = this.ioService().readAttributes(path);
        Assert.assertEquals((long)this.testFileAttrSize3(), (long)attrsValue2.size());
        Assert.assertFalse((boolean)attrsValue2.containsKey("my_new_key"));
        this.ioService().delete(path, new DeleteOption[0]);
        this.ioService().write(path, "ooooo!", new OpenOption[0]);
        Map attrsClean = this.ioService().readAttributes(path);
        Assert.assertEquals((long)this.testFileAttrSize4(), (long)attrsClean.size());
    }

    protected abstract int testFileAttrSize4();

    protected abstract int testFileAttrSize3();

    protected abstract int testFileAttrSize2();

    protected abstract int testFileAttrSize1();

    @Test
    public void testDirectory() throws IOException {
        Path path = this.getDirectoryPath();
        this.ioService().createDirectory(path, new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return CommonIOServiceDotFileTest.this.dateValue;
            }
        }, new FileAttribute<String>(){

            public String name() {
                return "int.hello";
            }

            public String value() {
                return "world";
            }
        }, new FileAttribute<Integer>(){

            public String name() {
                return "int";
            }

            public Integer value() {
                return 10;
            }
        }});
        Map attrs = this.ioService().readAttributes(path);
        Assert.assertEquals((long)this.testDirectoryAttrSize1(), (long)attrs.size());
        Assert.assertTrue((boolean)attrs.containsKey("int.hello"));
        Assert.assertTrue((boolean)attrs.containsKey("custom"));
        Assert.assertTrue((boolean)attrs.containsKey("int"));
        Assert.assertEquals((Object)10, attrs.get("int"));
        Assert.assertEquals((Object)this.dateValue, attrs.get("custom"));
        Assert.assertEquals((Object)"world", attrs.get("int.hello"));
        if (path instanceof AttrHolder) {
            ((AttrHolder)path).getAttrStorage().clear();
        }
        attrs = this.ioService().readAttributes(path);
        Assert.assertEquals((Object)10, attrs.get("int"));
        Assert.assertEquals((Object)this.dateValue, attrs.get("custom"));
        Assert.assertEquals((Object)"world", attrs.get("int.hello"));
        this.ioService().delete(path, new DeleteOption[0]);
        this.ioService().createDirectory(path, new FileAttribute[0]);
        Map attrsClean = this.ioService().readAttributes(path);
        Assert.assertEquals((long)this.testDirectoryAttrSize4(), (long)attrsClean.size());
    }

    protected abstract int testDirectoryAttrSize4();

    protected abstract int testDirectoryAttrSize3();

    protected abstract int testDirectoryAttrSize2();

    protected abstract int testDirectoryAttrSize1();

    @Test
    public void testDelete() throws IOException {
        Path dir = this.getDirectoryPath();
        this.ioService().createDirectory(dir, new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return CommonIOServiceDotFileTest.this.dateValue;
            }
        }, new FileAttribute<String>(){

            public String name() {
                return "int.hello";
            }

            public String value() {
                return "world";
            }
        }, new FileAttribute<Integer>(){

            public String name() {
                return "int";
            }

            public Integer value() {
                return 10;
            }
        }});
        Assert.assertTrue((boolean)this.ioService().exists(dir));
        Assert.assertTrue((boolean)this.ioService().exists(DotFileUtils.dot((Path)dir)));
        this.ioService().delete(dir, new DeleteOption[0]);
        Assert.assertFalse((boolean)this.ioService().exists(dir));
        Assert.assertFalse((boolean)this.ioService().exists(DotFileUtils.dot((Path)dir)));
        Path file = this.getFilePath();
        this.ioService().write(file, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return CommonIOServiceDotFileTest.this.dateValue;
            }
        }});
        Assert.assertTrue((boolean)this.ioService().exists(file));
        Assert.assertTrue((boolean)this.ioService().exists(DotFileUtils.dot((Path)file)));
        Assert.assertFalse((boolean)((AttrHolder)file).getAttrStorage().getContent().isEmpty());
        this.ioService().delete(file, new DeleteOption[0]);
        Assert.assertTrue((boolean)((AttrHolder)file).getAttrStorage().getContent().isEmpty());
        Assert.assertFalse((boolean)this.ioService().exists(file));
        Assert.assertFalse((boolean)this.ioService().exists(DotFileUtils.dot((Path)file)));
    }

    @Test
    public void testCopyFile() {
        Path sfile = this.getFilePath();
        Path tfile = this.getTargetPath();
        this.ioService().deleteIfExists(sfile, new DeleteOption[0]);
        this.ioService().deleteIfExists(tfile, new DeleteOption[0]);
        this.ioService().write(sfile, "wow", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return CommonIOServiceDotFileTest.this.dateValue;
            }
        }});
        Assert.assertTrue((boolean)this.ioService().exists(sfile));
        Assert.assertTrue((boolean)this.ioService().exists(DotFileUtils.dot((Path)sfile)));
        Assert.assertFalse((boolean)this.ioService().exists(tfile));
        Assert.assertFalse((boolean)this.ioService().exists(DotFileUtils.dot((Path)tfile)));
        this.ioService().copy(sfile, tfile, new CopyOption[0]);
        Assert.assertTrue((boolean)this.ioService().exists(sfile));
        Assert.assertTrue((boolean)this.ioService().exists(DotFileUtils.dot((Path)sfile)));
        Assert.assertTrue((boolean)this.ioService().exists(tfile));
        Assert.assertTrue((boolean)this.ioService().exists(DotFileUtils.dot((Path)tfile)));
    }

    @Test
    public void createDirectories() {
        Path dir = this.getComposedDirectoryPath();
        Assert.assertFalse((boolean)this.ioService().exists(dir));
        this.ioService().createDirectories(dir, new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return CommonIOServiceDotFileTest.this.dateValue;
            }
        }});
        Assert.assertTrue((boolean)this.ioService().exists(dir));
        Assert.assertTrue((boolean)this.ioService().exists(dir.getParent()));
        Assert.assertNotNull((Object)this.ioService().exists(dir.getParent().getFileName()));
        Map attrs = this.ioService().readAttributes(dir);
        Assert.assertEquals((long)this.createDirectoriesAttrSize(), (long)attrs.size());
        this.ioService().delete(dir, new DeleteOption[0]);
        this.ioService().exists(dir.getParent());
    }

    protected abstract int createDirectoriesAttrSize();

    @Test
    public void testDeleteIfExistis() throws IOException {
        Path dir = this.getDirectoryPath();
        this.ioService().deleteIfExists(dir, new DeleteOption[0]);
        this.ioService().createDirectory(dir, new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return CommonIOServiceDotFileTest.this.dateValue;
            }
        }, new FileAttribute<String>(){

            public String name() {
                return "int.hello";
            }

            public String value() {
                return "world";
            }
        }, new FileAttribute<Integer>(){

            public String name() {
                return "int";
            }

            public Integer value() {
                return 10;
            }
        }});
        Assert.assertTrue((boolean)this.ioService().deleteIfExists(dir, new DeleteOption[0]));
        Assert.assertFalse((boolean)this.ioService().deleteIfExists(dir, new DeleteOption[0]));
        Path file = this.getFilePath();
        this.ioService().deleteIfExists(file, new DeleteOption[0]);
        this.ioService().write(file, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return CommonIOServiceDotFileTest.this.dateValue;
            }
        }});
        Assert.assertFalse((boolean)((AttrHolder)file).getAttrStorage().getContent().isEmpty());
        Assert.assertTrue((boolean)this.ioService().deleteIfExists(file, new DeleteOption[0]));
        Assert.assertTrue((boolean)((AttrHolder)file).getAttrStorage().getContent().isEmpty());
        Assert.assertFalse((boolean)this.ioService().deleteIfExists(file, new DeleteOption[0]));
    }

    @Test
    public void testReadNewByteChannel() throws IOException {
        Path file = this.getFilePath();
        this.ioService().deleteIfExists(file, new DeleteOption[0]);
        Assert.assertFalse((boolean)this.ioService().exists(file));
        String content = "sample content";
        ioService.write(file, content, new OpenOption[0]);
        Assert.assertTrue((boolean)this.ioService().exists(file));
        SeekableByteChannel sbc = this.ioService().newByteChannel(file, new OpenOption[]{StandardOpenOption.READ});
        String readContent = this.readSbc(sbc);
        Assert.assertEquals((Object)content, (Object)readContent);
        this.ioService().delete(file, new DeleteOption[0]);
    }

    @Test
    public void testNewByteChannel() throws IOException {
        Path file = this.getFilePath();
        this.ioService().deleteIfExists(file, new DeleteOption[0]);
        Assert.assertFalse((boolean)this.ioService().exists(file));
        SeekableByteChannel sbc = this.ioService().newByteChannel(file, Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return CommonIOServiceDotFileTest.this.dateValue;
            }
        }});
        sbc.write(ByteBuffer.wrap("helloWorld!".getBytes()));
        sbc.close();
        Assert.assertTrue((boolean)this.ioService().exists(file));
        Map attrs = this.ioService().readAttributes(file);
        Assert.assertEquals((long)this.testNewByteChannelAttrSize(), (long)attrs.size());
        try {
            this.ioService().newByteChannel(file, Collections.emptySet(), new FileAttribute[0]);
            Assert.fail((String)"FileAlreadyExistsException expected");
        }
        catch (FileAlreadyExistsException ex) {
            // empty catch block
        }
        this.ioService().delete(file, new DeleteOption[0]);
        this.ioService().newByteChannel(file, Collections.emptySet(), new FileAttribute[0]).close();
        Assert.assertTrue((boolean)this.ioService().deleteIfExists(file, new DeleteOption[0]));
    }

    protected abstract int testNewByteChannelAttrSize();

    @Test
    public void testGetAttribute() {
        Path file = this.getFilePath();
        this.ioService().deleteIfExists(file, new DeleteOption[0]);
        this.ioService().write(file, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "AuthorName";
            }
        }});
        Assert.assertNotNull((Object)this.ioService().getAttribute(file, "dcore:dcore.author"));
        Assert.assertNull((Object)this.ioService().getAttribute(file, "dcore:dcore.not_here"));
        Assert.assertNotNull((Object)this.ioService().getAttribute(file, "dcore.author"));
        Assert.assertNull((Object)this.ioService().getAttribute(file, "something"));
        ((AttrHolder)file).getAttrStorage().clear();
        Assert.assertNotNull((Object)this.ioService().getAttribute(file, "dcore:dcore.author"));
        Assert.assertNull((Object)this.ioService().getAttribute(file, "dcore:dcore.not_here"));
        Assert.assertNotNull((Object)this.ioService().getAttribute(file, "dcore.author"));
        Assert.assertNull((Object)this.ioService().getAttribute(file, "something"));
    }

    @Test
    public void testGetAttributeView() {
        Path file = this.getFilePath();
        this.ioService().deleteIfExists(file, new DeleteOption[0]);
        this.ioService().write(file, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "AuthorName";
            }
        }});
        Assert.assertNotNull((Object)this.ioService().getFileAttributeView(file, BasicFileAttributeView.class));
        Assert.assertNull((Object)this.ioService().getFileAttributeView(file, MyAttrsView.class));
        Assert.assertNotNull((Object)this.ioService().getFileAttributeView(file, XDublinCoreView.class));
        DublinCoreAttributes attr = (DublinCoreAttributes)((XDublinCoreView)this.ioService().getFileAttributeView(file, XDublinCoreView.class)).readAttributes();
        Assert.assertEquals((Object)"AuthorName", (Object)attr.getAuthor());
        ((AttrHolder)file).getAttrStorage().clear();
        Assert.assertNotNull((Object)this.ioService().getFileAttributeView(file, BasicFileAttributeView.class));
        Assert.assertNull((Object)this.ioService().getFileAttributeView(file, MyAttrsView.class));
        Assert.assertNotNull((Object)this.ioService().getFileAttributeView(file, XDublinCoreView.class));
    }

    public abstract Path getFilePath();

    public abstract Path getTargetPath();

    public abstract Path getDirectoryPath();

    public abstract Path getComposedDirectoryPath();

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        tempFiles.add(temp);
        return temp;
    }

    private String readSbc(SeekableByteChannel sbc) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(100);
        StringBuilder content = new StringBuilder();
        byteBuffer.clear();
        try {
            while (sbc.read(byteBuffer) > 0) {
                byteBuffer.flip();
                content.append(new String(byteBuffer.array(), 0, byteBuffer.remaining()));
                byteBuffer.compact();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content.toString();
    }

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        for (File tempFile : tempFiles) {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    public IOService ioService() {
        if (ioService == null) {
            ioService = new IOServiceDotFileImpl();
        }
        return ioService;
    }

    public static class DublinCoreAttributes
    implements BasicFileAttributes {
        private final BasicFileAttributes attributes;
        private final String author;

        private DublinCoreAttributes(BasicFileAttributes attributes, String author) {
            this.attributes = attributes;
            this.author = author;
        }

        public String getAuthor() {
            return this.author;
        }

        public FileTime lastModifiedTime() {
            return this.attributes.lastModifiedTime();
        }

        public FileTime lastAccessTime() {
            return this.attributes.lastAccessTime();
        }

        public FileTime creationTime() {
            return this.attributes.creationTime();
        }

        public boolean isRegularFile() {
            return this.attributes.isRegularFile();
        }

        public boolean isDirectory() {
            return this.attributes.isDirectory();
        }

        public boolean isSymbolicLink() {
            return this.attributes.isSymbolicLink();
        }

        public boolean isOther() {
            return this.attributes.isOther();
        }

        public long size() {
            return this.attributes.size();
        }

        public Object fileKey() {
            return this.attributes.fileKey();
        }
    }

    public static class XDublinCoreView
    extends AbstractBasicFileAttributeView<AbstractPath>
    implements NeedsPreloadedAttrs {
        private BasicFileAttributes attrs = null;

        public XDublinCoreView(AbstractPath path) {
            super((Path)path);
        }

        public <T extends BasicFileAttributes> T readAttributes() throws org.uberfire.java.nio.IOException {
            if (this.attrs == null) {
                BasicFileAttributes basicAtts = ((BasicFileAttributeView)((AbstractPath)this.path).getAttrView(BasicFileAttributeView.class)).readAttributes();
                this.attrs = new DublinCoreAttributes(basicAtts, (String)((AbstractPath)this.path).getAttrStorage().getContent().get("dcore.author"));
            }
            return (T)this.attrs;
        }

        public Class<? extends BasicFileAttributeView>[] viewTypes() {
            return new Class[]{XDublinCoreView.class};
        }
    }

    private static interface MyAttrsView
    extends BasicFileAttributeView {
    }
}

