/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.impl;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.io.IOWatchService;
import org.uberfire.io.impl.AbstractIOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AbstractBasicFileAttributeView;
import org.uberfire.java.nio.base.AttrHolder;
import org.uberfire.java.nio.base.NeedsPreloadedAttrs;
import org.uberfire.java.nio.base.Properties;
import org.uberfire.java.nio.base.dotfiles.DotFileOption;
import org.uberfire.java.nio.base.dotfiles.DotFileUtils;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardCopyOption;
import org.uberfire.java.nio.file.attribute.AttributeView;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;

public class IOServiceDotFileImpl
extends AbstractIOService
implements IOService {
    public IOServiceDotFileImpl() {
    }

    public IOServiceDotFileImpl(String serviceId) {
        super(serviceId);
    }

    public IOServiceDotFileImpl(IOWatchService watchService) {
        super(watchService);
    }

    public IOServiceDotFileImpl(String serviceId, IOWatchService watchService) {
        super(serviceId, watchService);
    }

    @Override
    public void delete(Path path, DeleteOption ... options) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException, SecurityException {
        Files.delete((Path)path, (DeleteOption[])options);
        try {
            Files.deleteIfExists((Path)DotFileUtils.dot((Path)path), (DeleteOption[])options);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path instanceof AttrHolder) {
            ((AttrHolder)path).getAttrStorage().clear();
        }
    }

    @Override
    public boolean deleteIfExists(Path path, DeleteOption ... options) throws IllegalArgumentException, DirectoryNotEmptyException, IOException, SecurityException {
        boolean result = Files.deleteIfExists((Path)path, (DeleteOption[])options);
        try {
            Files.deleteIfExists((Path)DotFileUtils.dot((Path)path), (DeleteOption[])options);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (path instanceof AttrHolder) {
            ((AttrHolder)path).getAttrStorage().clear();
        }
        return result;
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        Properties properties = new Properties();
        if (this.exists(DotFileUtils.dot((Path)path))) {
            properties.load(this.newInputStream(DotFileUtils.dot((Path)path), new OpenOption[0]));
        }
        FileAttribute[] allAttrs = DotFileUtils.consolidate((Map)properties, attrs);
        SeekableByteChannel result = Files.newByteChannel((Path)path, this.buildOptions(options, new OpenOption[0]), (FileAttribute[])allAttrs);
        if (this.isFileScheme(path)) {
            DotFileUtils.buildDotFile((Path)path, (OutputStream)this.newOutputStream(DotFileUtils.dot((Path)path), new OpenOption[0]), (FileAttribute[])allAttrs);
        }
        return result;
    }

    @Override
    public Path createDirectory(Path dir, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return this.internalCreateDirectory(dir, false, attrs);
    }

    @Override
    public Path createDirectories(Path dir, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Path result = Files.createDirectories((Path)dir, attrs);
        DotFileUtils.buildDotFile((Path)dir, (OutputStream)this.newOutputStream(DotFileUtils.dot((Path)dir), new OpenOption[0]), attrs);
        return result;
    }

    @Override
    public Path copy(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException {
        if (Files.exists((Path)DotFileUtils.dot((Path)source), (LinkOption[])new LinkOption[0])) {
            Files.copy((Path)DotFileUtils.dot((Path)source), (Path)DotFileUtils.dot((Path)target), (CopyOption[])this.forceBuildOptions(options));
        } else if (Files.exists((Path)DotFileUtils.dot((Path)target), (LinkOption[])new LinkOption[0])) {
            Files.delete((Path)DotFileUtils.dot((Path)target), (DeleteOption[])new DeleteOption[0]);
        }
        Path result = Files.copy((Path)source, (Path)target, (CopyOption[])options);
        return result;
    }

    @Override
    public Path move(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException {
        if (Files.exists((Path)DotFileUtils.dot((Path)source), (LinkOption[])new LinkOption[0])) {
            Files.move((Path)DotFileUtils.dot((Path)source), (Path)DotFileUtils.dot((Path)target), (CopyOption[])this.forceBuildOptions(options));
        } else if (Files.exists((Path)DotFileUtils.dot((Path)target), (LinkOption[])new LinkOption[0])) {
            Files.delete((Path)DotFileUtils.dot((Path)target), (DeleteOption[])new DeleteOption[0]);
        }
        Path result = Files.move((Path)source, (Path)target, (CopyOption[])options);
        return result;
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type) throws IllegalArgumentException {
        FileAttributeView value = Files.getFileAttributeView((Path)path, type, (LinkOption[])new LinkOption[0]);
        if (value == null && path instanceof AttrHolder) {
            AttrHolder holder = (AttrHolder)path;
            FileAttributeView holderView = (FileAttributeView)holder.getAttrView(type);
            if (holderView == null && AbstractBasicFileAttributeView.class.isAssignableFrom(type)) {
                return this.newView(holder, type);
            }
            return (V)holderView;
        }
        return (V)value;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes) throws UnsupportedOperationException, NoSuchFileException, IllegalArgumentException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotEmpty((String)"attributes", (String)attributes);
        Properties original = new Properties(Files.readAttributes((Path)path, (String)attributes, (LinkOption[])new LinkOption[0]));
        if (attributes.equals("*") && this.exists(DotFileUtils.dot((Path)path))) {
            boolean isAttrHolder = path instanceof AttrHolder;
            if (isAttrHolder && ((AttrHolder)path).getAttrStorage().getContent().size() > 0) {
                return ((AttrHolder)path).getAttrStorage().getAllContent();
            }
            Properties content = new Properties();
            content.load(this.newInputStream(DotFileUtils.dot((Path)path), new OpenOption[0]));
            content.putAll((Map)original);
            if (isAttrHolder) {
                ((AttrHolder)path).getAttrStorage().loadContent(content);
            }
            return content;
        }
        return original;
    }

    @Override
    public Path setAttributes(Path path, FileAttribute<?> ... attrs) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
            return this.internalCreateDirectory(path, true, attrs);
        }
        return this.write(path, this.readAllBytes(path), Collections.emptySet(), attrs);
    }

    @Override
    public Object getAttribute(Path path, String attribute) throws UnsupportedOperationException, IllegalArgumentException, IOException, SecurityException {
        Object value;
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        try {
            value = Files.getAttribute((Path)path, (String)attribute, (LinkOption[])new LinkOption[0]);
        }
        catch (UnsupportedOperationException ex) {
            value = null;
        }
        if (value == null && path instanceof AttrHolder) {
            AttrHolder holder = (AttrHolder)path;
            String[] attr = this.split(attribute);
            if (holder.getAttrStorage().getContent().isEmpty()) {
                this.loadDotFile(path);
            }
            return holder.getAttrStorage().getAllContent().get(attr[1]);
        }
        return value;
    }

    @Override
    protected Set<? extends OpenOption> buildOptions(Set<? extends OpenOption> options, final OpenOption ... others) {
        return new HashSet<OpenOption>(options){
            {
                super(x0);
                this.add(new DotFileOption());
                if (others != null) {
                    for (OpenOption other : others) {
                        this.add(other);
                    }
                }
            }
        };
    }

    protected CopyOption[] buildOptions(CopyOption ... options) {
        CopyOption[] result = new CopyOption[options.length + 1];
        System.arraycopy(options, 0, result, 0, options.length);
        result[result.length - 1] = new DotFileOption();
        return result;
    }

    protected CopyOption[] forceBuildOptions(CopyOption[] options) {
        CopyOption[] result = new CopyOption[options.length + 1];
        System.arraycopy(options, 0, result, 0, options.length);
        result[result.length - 1] = StandardCopyOption.REPLACE_EXISTING;
        return result;
    }

    protected boolean isFileScheme(Path path) {
        if (path == null || path.getFileSystem() == null || path.getFileSystem().provider() == null) {
            return false;
        }
        return path.getFileSystem().provider().getScheme().equals("file");
    }

    protected void loadDotFile(Path path) {
        Properties content = new Properties();
        content.load(this.newInputStream(DotFileUtils.dot((Path)path), new OpenOption[0]));
        if (path instanceof AttrHolder) {
            ((AttrHolder)path).getAttrStorage().loadContent(content);
        }
    }

    protected <V extends AbstractBasicFileAttributeView> V newView(AttrHolder holder, Class<V> type) {
        if (NeedsPreloadedAttrs.class.isAssignableFrom(type) && holder.getAttrStorage().getContent().size() == 0) {
            this.readAttributes((Path)holder);
        }
        try {
            Constructor<?> constructor = type.getConstructors()[0];
            AbstractBasicFileAttributeView view = (AbstractBasicFileAttributeView)constructor.newInstance(holder);
            holder.addAttrView((AttributeView)view);
            return (V)view;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Path internalCreateDirectory(Path dir, boolean skipAlreadyExistsException, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        FileAttribute<?>[] allAttrs;
        block3: {
            PortablePreconditions.checkNotNull((String)"dir", (Object)dir);
            allAttrs = attrs;
            try {
                Files.createDirectory((Path)dir, attrs);
            }
            catch (FileAlreadyExistsException ex) {
                Properties properties = new Properties();
                if (this.exists(DotFileUtils.dot((Path)dir))) {
                    properties.load(this.newInputStream(DotFileUtils.dot((Path)dir), new OpenOption[0]));
                }
                allAttrs = DotFileUtils.consolidate((Map)properties, attrs);
                if (skipAlreadyExistsException) break block3;
                throw ex;
            }
        }
        DotFileUtils.buildDotFile((Path)dir, (OutputStream)this.newOutputStream(DotFileUtils.dot((Path)dir), new OpenOption[0]), allAttrs);
        return dir;
    }

    protected String[] split(String attribute) {
        String[] s = new String[2];
        int pos = attribute.indexOf(58);
        if (pos == -1) {
            s[0] = "basic";
            s[1] = attribute;
        } else {
            s[0] = attribute.substring(0, pos);
            s[1] = pos == attribute.length() ? "" : attribute.substring(pos + 1);
        }
        return s;
    }

    public int priority() {
        return 10;
    }
}

