/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.io.IOWatchService;
import org.uberfire.io.impl.IOServiceIdentifiable;
import org.uberfire.io.impl.IOServiceLockable;
import org.uberfire.io.lock.BatchLockControl;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AbstractPath;
import org.uberfire.java.nio.base.FileSystemState;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.FileSystems;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.ProviderNotFoundException;
import org.uberfire.java.nio.file.StandardOpenOption;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileTime;

public abstract class AbstractIOService
implements IOServiceIdentifiable,
IOServiceLockable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractIOService.class);
    protected static final String DEFAULT_SERVICE_NAME = "default";
    private static final Set<StandardOpenOption> CREATE_NEW_FILE_OPTIONS = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
    protected static final Charset UTF_8 = Charset.forName("UTF-8");
    protected final IOWatchService ioWatchService;
    protected final Set<FileSystem> fileSystems = Collections.newSetFromMap(new ConcurrentHashMap());
    protected IOService.NewFileSystemListener newFileSystemListener = null;
    protected boolean isDisposed = false;
    private String id;
    private final BatchLockControl batchLockControl = new BatchLockControl();

    public AbstractIOService() {
        this.id = DEFAULT_SERVICE_NAME;
        this.ioWatchService = null;
    }

    public AbstractIOService(String id) {
        this.id = id;
        this.ioWatchService = null;
    }

    public AbstractIOService(IOWatchService watchService) {
        this.id = DEFAULT_SERVICE_NAME;
        this.ioWatchService = watchService;
    }

    public AbstractIOService(String id, IOWatchService watchService) {
        this.id = id;
        this.ioWatchService = watchService;
    }

    @Override
    public void startBatch(FileSystem fs) {
        this.batchProcess(new FileSystem[]{fs}, new Option[0]);
    }

    @Override
    public void startBatch(FileSystem fs, Option ... options) {
        this.batchProcess(new FileSystem[]{fs}, options);
    }

    @Override
    public void startBatch(FileSystem ... fs) {
        this.batchProcess(fs, new Option[0]);
    }

    @Override
    public void startBatch(FileSystem[] fs, Option ... options) {
        this.batchProcess(fs, options);
    }

    private void batchProcess(FileSystem[] fs, Option ... options) {
        this.startBatchProcess(fs);
        if (!this.fileSystems.isEmpty()) {
            this.cleanupClosedFileSystems();
            this.setOptionsOnFileSystems(fs, options);
        }
    }

    private void setOptionsOnFileSystems(FileSystem[] fss, Option[] options) {
        if (options != null && options.length == 1) {
            for (FileSystem fs : fss) {
                this.setAttribute((Path)fs.getRootDirectories().iterator().next(), FileSystemState.FILE_SYSTEM_STATE_ATTR, options[0]);
            }
        }
    }

    private void startBatchProcess(FileSystem ... fileSystems) {
        this.batchLockControl.lock(fileSystems);
        for (FileSystem fs : fileSystems) {
            this.setBatchModeOn(fs);
        }
    }

    @Override
    public void endBatch() {
        if (!this.batchLockControl.isLocked()) {
            throw new RuntimeException("There is no batch process.");
        }
        if (this.batchLockControl.getHoldCount() > 1) {
            this.batchLockControl.unlock();
            return;
        }
        try {
            this.cleanUpAndUnsetBatchModeOnFileSystems();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception cleaning and unsetting batch mode on FS.");
        }
        finally {
            this.batchLockControl.unlock();
        }
    }

    private void cleanUpAndUnsetBatchModeOnFileSystems() {
        if (!this.fileSystems.isEmpty()) {
            this.cleanupClosedFileSystems();
        }
        for (FileSystem fs : this.fileSystems) {
            this.unsetBatchModeOn(fs);
        }
    }

    @Override
    public BatchLockControl getLockControl() {
        return this.batchLockControl;
    }

    private void cleanupClosedFileSystems() {
        ArrayList<FileSystem> removeList = new ArrayList<FileSystem>();
        for (FileSystem fileSystem : this.fileSystems) {
            if (fileSystem.isOpen()) continue;
            removeList.add(fileSystem);
        }
        this.fileSystems.removeAll(removeList);
    }

    private void setBatchModeOn(FileSystem fs) {
        Files.setAttribute((Path)((Path)fs.getRootDirectories().iterator().next()), (String)FileSystemState.FILE_SYSTEM_STATE_ATTR, (Object)FileSystemState.BATCH, (LinkOption[])new LinkOption[0]);
    }

    void unsetBatchModeOn(FileSystem fs) {
        Files.setAttribute((Path)((Path)fs.getRootDirectories().iterator().next()), (String)FileSystemState.FILE_SYSTEM_STATE_ATTR, (Object)FileSystemState.NORMAL, (LinkOption[])new LinkOption[0]);
    }

    @Override
    public Path get(String first, String ... more) throws IllegalArgumentException {
        return Paths.get((String)first, (String[])more);
    }

    @Override
    public Path get(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        return Paths.get((URI)uri);
    }

    @Override
    public Iterable<FileSystem> getFileSystems() {
        return this.fileSystems;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        try {
            return this.registerFS(FileSystems.getFileSystem((URI)uri));
        }
        catch (Exception ex) {
            logger.error("Failed to register filesystem " + uri + " with DEFAULT_FS_TYPE. Returning null.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        try {
            FileSystem fs = FileSystems.newFileSystem((URI)uri, env);
            return this.registerFS(fs);
        }
        catch (FileSystemAlreadyExistsException ex) {
            this.registerFS(FileSystems.getFileSystem((URI)uri));
            throw ex;
        }
    }

    @Override
    public void onNewFileSystem(IOService.NewFileSystemListener listener) {
        this.newFileSystemListener = listener;
    }

    private FileSystem registerFS(FileSystem fs) {
        if (fs == null) {
            return fs;
        }
        if (this.ioWatchService != null && !this.ioWatchService.hasWatchService(fs)) {
            this.ioWatchService.addWatchService(fs, fs.newWatchService());
        }
        this.fileSystems.add(fs);
        return fs;
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IllegalArgumentException, NoSuchFileException, UnsupportedOperationException, IOException, SecurityException {
        return Files.newInputStream((Path)path, (OpenOption[])options);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir) throws IllegalArgumentException, NotDirectoryException, IOException, SecurityException {
        return Files.newDirectoryStream((Path)dir);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<Path> filter) throws IllegalArgumentException, NotDirectoryException, IOException, SecurityException {
        return Files.newDirectoryStream((Path)dir, filter);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return Files.newOutputStream((Path)path, (OpenOption[])options);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return Files.newByteChannel((Path)path, (OpenOption[])options);
    }

    @Override
    public Path createDirectory(Path dir, Map<String, ?> attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return this.createDirectory(dir, this.convert(attrs));
    }

    @Override
    public Path createDirectories(Path dir, Map<String, ?> attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return this.createDirectories(dir, this.convert(attrs));
    }

    @Override
    public Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return Files.createTempFile((String)prefix, (String)suffix, attrs);
    }

    @Override
    public Path createTempFile(Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return Files.createTempFile((Path)dir, (String)prefix, (String)suffix, attrs);
    }

    @Override
    public Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return Files.createTempDirectory((String)prefix, attrs);
    }

    @Override
    public Path createTempDirectory(Path dir, String prefix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return Files.createTempDirectory((Path)dir, (String)prefix, attrs);
    }

    @Override
    public FileTime getLastModifiedTime(Path path) throws IllegalArgumentException, IOException, SecurityException {
        return Files.getLastModifiedTime((Path)path, (LinkOption[])new LinkOption[0]);
    }

    @Override
    public Map<String, Object> readAttributes(Path path) throws UnsupportedOperationException, NoSuchFileException, IllegalArgumentException, IOException, SecurityException {
        return this.readAttributes(path, "*");
    }

    @Override
    public Path setAttribute(Path path, String attribute, Object value) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        Files.setAttribute((Path)path, (String)attribute, (Object)value, (LinkOption[])new LinkOption[0]);
        return path;
    }

    @Override
    public Path setAttributes(Path path, Map<String, Object> attrs) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        return this.setAttributes(path, this.convert(attrs));
    }

    @Override
    public long size(Path path) throws IllegalArgumentException, IOException, SecurityException {
        return Files.size((Path)path);
    }

    @Override
    public boolean exists(Path path) throws IllegalArgumentException, SecurityException {
        return Files.exists((Path)path, (LinkOption[])new LinkOption[0]);
    }

    @Override
    public boolean notExists(Path path) throws IllegalArgumentException, SecurityException {
        return Files.notExists((Path)path, (LinkOption[])new LinkOption[0]);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IllegalArgumentException, IOException, SecurityException {
        return Files.isSameFile((Path)path, (Path)path2);
    }

    @Override
    public Path createFile(Path path, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        try {
            this.newByteChannel(path, CREATE_NEW_FILE_OPTIONS, attrs).close();
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
        return path;
    }

    @Override
    public BufferedReader newBufferedReader(Path path, Charset cs) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        return Files.newBufferedReader((Path)path, (Charset)cs);
    }

    @Override
    public long copy(Path source, OutputStream out) throws IOException, SecurityException {
        return Files.copy((Path)source, (OutputStream)out);
    }

    @Override
    public byte[] readAllBytes(Path path) throws IOException, OutOfMemoryError, SecurityException {
        return Files.readAllBytes((Path)path);
    }

    @Override
    public List<String> readAllLines(Path path) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        return this.readAllLines(path, UTF_8);
    }

    @Override
    public List<String> readAllLines(Path path, Charset cs) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        return Files.readAllLines((Path)path, (Charset)cs);
    }

    @Override
    public String readAllString(Path path, Charset cs) throws IllegalArgumentException, NoSuchFileException, IOException {
        byte[] result = Files.readAllBytes((Path)path);
        if (result == null && result.length < 0) {
            return "";
        }
        return new String(result, cs);
    }

    @Override
    public String readAllString(Path path) throws IllegalArgumentException, NoSuchFileException, IOException {
        return this.readAllString(path, UTF_8);
    }

    @Override
    public BufferedWriter newBufferedWriter(Path path, Charset cs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException, SecurityException {
        return Files.newBufferedWriter((Path)path, (Charset)cs, (OpenOption[])options);
    }

    @Override
    public long copy(InputStream in, Path target, CopyOption ... options) throws IOException, FileAlreadyExistsException, DirectoryNotEmptyException, UnsupportedOperationException, SecurityException {
        return Files.copy((InputStream)in, (Path)target, (CopyOption[])options);
    }

    @Override
    public Path write(Path path, byte[] bytes, OpenOption ... options) throws IOException, UnsupportedOperationException, SecurityException {
        return this.write(path, bytes, new HashSet<OpenOption>(Arrays.asList(options)), new FileAttribute[0]);
    }

    @Override
    public Path write(Path path, Iterable<? extends CharSequence> lines, Charset cs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException, SecurityException {
        return this.write(path, this.toByteArray(lines, cs), new HashSet<OpenOption>(Arrays.asList(options)), new FileAttribute[0]);
    }

    private byte[] toByteArray(Iterable<? extends CharSequence> lines, Charset cs) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence charSequence : lines) {
            sb.append(charSequence.toString());
        }
        return sb.toString().getBytes();
    }

    @Override
    public Path write(Path path, String content, Charset cs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.write(path, content.getBytes(cs), new HashSet<OpenOption>(Arrays.asList(options)), new FileAttribute[0]);
    }

    @Override
    public Path write(Path path, String content, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.write(path, content, UTF_8, options);
    }

    @Override
    public Path write(Path path, String content, Map<String, ?> attrs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.write(path, content, UTF_8, attrs, options);
    }

    @Override
    public Path write(Path path, String content, Charset cs, Map<String, ?> attrs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.write(path, content, cs, new HashSet<OpenOption>(Arrays.asList(options)), this.convert(attrs));
    }

    public void dispose() {
        this.isDisposed = true;
        for (FileSystem fileSystem : this.getFileSystems()) {
            try {
                fileSystem.dispose();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public FileAttribute<?>[] convert(Map<String, ?> attrs) {
        if (attrs == null || attrs.size() == 0) {
            return new FileAttribute[0];
        }
        FileAttribute[] attrsArray = new FileAttribute[attrs.size()];
        int i = 0;
        for (final Map.Entry<String, ?> attr : attrs.entrySet()) {
            attrsArray[i++] = new FileAttribute<Object>(){

                public String name() {
                    return (String)attr.getKey();
                }

                public Object value() {
                    return attr.getValue();
                }
            };
        }
        return attrsArray;
    }

    @Override
    public Path write(Path path, byte[] bytes, Map<String, ?> attrs, OpenOption ... options) throws IOException, UnsupportedOperationException, SecurityException {
        return this.write(path, bytes, new HashSet<OpenOption>(Arrays.asList(options)), this.convert(attrs));
    }

    @Override
    public Path write(Path path, String content, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.write(path, content, UTF_8, options, attrs);
    }

    @Override
    public Path write(Path path, String content, Charset cs, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.write(path, content.getBytes(cs), options, attrs);
    }

    @Override
    public Path write(Path path, byte[] bytes, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        SeekableByteChannel byteChannel;
        try {
            byteChannel = this.newByteChannel(path, this.buildOptions(options, new OpenOption[0]), attrs);
        }
        catch (FileAlreadyExistsException ex) {
            ((AbstractPath)path).clearCache();
            byteChannel = this.newByteChannel(path, this.buildOptions(options, new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING}), attrs);
        }
        try {
            byteChannel.write(ByteBuffer.wrap(bytes));
            byteChannel.close();
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
        return path;
    }

    protected abstract Set<? extends OpenOption> buildOptions(Set<? extends OpenOption> var1, OpenOption ... var2);

    @Override
    public String getId() {
        return this.id;
    }
}

