/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.attribute;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class DotFileAttrViewTest {
    protected static final List<File> tempFiles = new ArrayList<File>();
    private static boolean created = false;
    protected static IOService ioService = null;

    @Test
    public void testDotFileAttrAccess() throws IOException {
        URI newRepo = URI.create("git://" + new Date().getTime() + "-repo-test");
        this.ioService().newFileSystem(newRepo, new HashMap());
        Path dir = this.ioService().get(newRepo);
        Path file = dir.resolve("myFile.txt");
        this.ioService().write(file, "mycontent", Collections.emptySet(), new FileAttribute[0]);
        DublinCoreView view = (DublinCoreView)this.ioService().getFileAttributeView(file, DublinCoreView.class);
        Assert.assertNotNull((Object)view);
        Assert.assertNotNull((Object)view.readAttributes());
        Assert.assertNotNull((Object)view.readAttributes().languages());
        Assert.assertEquals((long)0L, (long)view.readAttributes().languages().size());
        this.ioService().write(file, "mycontent", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.creator";
            }

            public Object value() {
                return "some user name here";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.language[0]";
            }

            public Object value() {
                return "en";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.language[1]";
            }

            public Object value() {
                return "pt-BR";
            }
        }});
        view = (DublinCoreView)this.ioService().getFileAttributeView(file, DublinCoreView.class);
        Assert.assertNotNull((Object)view);
        Assert.assertNotNull((Object)view.readAttributes());
        Assert.assertNotNull((Object)view.readAttributes().languages());
        Assert.assertEquals((long)2L, (long)view.readAttributes().languages().size());
        Assert.assertTrue((boolean)view.readAttributes().languages().contains("pt-BR"));
        Assert.assertTrue((boolean)view.readAttributes().languages().contains("en"));
        Assert.assertEquals((long)1L, (long)view.readAttributes().creators().size());
        Assert.assertTrue((boolean)view.readAttributes().creators().contains("some user name here"));
        Path dotFile = file.getParent().resolve(".myFile.txt");
        Assert.assertTrue((boolean)Files.exists((Path)dotFile, (LinkOption[])new LinkOption[0]));
        VersionAttributeView attrs = (VersionAttributeView)Files.getFileAttributeView((Path)dotFile, VersionAttributeView.class, (LinkOption[])new LinkOption[0]);
        Assert.assertEquals((long)1L, (long)attrs.readAttributes().history().records().size());
        Map result = Files.readAttributes((Path)dotFile, (String)"*", (LinkOption[])new LinkOption[0]);
        Assert.assertNotNull((Object)result);
    }

    public IOService ioService() {
        if (ioService == null) {
            ioService = new IOServiceDotFileImpl();
            Assert.assertTrue((boolean)PriorityDisposableRegistry.getDisposables().contains(ioService));
        }
        return ioService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws IOException {
        if (!created) {
            String path = DotFileAttrViewTest.createTempDirectory().getAbsolutePath();
            System.setProperty("org.uberfire.nio.git.dir", path);
            System.out.println(".niogit: " + path);
            URI newRepo = URI.create("git://repo-test");
            try {
                this.ioService().newFileSystem(newRepo, new HashMap());
            }
            catch (Exception exception) {
            }
            finally {
                created = true;
            }
        }
    }

    @After
    public void tearDown() {
        ioService.dispose();
    }

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        for (File tempFile : tempFiles) {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        tempFiles.add(temp);
        return temp;
    }
}

