/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.io.CommonIOServiceDotFileTest;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;

public class WatcherTest {
    static final IOService ioService = new IOServiceDotFileImpl();
    private static File path = null;
    static FileSystem fs1;
    static JGitFileSystemImpl jgitFs1;

    @BeforeClass
    public static void setup() throws IOException {
        Assert.assertTrue((boolean)PriorityDisposableRegistry.getDisposables().contains(ioService));
        path = CommonIOServiceDotFileTest.createTempDirectory();
        System.setProperty("org.uberfire.nio.git.dir", path.getAbsolutePath());
        URI newRepo = URI.create("git://amend-repo-test");
        fs1 = ioService.newFileSystem(newRepo, new HashMap());
        jgitFs1 = (JGitFileSystemImpl)((JGitFileSystemProxy)fs1).getRealJGitFileSystem();
        Path init = ioService.get(URI.create("git://amend-repo-test/init.file"));
        ioService.write(init, "setupFS!", new OpenOption[0]);
    }

    @AfterClass
    public static void cleanup() {
        FileUtils.deleteQuietly((File)path);
        JGitFileSystemProvider gitFsProvider = (JGitFileSystemProvider)FileSystemProviders.resolveProvider((URI)URI.create("git://whatever"));
        gitFsProvider.shutdown();
        FileUtils.deleteQuietly((File)gitFsProvider.getGitRepoContainerDir());
        System.clearProperty("org.uberfire.nio.git.dir");
    }

    @Test
    public void simpleWatcherTest() {
        Path init = ioService.get(URI.create("git://amend-repo-test/dora1.txt"));
        WatchService ws = init.getFileSystem().newWatchService();
        ioService.write(init, "init!", new OpenOption[0]);
        List events = ws.poll().pollEvents();
        WatchEvent.Kind kind = ((WatchEvent)events.get(0)).kind();
        Assert.assertEquals((Object)kind.name(), (Object)StandardWatchEventKind.ENTRY_CREATE.name());
        Assert.assertEquals((long)1L, (long)events.size());
        ioService.write(init, "init 2!", new OpenOption[0]);
        events = ws.poll().pollEvents();
        kind = ((WatchEvent)events.get(0)).kind();
        Assert.assertEquals((Object)kind.name(), (Object)StandardWatchEventKind.ENTRY_MODIFY.name());
        Assert.assertEquals((long)1L, (long)events.size());
    }
}

