/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.lock;

import java.util.concurrent.locks.ReentrantLock;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.LockableFileSystem;

public class BatchLockControl {
    private ReentrantLock lock = new ReentrantLock(true);
    private FileSystem fileSystemOnBatch;

    public void lock(FileSystem fs) {
        block3: {
            PortablePreconditions.checkNotNull((String)"fs", (Object)fs);
            this.lock.lock();
            try {
                this.makeSureThatIsOnlyOneFSOnCurrentBatch(fs);
                if (this.isAlreadyOnBatch(fs)) break block3;
                if (this.isLockable(fs)) {
                    this.fileSystemOnBatch = fs;
                    ((LockableFileSystem)fs).lock();
                    break block3;
                }
                throw new BatchRuntimeException("Not a LockableFileSystem : " + fs.toString());
            }
            catch (BatchRuntimeException e) {
                this.lock.unlock();
                throw e;
            }
        }
    }

    private void makeSureThatIsOnlyOneFSOnCurrentBatch(FileSystem fs) {
        if (this.fileSystemOnBatch != null && !this.fileSystemOnBatch.equals(fs)) {
            throw new BatchRuntimeException("We already have a batch process running on another FS : " + this.fileSystemOnBatch.toString());
        }
    }

    private boolean isAlreadyOnBatch(FileSystem fileSystem) {
        return this.fileSystemOnBatch != null && this.fileSystemOnBatch.equals(fileSystem);
    }

    public void unlock() {
        if (this.lock.isLocked()) {
            if (this.shouldUnlockLockedFileSystems()) {
                ((LockableFileSystem)this.fileSystemOnBatch).unlock();
                this.fileSystemOnBatch = null;
            }
            this.lock.unlock();
        }
    }

    private boolean shouldUnlockLockedFileSystems() {
        return this.lock.getHoldCount() == 1 && this.fileSystemOnBatch != null && this.isLockable(this.fileSystemOnBatch);
    }

    private boolean isLockable(FileSystem fileSystem) {
        return fileSystem instanceof LockableFileSystem;
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    public int getHoldCount() {
        return this.lock.getHoldCount();
    }

    public FileSystem getFileSystemOnBatch() {
        return this.fileSystemOnBatch;
    }

    public class BatchRuntimeException
    extends RuntimeException {
        public BatchRuntimeException(String message) {
            super(message);
        }
    }
}

