/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.regex;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.io.CommonIOServiceDotFileTest;
import org.uberfire.io.regex.AntPathMatcher;
import org.uberfire.java.nio.file.FileSystems;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;

public class AntPathMatcherTest {
    private static File path;

    @BeforeClass
    public static void setup() throws IOException {
        path = CommonIOServiceDotFileTest.createTempDirectory();
        System.setProperty("org.uberfire.nio.git.dir", path.getAbsolutePath());
        System.out.println(".niogit: " + path.getAbsolutePath());
        URI newRepo = URI.create("git://antpathmatcher");
        FileSystems.newFileSystem((URI)newRepo, new HashMap());
    }

    @AfterClass
    public static void cleanup() {
        FileUtils.deleteQuietly((File)path);
        JGitFileSystemProvider gitFsProvider = (JGitFileSystemProvider)FileSystemProviders.resolveProvider((URI)URI.create("git://whatever"));
        gitFsProvider.shutdown();
        FileUtils.deleteQuietly((File)gitFsProvider.getGitRepoContainerDir());
    }

    @Test
    public void testIncludes() {
        ArrayList<String> patterns = new ArrayList<String>(){
            {
                this.add("git://**");
                this.add("**/repo/**");
            }
        };
        Path path = Paths.get((URI)URI.create("file:///Users/home"));
        Assert.assertFalse((boolean)AntPathMatcher.includes((Collection)patterns, (Path)path));
        path = Paths.get((URI)URI.create("git://antpathmatcher"));
        Assert.assertTrue((boolean)AntPathMatcher.includes((Collection)patterns, (Path)path));
        path = Paths.get((URI)URI.create("git://main@antpathmatcher"));
        Assert.assertTrue((boolean)AntPathMatcher.includes((Collection)patterns, (Path)path));
    }

    @Test
    public void testIncludesMid() {
        ArrayList<String> patterns = new ArrayList<String>(){
            {
                this.add("default://**");
                this.add("**/repo/**");
            }
        };
        Path path = Paths.get((URI)URI.create("file:///Users/home"));
        Assert.assertTrue((boolean)AntPathMatcher.includes((Collection)patterns, (Path)path));
        path = Paths.get((URI)URI.create("git://antpathmatcher"));
        Assert.assertFalse((boolean)AntPathMatcher.includes((Collection)patterns, (Path)path));
        path = Paths.get((URI)URI.create("git://main@antpathmatcher/repo/sss"));
        Assert.assertTrue((boolean)AntPathMatcher.includes((Collection)patterns, (Path)path));
    }

    @Test
    public void testExcludes() {
        ArrayList<String> patterns = new ArrayList<String>(){
            {
                this.add("git://**");
                this.add("**/repo/**");
            }
        };
        Path path = Paths.get((URI)URI.create("file:///Users/home"));
        Assert.assertFalse((boolean)AntPathMatcher.excludes((Collection)patterns, (Path)path));
        path = Paths.get((URI)URI.create("git://antpathmatcher"));
        Assert.assertTrue((boolean)AntPathMatcher.excludes((Collection)patterns, (Path)path));
        path = Paths.get((URI)URI.create("git://main@antpathmatcher"));
        Assert.assertTrue((boolean)AntPathMatcher.excludes((Collection)patterns, (Path)path));
    }

    @Test
    public void testExcludesMid() {
        ArrayList<String> patterns = new ArrayList<String>(){
            {
                this.add("default://**");
                this.add("**/repo/**");
            }
        };
        Path path = Paths.get((URI)URI.create("file:///Users/home"));
        Assert.assertTrue((boolean)AntPathMatcher.excludes((Collection)patterns, (Path)path));
        path = Paths.get((URI)URI.create("git://antpathmatcher"));
        Assert.assertFalse((boolean)AntPathMatcher.excludes((Collection)patterns, (Path)path));
        path = Paths.get((URI)URI.create("git://main@antpathmatcher/repo/sss"));
        Assert.assertTrue((boolean)AntPathMatcher.excludes((Collection)patterns, (Path)path));
    }

    @Test
    public void testFilter() {
        ArrayList<String> includes = new ArrayList<String>(){
            {
                this.add("git://**");
            }
        };
        ArrayList<String> excludes = new ArrayList<String>(){
            {
                this.add("default://**");
            }
        };
        Path path = Paths.get((URI)URI.create("file:///Users/home"));
        Assert.assertFalse((boolean)AntPathMatcher.filter((Collection)includes, (Collection)excludes, (Path)path));
        path = Paths.get((URI)URI.create("git://antpathmatcher"));
        Assert.assertTrue((boolean)AntPathMatcher.filter((Collection)includes, (Collection)excludes, (Path)path));
        path = Paths.get((URI)URI.create("git://main@antpathmatcher/repo/sss"));
        Assert.assertTrue((boolean)AntPathMatcher.filter((Collection)includes, (Collection)excludes, (Path)path));
        Assert.assertTrue((boolean)AntPathMatcher.filter(Collections.emptyList(), Collections.emptyList(), (Path)Paths.get((URI)URI.create("git://main@antpathmatcher/repo/sss"))));
        Assert.assertTrue((boolean)AntPathMatcher.filter(Collections.emptyList(), Collections.emptyList(), (Path)Paths.get((URI)URI.create("git://antpathmatcher"))));
    }

    @Test
    public void testIncludesUri() {
        ArrayList<String> patterns = new ArrayList<String>(){
            {
                this.add("git://**");
                this.add("**/repo/**");
            }
        };
        Assert.assertFalse((boolean)AntPathMatcher.includes((Collection)patterns, (URI)URI.create("file:///Users/home")));
        Assert.assertTrue((boolean)AntPathMatcher.includes((Collection)patterns, (URI)URI.create("git://antpathmatcher")));
        Assert.assertTrue((boolean)AntPathMatcher.includes((Collection)patterns, (URI)URI.create("git://main@antpathmatcher")));
    }

    @Test
    public void testIncludesMidUri() {
        ArrayList<String> patterns = new ArrayList<String>(){
            {
                this.add("file://**");
                this.add("**/repo/**");
            }
        };
        Assert.assertTrue((boolean)AntPathMatcher.includes((Collection)patterns, (URI)URI.create("file:///Users/home")));
        Assert.assertFalse((boolean)AntPathMatcher.includes((Collection)patterns, (URI)URI.create("git://antpathmatcher")));
        Assert.assertTrue((boolean)AntPathMatcher.includes((Collection)patterns, (URI)URI.create("git://main@antpathmatcher/repo/sss")));
    }

    @Test
    public void testExcludesUri() {
        ArrayList<String> patterns = new ArrayList<String>(){
            {
                this.add("git://**");
                this.add("**/repo/**");
            }
        };
        Assert.assertFalse((boolean)AntPathMatcher.excludes((Collection)patterns, (URI)URI.create("file:///Users/home")));
        Assert.assertTrue((boolean)AntPathMatcher.excludes((Collection)patterns, (URI)URI.create("git://antpathmatcher")));
        Assert.assertTrue((boolean)AntPathMatcher.excludes((Collection)patterns, (URI)URI.create("git://main@antpathmatcher")));
    }

    @Test
    public void testExcludesMidUri() {
        ArrayList<String> patterns = new ArrayList<String>(){
            {
                this.add("file://**");
                this.add("**/repo/**");
            }
        };
        Assert.assertTrue((boolean)AntPathMatcher.excludes((Collection)patterns, (URI)URI.create("file:///Users/home")));
        Assert.assertFalse((boolean)AntPathMatcher.excludes((Collection)patterns, (URI)URI.create("git://antpathmatcher")));
        Assert.assertTrue((boolean)AntPathMatcher.excludes((Collection)patterns, (URI)URI.create("git://main@antpathmatcher/repo/sss")));
    }

    @Test
    public void testFilterUri() {
        ArrayList<String> includes = new ArrayList<String>(){
            {
                this.add("git://**");
            }
        };
        ArrayList<String> excludes = new ArrayList<String>(){
            {
                this.add("file://**");
            }
        };
        Assert.assertFalse((boolean)AntPathMatcher.filter((Collection)includes, (Collection)excludes, (URI)URI.create("file:///Users/home")));
        Assert.assertTrue((boolean)AntPathMatcher.filter((Collection)includes, (Collection)excludes, (URI)URI.create("git://antpathmatcher")));
        Assert.assertTrue((boolean)AntPathMatcher.filter((Collection)includes, (Collection)excludes, (URI)URI.create("git://main@antpathmatcher/repo/sss")));
        Assert.assertTrue((boolean)AntPathMatcher.filter(Collections.emptyList(), Collections.emptyList(), (URI)URI.create("file:///Users/home")));
        Assert.assertTrue((boolean)AntPathMatcher.filter(Collections.emptyList(), Collections.emptyList(), (URI)URI.create("git://main@antpathmatcher/repo/sss")));
    }
}

