/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.json.client.JSONObject;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.Caller;
import org.uberfire.client.JSNativePlugin;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.perspective.JSPanelDefinition;
import org.uberfire.client.perspective.JSPartDefinition;
import org.uberfire.client.workbench.widgets.panels.PanelManager;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;
import org.uberfire.workbench.services.WorkbenchServices;

@Dependent
public class JSNativePerspective {
    @Inject
    private PanelManager panelManager;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Caller<WorkbenchServices> wbServices;
    private JavaScriptObject obj;
    private static final Collection<String> ROLES = Collections.emptyList();
    private static final Collection<String> TRAITS = Collections.emptyList();

    public void build(JavaScriptObject obj) {
        if (this.obj != null) {
            throw new RuntimeException("Can't build more than once.");
        }
        this.obj = obj;
    }

    public native String getId();

    public native boolean isDefault();

    public void onReveal() {
        if (JSNativePlugin.hasMethod(this.obj, "on_reveal")) {
            JSNativePerspective.executeOnReveal(this.obj);
        }
    }

    public void onClose() {
        if (JSNativePlugin.hasMethod(this.obj, "on_close")) {
            JSNativePerspective.executeOnClose(this.obj);
        }
    }

    public Collection<String> getRoles() {
        return ROLES;
    }

    public Collection<String> getTraits() {
        return TRAITS;
    }

    public PerspectiveDefinition buildPerspective() {
        PerspectiveDefinitionImpl perspectiveDefinition = new PerspectiveDefinitionImpl();
        perspectiveDefinition.setName(this.getId());
        JSPanelDefinition view = JSNativePerspective.getView(this.obj);
        boolean isSerializable = JSNativePerspective.getIsSerializable(this.obj);
        perspectiveDefinition.setTransient(!isSerializable);
        JsArray<JSPartDefinition> parts = view.getParts();
        JsArray<JSPanelDefinition> panels = view.getChildren();
        PanelDefinition root = perspectiveDefinition.getRoot();
        this.buildParts(root, parts);
        this.buildPanels(root, panels);
        return perspectiveDefinition;
    }

    private void buildParts(PanelDefinition panel, JsArray<JSPartDefinition> parts) {
        if (parts != null) {
            for (int i = 0; i < parts.length(); ++i) {
                JSPartDefinition part = (JSPartDefinition)parts.get(i);
                DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(part.getPlaceName());
                if (part.getParameters() != null) {
                    JSONObject json = new JSONObject(part.getParameters());
                    for (String key : json.keySet()) {
                        placeRequest.addParameter(key, json.get(key).isString().stringValue());
                    }
                }
                panel.addPart((PartDefinition)new PartDefinitionImpl((PlaceRequest)placeRequest));
            }
        }
    }

    private void buildPanels(PanelDefinition panel, JsArray<JSPanelDefinition> panels) {
        if (panels != null) {
            for (int i = 0; i < panels.length(); ++i) {
                JSPanelDefinition activePanelDef = (JSPanelDefinition)panels.get(i);
                PanelDefinitionImpl newPanel = new PanelDefinitionImpl();
                if (activePanelDef.getWidth() > 0) {
                    newPanel.setWidth(Integer.valueOf(activePanelDef.getWidth()));
                }
                if (activePanelDef.getMinWidth() > 0) {
                    newPanel.setMinWidth(Integer.valueOf(activePanelDef.getMinWidth()));
                }
                if (activePanelDef.getHeight() > 0) {
                    newPanel.setHeight(Integer.valueOf(activePanelDef.getHeight()));
                }
                if (activePanelDef.getMinHeight() > 0) {
                    newPanel.setHeight(Integer.valueOf(activePanelDef.getMinHeight()));
                }
                this.buildParts((PanelDefinition)newPanel, activePanelDef.getParts());
                this.buildPanels((PanelDefinition)newPanel, activePanelDef.getChildren());
                panel.insertChild(Position.valueOf((String)activePanelDef.getPosition().toUpperCase()), (PanelDefinition)newPanel);
            }
        }
    }

    private static native boolean getIsSerializable(JavaScriptObject var0);

    private static native JSPanelDefinition getView(JavaScriptObject var0);

    private static native void executeOnReveal(JavaScriptObject var0);

    private static native void executeOnClose(JavaScriptObject var0);

    public void onStart() {
    }

    public void onStart(PlaceRequest place) {
    }

    public PanelManager getPanelManager() {
        return this.panelManager;
    }

    public PlaceManager getPlaceManager() {
        return this.placeManager;
    }

    public Caller<WorkbenchServices> getWbServices() {
        return this.wbServices;
    }
}

