/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.impl;

import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.layout.editor.api.PerspectiveServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.impl.LayoutServicesImpl;
import org.uberfire.ext.plugin.backend.PluginServicesImpl;
import org.uberfire.ext.plugin.model.LayoutEditorModel;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;

@Service
@ApplicationScoped
public class PerspectiveServicesImpl
implements PerspectiveServices {
    private PluginServicesImpl pluginServices;
    private LayoutServicesImpl layoutServices;
    private SaveAndRenameServiceImpl<LayoutTemplate, DefaultMetadata> saveAndRenameService;

    @Inject
    public PerspectiveServicesImpl(PluginServicesImpl pluginServices, LayoutServicesImpl layoutServices, SaveAndRenameServiceImpl<LayoutTemplate, DefaultMetadata> saveAndRenameService) {
        this.pluginServices = pluginServices;
        this.layoutServices = layoutServices;
        this.saveAndRenameService = saveAndRenameService;
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public Plugin createNewPerspective(String name, LayoutTemplate.Style style) {
        Plugin perspectivePlugin = this.pluginServices.createNewPlugin(name, PluginType.PERSPECTIVE_LAYOUT);
        LayoutTemplate layoutTemplate = new LayoutTemplate(name, style);
        this.saveLayoutTemplate(perspectivePlugin.getPath(), layoutTemplate, "Perspective '" + name + "' check-in");
        return perspectivePlugin;
    }

    public Collection<LayoutTemplate> listLayoutTemplates() {
        return this.pluginServices.listPlugins(PluginType.PERSPECTIVE_LAYOUT).stream().map(this::getLayoutTemplate).collect(Collectors.toList());
    }

    public LayoutTemplate getLayoutTemplate(String perspectiveName) {
        Plugin perspectivePlugin = this.getLayoutTemplatePlugin(perspectiveName);
        return perspectivePlugin != null ? this.getLayoutTemplate(perspectivePlugin) : null;
    }

    public LayoutTemplate getLayoutTemplate(Path perspectivePath) {
        LayoutEditorModel layoutEditorModel = this.pluginServices.getLayoutEditor(perspectivePath, PluginType.PERSPECTIVE_LAYOUT);
        if (layoutEditorModel.isEmptyLayout()) {
            return new LayoutTemplate(layoutEditorModel.getName(), LayoutTemplate.Style.PAGE);
        }
        return this.layoutServices.convertLayoutFromString(layoutEditorModel.getLayoutEditorModel());
    }

    public LayoutTemplate getLayoutTemplate(Plugin perspectivePlugin) {
        return this.getLayoutTemplate(perspectivePlugin.getPath());
    }

    public Plugin getLayoutTemplatePlugin(String perspectiveName) {
        if (perspectiveName == null) {
            return null;
        }
        for (Plugin plugin : this.pluginServices.listPlugins(PluginType.PERSPECTIVE_LAYOUT)) {
            if (!PluginType.PERSPECTIVE_LAYOUT.equals((Object)plugin.getType()) || !plugin.getName().equals(perspectiveName)) continue;
            return plugin;
        }
        return null;
    }

    public Path saveLayoutTemplate(Path perspectivePath, LayoutTemplate layoutTemplate, String commitMessage) {
        String layoutModel = this.layoutServices.convertLayoutToString(layoutTemplate);
        LayoutEditorModel plugin = new LayoutEditorModel(layoutTemplate.getName(), PluginType.PERSPECTIVE_LAYOUT, perspectivePath, layoutModel);
        this.pluginServices.saveLayout(plugin, commitMessage);
        return perspectivePath;
    }

    public LayoutTemplate convertToLayoutTemplate(String layoutModel) {
        return this.layoutServices.convertLayoutFromString(layoutModel);
    }

    public Path copy(Path path, String newName, String comment) {
        Path pathCopy = this.pluginServices.copy(path, newName, comment);
        this.setLayoutTemplateName(pathCopy, newName, comment);
        return pathCopy;
    }

    public Path copy(Path path, String newName, Path targetDirectory, String comment) {
        Path pathCopy = this.pluginServices.copy(path, newName, targetDirectory, comment);
        this.setLayoutTemplateName(pathCopy, newName, comment);
        return pathCopy;
    }

    public Path rename(Path path, String newName, String comment) {
        Path pathRenamed = this.pluginServices.rename(path, newName, comment);
        this.setLayoutTemplateName(pathRenamed, newName, comment);
        return pathRenamed;
    }

    public void delete(Path path, String comment) {
        this.pluginServices.delete(path, comment);
    }

    private void setLayoutTemplateName(Path path, String newName, String comment) {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(path);
        layoutTemplate.setName(newName);
        String layoutModel = this.layoutServices.convertLayoutToString(layoutTemplate);
        LayoutEditorModel pluginCopy = new LayoutEditorModel(newName, PluginType.PERSPECTIVE_LAYOUT, path, layoutModel);
        this.pluginServices.saveLayout(pluginCopy, comment);
    }

    public Path save(Path path, LayoutTemplate content, DefaultMetadata metadata, String comment) {
        return this.saveLayoutTemplate(path, content, comment);
    }

    public Path saveAndRename(Path path, String newFileName, DefaultMetadata metadata, LayoutTemplate content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }
}

