/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.metamodel;

import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.StreamSupport;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.ext.metadata.model.impl.MetaObjectImpl;
import org.uberfire.ext.metadata.model.impl.MetaPropertyImpl;
import org.uberfire.ext.metadata.model.schema.MetaObject;
import org.uberfire.ext.metadata.model.schema.MetaProperty;

public class MetaModelBuilder {
    private final MetaModelStore metaModelStore;

    public MetaModelBuilder(MetaModelStore metaModelStore) {
        this.metaModelStore = metaModelStore;
    }

    public void updateMetaModel(KObject object) {
        MetaObject metaObject = this.metaModelStore.getMetaObject(object.getType().getName());
        if (metaObject == null) {
            this.metaModelStore.add(this.newMetaObject(object));
        } else {
            Optional.ofNullable(object.getProperties()).ifPresent(kProperties -> {
                for (KProperty<?> property : object.getProperties()) {
                    Optional<MetaProperty> metaProperty = metaObject.getProperty(property.getName());
                    if (!metaProperty.isPresent()) {
                        metaObject.addProperty(this.newMetaProperty(property));
                        continue;
                    }
                    metaProperty.get().addType(property.getValue().getClass());
                    if (!property.isSearchable()) continue;
                    metaProperty.get().setAsSearchable();
                }
                this.metaModelStore.update(metaObject);
            });
        }
    }

    public MetaObject newMetaObject(KObject object) {
        HashSet<MetaProperty> properties = new HashSet<MetaProperty>();
        Optional.ofNullable(object.getProperties()).ifPresent(kProperties -> StreamSupport.stream(kProperties.spliterator(), false).forEach(property -> properties.add(this.newMetaProperty((KProperty<?>)property))));
        return new MetaObjectImpl(object.getType(), properties);
    }

    private MetaProperty newMetaProperty(final KProperty<?> property) {
        CopyOnWriteArraySet types = new CopyOnWriteArraySet<Class<?>>(){
            {
                this.add(property.getValue().getClass());
            }
        };
        return new MetaPropertyImpl(property.getName(), property.isSearchable(), property.isSortable(), types);
    }
}

