/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.BatchIndex;
import org.uberfire.ext.metadata.io.IOServiceIndexedUtil;
import org.uberfire.ext.metadata.io.IndexersFactory;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.io.IOService;
import org.uberfire.io.IOWatchService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FSPath;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.base.dotfiles.DotFileUtils;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.ProviderNotFoundException;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;

public class IOServiceIndexedImpl
extends IOServiceDotFileImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOServiceIndexedImpl.class);
    private final MetaIndexEngine indexEngine;
    private final Class<? extends FileAttributeView>[] views;
    private final List<String> watchedList = new ArrayList<String>();
    private final List<WatchService> watchServices = new ArrayList<WatchService>();
    private final BatchIndex batchIndex;
    private ExecutorService executorService;

    public IOServiceIndexedImpl(MetaIndexEngine indexEngine, ExecutorService executorService, Class<? extends FileAttributeView> ... views) {
        this(indexEngine, new NOPObserver(), executorService, views);
    }

    public IOServiceIndexedImpl(String id, MetaIndexEngine indexEngine, ExecutorService executorService, Class<? extends FileAttributeView> ... views) {
        this(id, indexEngine, (Observer)new NOPObserver(), executorService, views);
    }

    public IOServiceIndexedImpl(IOWatchService watchService, MetaIndexEngine indexEngine, ExecutorService executorService, Class<? extends FileAttributeView> ... views) {
        this(watchService, indexEngine, (Observer)new NOPObserver(), executorService, views);
    }

    public IOServiceIndexedImpl(String id, IOWatchService watchService, MetaIndexEngine indexEngine, ExecutorService executorService, Class<? extends FileAttributeView> ... views) {
        this(id, watchService, indexEngine, new NOPObserver(), executorService, views);
    }

    public IOServiceIndexedImpl(MetaIndexEngine indexEngine, Observer observer, ExecutorService executorService, Class<? extends FileAttributeView> ... views) {
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.views = views;
        this.executorService = executorService;
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, observer, executorService, views);
    }

    public IOServiceIndexedImpl(String id, MetaIndexEngine indexEngine, Observer observer, ExecutorService executorService, Class<? extends FileAttributeView> ... views) {
        super(id);
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.views = views;
        this.executorService = executorService;
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, observer, executorService, views);
    }

    public IOServiceIndexedImpl(IOWatchService watchService, MetaIndexEngine indexEngine, Observer observer, ExecutorService executorService, Class<? extends FileAttributeView> ... views) {
        super(watchService);
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.views = views;
        this.executorService = executorService;
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, observer, executorService, views);
    }

    public IOServiceIndexedImpl(String id, IOWatchService watchService, MetaIndexEngine indexEngine, Observer observer, ExecutorService executorService, Class<? extends FileAttributeView> ... views) {
        super(id, watchService);
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.views = views;
        this.executorService = executorService;
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, observer, executorService, views);
    }

    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, ProviderNotFoundException, SecurityException {
        FileSystem fs = super.getFileSystem(uri);
        if (this.shouldPerformInitialIndex(fs)) {
            this.setupBatchIndex(fs);
        }
        this.setupWatchService(fs);
        return fs;
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        FileSystem fs = super.newFileSystem(uri, env);
        if (this.shouldPerformInitialIndex(fs)) {
            this.setupBatchIndex(fs);
        }
        this.setupWatchService(fs);
        return fs;
    }

    private boolean shouldPerformInitialIndex(FileSystem fs) {
        return this.rootDirStream(fs).filter(dir -> this.hasContent((Path)dir)).findAny().isPresent() && this.indexEngine.freshIndex(KObjectUtil.toKCluster(fs));
    }

    private boolean hasContent(Path dir) {
        try (DirectoryStream children = this.newDirectoryStream(dir, path -> !path.endsWith("readme.md"));){
            boolean bl = children.iterator().hasNext();
            return bl;
        }
    }

    private Stream<Path> rootDirStream(FileSystem fs) {
        return StreamSupport.stream(fs.getRootDirectories().spliterator(), false);
    }

    public int priority() {
        return 60;
    }

    public void dispose() {
        for (WatchService watchService : this.watchServices) {
            watchService.close();
        }
        super.dispose();
    }

    private void setupBatchIndex(FileSystem fs) {
        this.indexEngine.prepareBatch(KObjectUtil.toKCluster(fs));
        this.batchIndex.runAsync(fs);
    }

    protected void setupWatchService(final FileSystem fs) {
        if (this.watchedList.contains(fs.getName())) {
            return;
        }
        final WatchService ws = fs.newWatchService();
        this.watchedList.add(fs.getName());
        this.watchServices.add(ws);
        final ExecutorService defaultInstance = this.executorService;
        defaultInstance.execute((Runnable)new DescriptiveRunnable(){

            public String getDescription() {
                return "IOServiceIndexedImpl(" + ws.toString() + ")";
            }

            public void run() {
                while (!IOServiceIndexedImpl.this.isDisposed && !ws.isClose()) {
                    WatchKey wk;
                    try {
                        wk = ws.take();
                    }
                    catch (Exception ex) {
                        break;
                    }
                    final List events = wk.pollEvents();
                    DescriptiveRunnable job = new DescriptiveRunnable(){

                        public String getDescription() {
                            return "IOServiceIndexedImpl(IndexOnEvent - " + ws.toString() + ")";
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            KCluster kCluster = KObjectUtil.toKCluster(fs);
                            Set<Path> eventRealPaths = this.getRealCreatedPaths(events);
                            try {
                                IOServiceIndexedImpl.this.indexEngine.startBatch(kCluster);
                                this.processEvents(events, eventRealPaths);
                                IOServiceIndexedImpl.this.indexEngine.commit(kCluster);
                            }
                            catch (DisposedException e) {
                                return;
                            }
                            finally {
                                IOServiceIndexedImpl.this.indexEngine.abort(kCluster);
                            }
                        }

                        private void processEvents(List<WatchEvent<?>> events2, Set<Path> eventRealPaths) throws DisposedException {
                            for (WatchEvent<?> event : events2) {
                                if (this.isDisposed()) {
                                    throw new DisposedException();
                                }
                                try {
                                    WatchContext context = (WatchContext)event.context();
                                    this.processEvent(eventRealPaths, event, context);
                                }
                                catch (Exception ex) {
                                    LOGGER.error("Error during indexing. { " + event.toString() + " }", (Throwable)ex);
                                }
                            }
                        }

                        private void processEvent(Set<Path> eventRealPaths, WatchEvent event, WatchContext context) throws DisposedException {
                            if (event.kind() == StandardWatchEventKind.ENTRY_MODIFY || event.kind() == StandardWatchEventKind.ENTRY_CREATE) {
                                this.processCreationAndModificationEvent(eventRealPaths, context);
                            }
                            if (event.kind() == StandardWatchEventKind.ENTRY_RENAME) {
                                this.processRenameEvent(context);
                            }
                            if (event.kind() == StandardWatchEventKind.ENTRY_DELETE) {
                                this.processDeleteEvent(event, context);
                            }
                        }

                        private void processDeleteEvent(WatchEvent object, WatchContext context) throws DisposedException {
                            Path oldPath = context.getOldPath();
                            IOServiceIndexedImpl.this.indexEngine.delete(KObjectUtil.toKObjectKey(oldPath));
                            for (Indexer indexer : IndexersFactory.getIndexers()) {
                                KObjectKey kObject;
                                if (this.isDisposed()) {
                                    throw new DisposedException();
                                }
                                if (!indexer.supportsPath(oldPath) || (kObject = indexer.toKObjectKey(oldPath)) == null) continue;
                                IOServiceIndexedImpl.this.indexEngine.delete(kObject);
                            }
                        }

                        private void processRenameEvent(WatchContext context) throws DisposedException {
                            Path sourcePath = context.getOldPath();
                            Path destinationPath = context.getPath();
                            IOServiceIndexedImpl.this.indexEngine.rename(KObjectUtil.toKObjectKey(sourcePath), KObjectUtil.toKObject(destinationPath, new FileAttribute[0]));
                            for (Indexer indexer : IndexersFactory.getIndexers()) {
                                if (this.isDisposed()) {
                                    throw new DisposedException();
                                }
                                if (!indexer.supportsPath(destinationPath)) continue;
                                KObjectKey kObjectSource = indexer.toKObjectKey(sourcePath);
                                KObject kObjectDestination = indexer.toKObject(destinationPath);
                                if (kObjectSource == null || kObjectDestination == null) continue;
                                IOServiceIndexedImpl.this.indexEngine.rename(kObjectSource, kObjectDestination);
                            }
                        }

                        private void processCreationAndModificationEvent(Set<Path> eventRealPaths, WatchContext context) throws DisposedException {
                            Class[] realPath;
                            Class[] path = context.getPath();
                            if (path.getFileName().toString().startsWith(".") && !IOServiceIndexedUtil.isBlackListed((Path)path) && !eventRealPaths.contains(realPath = DotFileUtils.undot((Path)path))) {
                                path = realPath;
                            }
                            if (!path.getFileName().toString().startsWith(".")) {
                                for (Class view : IOServiceIndexedImpl.this.views) {
                                    IOServiceIndexedImpl.this.getFileAttributeView((Path)path, view);
                                }
                                FileAttribute[] allAttrs = IOServiceIndexedImpl.this.convert(IOServiceIndexedImpl.this.readAttributes((Path)path));
                                IOServiceIndexedImpl.this.indexEngine.index(KObjectUtil.toKObject((Path)path, allAttrs));
                                for (Indexer indexer : IndexersFactory.getIndexers()) {
                                    KObject kObject;
                                    if (this.isDisposed()) {
                                        throw new DisposedException();
                                    }
                                    if (!indexer.supportsPath((Path)path) || (kObject = indexer.toKObject((Path)path)) == null) continue;
                                    IOServiceIndexedImpl.this.indexEngine.index(kObject);
                                }
                            }
                        }

                        private Set<Path> getRealCreatedPaths(List<WatchEvent<?>> events2) {
                            HashSet<Path> eventRealPaths = new HashSet<Path>();
                            for (WatchEvent<?> event : events2) {
                                Path path;
                                WatchContext context = (WatchContext)event.context();
                                if (event.kind() != StandardWatchEventKind.ENTRY_MODIFY && event.kind() != StandardWatchEventKind.ENTRY_CREATE || (path = context.getPath()).getFileName().toString().startsWith(".")) continue;
                                eventRealPaths.add(path);
                            }
                            return eventRealPaths;
                        }

                        private boolean isDisposed() {
                            return IOServiceIndexedImpl.this.isDisposed || ws.isClose();
                        }
                    };
                    defaultInstance.execute((Runnable)job);
                }
            }
        });
    }

    public void delete(Path path, DeleteOption ... options) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException, SecurityException {
        KCluster cluster = KObjectUtil.toKCluster(path.getFileSystem());
        super.delete(path, options);
        if (path instanceof FSPath) {
            this.indexEngine.delete(cluster);
        }
    }

    public boolean deleteIfExists(Path path, DeleteOption ... options) throws IllegalArgumentException, DirectoryNotEmptyException, IOException, SecurityException {
        KCluster cluster = KObjectUtil.toKCluster(path.getFileSystem());
        boolean result = super.deleteIfExists(path, options);
        if (result && path instanceof FSPath) {
            this.indexEngine.delete(cluster);
        }
        return result;
    }

    public MetaIndexEngine getIndexEngine() {
        return this.indexEngine;
    }

    private static class NOPObserver
    implements Observer {
        private NOPObserver() {
        }

        public void information(String message) {
        }

        public void warning(String message) {
        }

        public void error(String message) {
        }
    }

    private static class DisposedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private DisposedException() {
        }
    }
}

