/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.DisposedException;
import org.uberfire.ext.metadata.io.IndexableIOEvent;
import org.uberfire.ext.metadata.io.IndexerDispatcher;
import org.uberfire.ext.metadata.io.IndexersFactory;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttributeView;

public final class BatchIndex {
    private static final Logger LOG = LoggerFactory.getLogger(BatchIndex.class);
    private final MetaIndexEngine indexEngine;
    private final Class<? extends FileAttributeView>[] views;
    private final AtomicBoolean indexDisposed = new AtomicBoolean(false);
    private final Observer observer;
    private final ExecutorService executorService;
    private final IndexersFactory indexersFactory;
    private final IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory;

    @SafeVarargs
    public BatchIndex(MetaIndexEngine indexEngine, Observer observer, ExecutorService executorService, IndexersFactory indexersFactory, IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory, Class<? extends FileAttributeView> ... views) {
        this.indexersFactory = indexersFactory;
        this.dispatcherFactory = dispatcherFactory;
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.observer = (Observer)PortablePreconditions.checkNotNull((String)"observer", (Object)observer);
        this.views = views;
        this.executorService = executorService;
    }

    public void runAsync(final FileSystem fs) {
        if (fs != null && fs.getRootDirectories().iterator().hasNext()) {
            this.executorService.execute((Runnable)new DescriptiveRunnable(){

                public String getDescription() {
                    return "FS BatchIndex [" + ((FileSystemId)fs).id() + "]";
                }

                public void run() {
                    block2: {
                        final AtomicBoolean indexFinished = new AtomicBoolean(false);
                        BatchIndex.this.indexEngine.beforeDispose(new Runnable(){

                            @Override
                            public void run() {
                                BatchIndex.this.indexDisposed.set(true);
                                if (!indexFinished.get()) {
                                    BatchIndex.this.indexEngine.delete(KObjectUtil.toKCluster(fs));
                                }
                            }
                        });
                        try {
                            BatchIndex.this.run(fs, null);
                            indexFinished.set(true);
                        }
                        catch (Exception ex) {
                            if (BatchIndex.this.indexDisposed.get()) break block2;
                            BatchIndex.this.logError("FileSystem Index fails. [@" + fs.toString() + "]", ex);
                        }
                    }
                }
            });
        }
    }

    public void run(FileSystem fs, Runnable callback) {
        if (fs == null) {
            return;
        }
        ArrayList<Runnable> exceptionCleanup = new ArrayList<Runnable>(1);
        try {
            KCluster cluster = KObjectUtil.toKCluster(fs);
            IndexerDispatcher dispatcher = this.dispatcherFactory.create(this.indexersFactory.getIndexers(), cluster);
            for (Path root : fs.getRootDirectories()) {
                if (this.indexDisposed.get()) break;
                exceptionCleanup.add(() -> dispatcher.dispose());
                this.queueIndexingEvents(root, dispatcher);
            }
            if (!this.indexDisposed.get()) {
                this.logInformation("Starting indexing of " + fs.getName() + " ...");
                ((CompletableFuture)dispatcher.schedule(this.executorService).thenRun(() -> {
                    this.logInformation("Completed indexing of " + fs.getName());
                    if (callback != null) {
                        callback.run();
                    }
                })).exceptionally(ex -> {
                    try {
                        throw ex;
                    }
                    catch (DisposedException de) {
                        this.logWarning("Batch index couldn't finish. [@" + fs.getName() + "]");
                    }
                    catch (IllegalStateException ise) {
                        this.logError("Index fails - Index has an invalid state. [@" + fs.getName() + "]", (Throwable)ex);
                    }
                    catch (Throwable t) {
                        this.logError("Index fails. [@" + fs.getName() + "]", (Throwable)ex);
                    }
                    return null;
                });
            } else {
                this.logWarning("Batch index couldn't finish. [@" + fs.getName() + "]");
            }
        }
        catch (Exception ex2) {
            if (this.indexDisposed.get()) {
                this.logWarning("Batch index couldn't finish. [@" + fs.getName() + "]");
            }
            this.logError("Index fails. [@" + fs.getName() + "]", ex2);
            exceptionCleanup.forEach(action -> action.run());
        }
    }

    private void queueIndexingEvents(final Path root, final IndexerDispatcher dispatcher) {
        Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)root)), (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                block6: {
                    if (BatchIndex.this.indexDisposed.get()) {
                        return FileVisitResult.TERMINATE;
                    }
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (file.getFileName().toString().startsWith(".")) break block6;
                        if (!BatchIndex.this.indexDisposed.get()) {
                            dispatcher.offer(new IndexableIOEvent.NewFileEvent(file));
                            break block6;
                        }
                        return FileVisitResult.TERMINATE;
                    }
                    catch (Exception ex) {
                        if (BatchIndex.this.indexDisposed.get()) {
                            BatchIndex.this.logWarning("Batch index couldn't finish. [@" + root.toUri().toString() + "]");
                            return FileVisitResult.TERMINATE;
                        }
                        BatchIndex.this.logError("Index fails. [@" + file.toString() + "]", ex);
                    }
                }
                if (BatchIndex.this.indexDisposed.get()) {
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void logInformation(String message) {
        this.observer.information(message);
        LOG.info(message);
    }

    private void logWarning(String message) {
        this.observer.warning(message);
        LOG.warn(message);
    }

    private void logError(String message, Throwable throwable) {
        this.observer.error(message);
        LOG.error(message, throwable);
    }

    public void dispose() {
        this.indexEngine.dispose();
    }
}

