/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.BatchIndex;
import org.uberfire.ext.metadata.io.CoreIndexer;
import org.uberfire.ext.metadata.io.DisposedException;
import org.uberfire.ext.metadata.io.IOServiceIndexedUtil;
import org.uberfire.ext.metadata.io.IndexableIOEvent;
import org.uberfire.ext.metadata.io.IndexerDispatcher;
import org.uberfire.ext.metadata.io.IndexersFactory;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.io.IOService;
import org.uberfire.io.IOWatchService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FSPath;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.base.dotfiles.DotFileUtils;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.ProviderNotFoundException;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.FileAttributeView;

public class IOServiceIndexedImpl
extends IOServiceDotFileImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOServiceIndexedImpl.class);
    private final MetaIndexEngine indexEngine;
    private final Class<? extends FileAttributeView>[] views;
    private final Map<String, WatchService> watchServicesByFS = new HashMap<String, WatchService>();
    private final BatchIndex batchIndex;
    private final IndexersFactory indexersFactory;
    private final Collection<IndexerDispatcher> activeIndexerDispatchers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory;
    private ExecutorService executorService;

    @SafeVarargs
    public IOServiceIndexedImpl(MetaIndexEngine indexEngine, ExecutorService executorService, IndexersFactory indexersFactory, IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory, Class<? extends FileAttributeView> ... views) {
        this(indexEngine, new NOPObserver(), executorService, indexersFactory, dispatcherFactory, views);
    }

    @SafeVarargs
    public IOServiceIndexedImpl(String id, MetaIndexEngine indexEngine, ExecutorService executorService, IndexersFactory indexersFactory, IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory, Class<? extends FileAttributeView> ... views) {
        this(id, indexEngine, (Observer)new NOPObserver(), executorService, indexersFactory, dispatcherFactory, views);
    }

    @SafeVarargs
    public IOServiceIndexedImpl(IOWatchService watchService, MetaIndexEngine indexEngine, ExecutorService executorService, IndexersFactory indexersFactory, IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory, Class<? extends FileAttributeView> ... views) {
        this(watchService, indexEngine, (Observer)new NOPObserver(), executorService, indexersFactory, dispatcherFactory, views);
    }

    @SafeVarargs
    public IOServiceIndexedImpl(String id, IOWatchService watchService, MetaIndexEngine indexEngine, ExecutorService executorService, IndexersFactory indexersFactory, IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory, Class<? extends FileAttributeView> ... views) {
        this(id, watchService, indexEngine, new NOPObserver(), executorService, indexersFactory, dispatcherFactory, views);
    }

    @SafeVarargs
    public IOServiceIndexedImpl(MetaIndexEngine indexEngine, Observer observer, ExecutorService executorService, IndexersFactory indexersFactory, IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory, Class<? extends FileAttributeView> ... views) {
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.views = views;
        this.executorService = executorService;
        this.indexersFactory = indexersFactory;
        this.dispatcherFactory = dispatcherFactory;
        this.batchIndex = new BatchIndex(indexEngine, observer, executorService, indexersFactory, dispatcherFactory, views);
        this.ensureCoreIndexerExists();
    }

    @SafeVarargs
    public IOServiceIndexedImpl(String id, MetaIndexEngine indexEngine, Observer observer, ExecutorService executorService, IndexersFactory indexersFactory, IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory, Class<? extends FileAttributeView> ... views) {
        super(id);
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.views = views;
        this.executorService = executorService;
        this.indexersFactory = indexersFactory;
        this.dispatcherFactory = dispatcherFactory;
        this.batchIndex = new BatchIndex(indexEngine, observer, executorService, indexersFactory, dispatcherFactory, views);
        this.ensureCoreIndexerExists();
    }

    @SafeVarargs
    public IOServiceIndexedImpl(IOWatchService watchService, MetaIndexEngine indexEngine, Observer observer, ExecutorService executorService, IndexersFactory indexersFactory, IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory, Class<? extends FileAttributeView> ... views) {
        super(watchService);
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.views = views;
        this.executorService = executorService;
        this.indexersFactory = indexersFactory;
        this.dispatcherFactory = dispatcherFactory;
        this.batchIndex = new BatchIndex(indexEngine, observer, executorService, indexersFactory, dispatcherFactory, views);
        this.ensureCoreIndexerExists();
    }

    @SafeVarargs
    public IOServiceIndexedImpl(String id, IOWatchService watchService, MetaIndexEngine indexEngine, Observer observer, ExecutorService executorService, IndexersFactory indexersFactory, IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory, Class<? extends FileAttributeView> ... views) {
        super(id, watchService);
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.views = views;
        this.executorService = executorService;
        this.indexersFactory = indexersFactory;
        this.dispatcherFactory = dispatcherFactory;
        this.batchIndex = new BatchIndex(indexEngine, observer, executorService, indexersFactory, dispatcherFactory, views);
        this.ensureCoreIndexerExists();
    }

    private void ensureCoreIndexerExists() {
        boolean containsCoreIndexer = this.indexersFactory.getIndexers().stream().anyMatch(indexer -> indexer.getClass().equals(CoreIndexer.class));
        if (!containsCoreIndexer) {
            this.indexersFactory.addIndexer(new CoreIndexer((IOService)this, this.views));
        }
    }

    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, ProviderNotFoundException, SecurityException {
        FileSystem fs = super.getFileSystem(uri);
        this.maybeSetupBatchIndex(fs);
        this.setupWatchService(fs);
        return fs;
    }

    private void maybeSetupBatchIndex(FileSystem fs) {
        if (this.shouldPerformInitialIndex(fs)) {
            this.setupBatchIndex(fs);
        }
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        FileSystem fs = super.newFileSystem(uri, env);
        this.maybeSetupBatchIndex(fs);
        this.setupWatchService(fs);
        return fs;
    }

    private boolean shouldPerformInitialIndex(FileSystem fs) {
        return this.indexEngine.freshIndex(KObjectUtil.toKCluster(fs)) && this.rootDirStream(fs).filter(dir -> this.hasContent((Path)dir)).findAny().isPresent();
    }

    private boolean hasContent(Path dir) {
        try (DirectoryStream children = this.newDirectoryStream(dir, path -> !path.endsWith("readme.md"));){
            boolean bl = children.iterator().hasNext();
            return bl;
        }
    }

    private Stream<Path> rootDirStream(FileSystem fs) {
        return StreamSupport.stream(fs.getRootDirectories().spliterator(), false);
    }

    public int priority() {
        return 60;
    }

    public void dispose() {
        this.watchServicesByFS.values().forEach(ws -> ws.close());
        this.activeIndexerDispatchers.forEach(d -> d.dispose());
        super.dispose();
    }

    private void setupBatchIndex(FileSystem fs) {
        this.indexEngine.prepareBatch(KObjectUtil.toKCluster(fs));
        this.batchIndex.runAsync(fs);
    }

    protected void setupWatchService(final FileSystem fs) {
        if (this.watchServicesByFS.containsKey(fs.getName())) {
            return;
        }
        final WatchService ws = fs.newWatchService();
        this.watchServicesByFS.put(fs.getName(), ws);
        final ExecutorService defaultInstance = this.executorService;
        defaultInstance.execute((Runnable)new DescriptiveRunnable(){

            public String getDescription() {
                return "IOServiceIndexedImpl(" + ws.toString() + ")";
            }

            public void run() {
                while (!IOServiceIndexedImpl.this.isDisposed && !ws.isClose()) {
                    WatchKey wk;
                    try {
                        wk = ws.take();
                    }
                    catch (Exception ex) {
                        break;
                    }
                    final List events = wk.pollEvents();
                    DescriptiveRunnable job = new DescriptiveRunnable(){

                        public String getDescription() {
                            return "IOServiceIndexedImpl(IndexOnEvent - " + ws.toString() + ")";
                        }

                        public void run() {
                            KCluster kCluster = KObjectUtil.toKCluster(fs);
                            IndexerDispatcher dispatcher = IOServiceIndexedImpl.this.dispatcherFactory.create(IOServiceIndexedImpl.this.indexersFactory.getIndexers(), kCluster);
                            Set<Path> eventRealPaths = this.getRealCreatedPaths(events);
                            try {
                                this.queueEvents(events, eventRealPaths, dispatcher);
                                this.scheduleIndexing(dispatcher, events, kCluster);
                            }
                            catch (DisposedException e) {
                                return;
                            }
                        }

                        private void scheduleIndexing(IndexerDispatcher dispatcher, List<WatchEvent<?>> events2, KCluster kCluster) {
                            IOServiceIndexedImpl.this.activeIndexerDispatchers.add(dispatcher);
                            ((CompletableFuture)dispatcher.schedule(IOServiceIndexedImpl.this.executorService).thenRun(() -> LOGGER.info("Completed indexing {} events in cluster [{}].", (Object)events2.size(), (Object)kCluster))).whenComplete((result, exception) -> IOServiceIndexedImpl.this.activeIndexerDispatchers.remove(dispatcher));
                        }

                        private void queueEvents(List<WatchEvent<?>> events2, Set<Path> eventRealPaths, IndexerDispatcher dispatcher) throws DisposedException {
                            for (WatchEvent<?> event : events2) {
                                if (this.isDisposed()) {
                                    throw new DisposedException();
                                }
                                try {
                                    WatchContext context = (WatchContext)event.context();
                                    this.queueEvent(eventRealPaths, event, context, dispatcher);
                                }
                                catch (Exception ex) {
                                    LOGGER.error("Error during indexing. { " + event.toString() + " }", (Throwable)ex);
                                }
                            }
                        }

                        private void queueEvent(Set<Path> eventRealPaths, WatchEvent event, WatchContext context, IndexerDispatcher dispatcher) throws DisposedException {
                            if (event.kind() == StandardWatchEventKind.ENTRY_MODIFY || event.kind() == StandardWatchEventKind.ENTRY_CREATE) {
                                this.queueCreationAndModificationEvent(eventRealPaths, context, dispatcher);
                            }
                            if (event.kind() == StandardWatchEventKind.ENTRY_RENAME) {
                                this.queueRenameEvent(context, dispatcher);
                            }
                            if (event.kind() == StandardWatchEventKind.ENTRY_DELETE) {
                                this.queueDeleteEvent(event, context, dispatcher);
                            }
                        }

                        private void queueDeleteEvent(WatchEvent object, WatchContext context, IndexerDispatcher dispatcher) throws DisposedException {
                            Path oldPath = context.getOldPath();
                            dispatcher.offer(new IndexableIOEvent.DeletedFileEvent(oldPath));
                        }

                        private void queueRenameEvent(WatchContext context, IndexerDispatcher dispatcher) throws DisposedException {
                            Path sourcePath = context.getOldPath();
                            Path destinationPath = context.getPath();
                            dispatcher.offer(new IndexableIOEvent.RenamedFileEvent(sourcePath, destinationPath));
                        }

                        private void queueCreationAndModificationEvent(Set<Path> eventRealPaths, WatchContext context, IndexerDispatcher dispatcher) throws DisposedException {
                            Path realPath;
                            Path path = context.getPath();
                            if (path.getFileName().toString().startsWith(".") && !IOServiceIndexedUtil.isBlackListed(path) && !eventRealPaths.contains(realPath = DotFileUtils.undot((Path)path))) {
                                path = realPath;
                            }
                            if (!path.getFileName().toString().startsWith(".")) {
                                dispatcher.offer(new IndexableIOEvent.NewFileEvent(path));
                            }
                        }

                        private Set<Path> getRealCreatedPaths(List<WatchEvent<?>> events2) {
                            HashSet<Path> eventRealPaths = new HashSet<Path>();
                            for (WatchEvent<?> event : events2) {
                                Path path;
                                WatchContext context = (WatchContext)event.context();
                                if (event.kind() != StandardWatchEventKind.ENTRY_MODIFY && event.kind() != StandardWatchEventKind.ENTRY_CREATE || (path = context.getPath()).getFileName().toString().startsWith(".")) continue;
                                eventRealPaths.add(path);
                            }
                            return eventRealPaths;
                        }

                        private boolean isDisposed() {
                            return IOServiceIndexedImpl.this.isDisposed || ws.isClose();
                        }
                    };
                    defaultInstance.execute((Runnable)job);
                }
            }
        });
    }

    public void delete(Path path, DeleteOption ... options) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException, SecurityException {
        super.delete(path, options);
        if (path instanceof FSPath) {
            FileSystem fileSystem = path.getFileSystem();
            this.cleanupDeletedFS(fileSystem);
        }
    }

    private void cleanupDeletedFS(FileSystem fs) {
        WatchService ws = this.watchServicesByFS.remove(fs.getName());
        if (ws != null && !ws.isClose()) {
            ws.close();
        }
        this.indexEngine.delete(KObjectUtil.toKCluster(fs));
    }

    public boolean deleteIfExists(Path path, DeleteOption ... options) throws IllegalArgumentException, DirectoryNotEmptyException, IOException, SecurityException {
        boolean result = super.deleteIfExists(path, options);
        if (result && path instanceof FSPath) {
            FileSystem fileSystem = path.getFileSystem();
            this.cleanupDeletedFS(fileSystem);
        }
        return result;
    }

    public MetaIndexEngine getIndexEngine() {
        return this.indexEngine;
    }

    private static class NOPObserver
    implements Observer {
        private NOPObserver() {
        }

        public void information(String message) {
        }

        public void warning(String message) {
        }

        public void error(String message) {
        }
    }
}

