/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.ext.metadata.engine.BatchIndexListener;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.DisposedException;
import org.uberfire.ext.metadata.io.IndexableIOEvent;
import org.uberfire.ext.metadata.io.IndexerDispatcher;
import org.uberfire.ext.metadata.io.IndexersFactory;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttributeView;

public final class BatchIndex {
    private static final Logger LOG = LoggerFactory.getLogger(BatchIndex.class);
    private final MetaIndexEngine indexEngine;
    private final Class<? extends FileAttributeView>[] views;
    private final AtomicBoolean indexDisposed = new AtomicBoolean(false);
    private final Observer observer;
    private final ExecutorService executorService;
    private final IndexersFactory indexersFactory;
    private final IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory;
    private final BatchIndexListener batchIndexListener;

    @SafeVarargs
    public BatchIndex(MetaIndexEngine indexEngine, Observer observer, ExecutorService executorService, IndexersFactory indexersFactory, IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory, BatchIndexListener batchIndexListener, Class<? extends FileAttributeView> ... views) {
        this.indexersFactory = indexersFactory;
        this.dispatcherFactory = dispatcherFactory;
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.observer = (Observer)PortablePreconditions.checkNotNull((String)"observer", (Object)observer);
        this.views = views;
        this.batchIndexListener = batchIndexListener;
        this.executorService = executorService;
    }

    public void runAsync(final FileSystem fs) {
        if (fs != null && fs.getRootDirectories().iterator().hasNext()) {
            this.executorService.execute((Runnable)new DescriptiveRunnable(){

                public String getDescription() {
                    return "FS BatchIndex [" + ((FileSystemId)fs).id() + "]";
                }

                public void run() {
                    block2: {
                        final AtomicBoolean indexFinished = new AtomicBoolean(false);
                        BatchIndex.this.indexEngine.beforeDispose(new Runnable(){

                            @Override
                            public void run() {
                                BatchIndex.this.indexDisposed.set(true);
                                if (!indexFinished.get()) {
                                    fs.getRootDirectories().forEach(rootPath -> BatchIndex.this.indexEngine.delete(KObjectUtil.toKCluster(rootPath)));
                                }
                            }
                        });
                        try {
                            BatchIndex.this.run(fs, null);
                            indexFinished.set(true);
                        }
                        catch (Exception ex) {
                            if (BatchIndex.this.indexDisposed.get()) break block2;
                            BatchIndex.this.logError("FileSystem Index fails. [@" + fs.toString() + "]", ex);
                        }
                    }
                }
            });
        }
    }

    private boolean hasContent(Path dir) {
        try (DirectoryStream children = Files.newDirectoryStream((Path)dir, path -> !path.endsWith("readme.md"));){
            boolean bl = children.iterator().hasNext();
            return bl;
        }
    }

    public void run(FileSystem fs, Runnable callback) {
        if (fs == null) {
            return;
        }
        ArrayList<Runnable> exceptionCleanup = new ArrayList<Runnable>(1);
        for (Path rootPath : fs.getRootDirectories()) {
            KCluster cluster = KObjectUtil.toKCluster(rootPath);
            if (!this.indexEngine.freshIndex(cluster) || !this.hasContent(rootPath)) continue;
            this.indexEngine.prepareBatch(cluster);
            try {
                IndexerDispatcher dispatcher = this.dispatcherFactory.create(this.indexersFactory.getIndexers(), cluster);
                if (this.indexDisposed.get()) break;
                exceptionCleanup.add(() -> dispatcher.dispose());
                this.queueIndexingEvents(rootPath, dispatcher);
                if (!this.indexDisposed.get()) {
                    this.logInformation("Starting indexing of " + cluster.getClusterId() + " ...");
                    if (this.batchIndexListener != null) {
                        this.batchIndexListener.notifyIndexIngStarted(cluster, rootPath);
                    }
                    ((CompletableFuture)dispatcher.schedule(this.executorService).thenRun(() -> {
                        this.logInformation("Completed indexing of " + cluster.getClusterId());
                        if (this.batchIndexListener != null) {
                            this.batchIndexListener.notifyIndexIngFinished(cluster, rootPath);
                        }
                        if (callback != null) {
                            callback.run();
                        }
                    })).exceptionally(ex -> {
                        try {
                            throw ex;
                        }
                        catch (DisposedException de) {
                            this.logWarning("Batch index couldn't finish. [@" + cluster.getClusterId() + "]");
                        }
                        catch (IllegalStateException ise) {
                            this.logError("Index fails - Index has an invalid state. [@" + cluster.getClusterId() + "]", (Throwable)ex);
                        }
                        catch (Throwable t) {
                            this.logError("Index fails. [@" + cluster.getClusterId() + "]", (Throwable)ex);
                        }
                        return null;
                    });
                    continue;
                }
                this.logWarning("Batch index couldn't finish. [@" + cluster.getClusterId() + "]");
            }
            catch (Exception ex2) {
                if (this.indexDisposed.get()) {
                    this.logWarning("Batch index couldn't finish. [@" + cluster.getClusterId() + "]");
                    continue;
                }
                this.logError("Index fails. [@" + cluster.getClusterId() + "]", ex2);
                exceptionCleanup.forEach(action -> action.run());
            }
        }
    }

    private void queueIndexingEvents(final Path root, final IndexerDispatcher dispatcher) {
        Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)root)), (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                block6: {
                    if (BatchIndex.this.indexDisposed.get()) {
                        return FileVisitResult.TERMINATE;
                    }
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (file.getFileName().toString().startsWith(".")) break block6;
                        if (!BatchIndex.this.indexDisposed.get()) {
                            dispatcher.offer(new IndexableIOEvent.NewFileEvent(file));
                            break block6;
                        }
                        return FileVisitResult.TERMINATE;
                    }
                    catch (Exception ex) {
                        if (BatchIndex.this.indexDisposed.get()) {
                            BatchIndex.this.logWarning("Batch index couldn't finish. [@" + root.toUri().toString() + "]");
                            return FileVisitResult.TERMINATE;
                        }
                        BatchIndex.this.logError("Index fails. [@" + file.toString() + "]", ex);
                    }
                }
                if (BatchIndex.this.indexDisposed.get()) {
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void logInformation(String message) {
        this.observer.information(message);
        LOG.info(message);
    }

    private void logWarning(String message) {
        this.observer.warning(message);
        LOG.warn(message);
    }

    private void logError(String message, Throwable throwable) {
        this.observer.error(message);
        LOG.error(message, throwable);
    }

    public void dispose() {
        this.indexEngine.dispose();
    }
}

