/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file;

import java.net.URI;
import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystems;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.BaseSimpleFileSystem;

public class FileSystemsTest {
    @Test
    public void testGetDefault() {
        Assertions.assertThat((Object)FileSystems.getDefault()).isInstanceOf(BaseSimpleFileSystem.class);
    }

    @Test
    public void testGetFileSystemByURI() {
        Assertions.assertThat((Object)FileSystems.getFileSystem((URI)URI.create("default:///"))).isInstanceOf(BaseSimpleFileSystem.class);
        Assertions.assertThat((Object)FileSystems.getFileSystem((URI)URI.create("file:///"))).isInstanceOf(BaseSimpleFileSystem.class);
    }

    @Test
    public void getFileSystemNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystems.getFileSystem(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'uri' should be not null!");
    }

    @Test
    public void newFileSystemNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystems.newFileSystem(null, Collections.emptyMap())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'uri' should be not null!");
    }

    @Test
    public void newFileSystemNull2() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystems.newFileSystem((URI)URI.create("jgit:///test"), null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'env' should be not null!");
    }

    @Test
    public void newFileSystemNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystems.newFileSystem((URI)null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'uri' should be not null!");
    }

    @Test
    public void newFileSystemNull4() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystems.newFileSystem((Path)null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void newFileSystemNull5() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystems.newFileSystem((URI)URI.create("jgit:///test"), null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'env' should be not null!");
    }

    @Test
    public void newFileSystemNull6() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystems.newFileSystem(null, null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'uri' should be not null!");
    }
}

