/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file;

import java.net.URI;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;

public class FileSystemProvidersTest {
    @Test
    public void generalTests() {
        Assertions.assertThat((List)FileSystemProviders.installedProviders()).hasSize(1);
        Assertions.assertThat((Object)FileSystemProviders.getDefaultProvider()).isInstanceOf(SimpleFileSystemProvider.class);
        Assertions.assertThat((Object)FileSystemProviders.resolveProvider((URI)URI.create("default:///"))).isInstanceOf(SimpleFileSystemProvider.class);
        Assertions.assertThat((Object)FileSystemProviders.resolveProvider((URI)URI.create("file:///"))).isInstanceOf(SimpleFileSystemProvider.class);
    }

    @Test
    public void resolveProviderNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystemProviders.resolveProvider(null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Parameter named 'uri' should be not null!");
    }
}

