/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.io.FileUtils;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IterableAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.NotLinkException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;

public class SimpleFileSystemProviderTest {
    @Before
    @After
    public void cleanup() {
        new File(System.getProperty("user.dir") + "/temp").delete();
        new File(System.getProperty("user.dir") + "/temp2").delete();
        new File(System.getProperty("user.dir") + "/xxxxxx").delete();
    }

    @Test
    public void simpleStateTest() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        Assertions.assertThat((Object)fsProvider).isNotNull();
        Assertions.assertThat((String)fsProvider.getScheme()).isNotEmpty().isEqualTo((Object)"file");
        Assertions.assertThat((boolean)fsProvider.isDefault()).isFalse();
        fsProvider.forceAsDefault();
        Assertions.assertThat((boolean)fsProvider.isDefault()).isTrue();
    }

    @Test
    public void validateGetPath() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        URI uri = URI.create("file:///path/to/file.txt");
        Path path = fsProvider.getPath(uri);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((Object)path.getFileSystem()).isEqualTo((Object)fsProvider.getFileSystem(uri));
        Assertions.assertThat((Object)path.getFileSystem().provider()).isEqualTo((Object)fsProvider);
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/file.txt");
    }

    @Test(expected=IllegalArgumentException.class)
    public void getPathNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.getPath(null);
    }

    @Test(expected=IllegalStateException.class)
    public void getPathInvalidScheme() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.getPath(URI.create("http:///path/to/file.txt"));
    }

    @Test(expected=FileSystemAlreadyExistsException.class)
    public void newFileSystemCantCreateURI() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newFileSystem(URI.create("file:///"), new HashMap());
    }

    @Test(expected=FileSystemAlreadyExistsException.class)
    public void newFileSystemCantCreatePath() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        URI uri = URI.create("file:///");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(uri), (String)uri.getPath(), (boolean)false);
        fsProvider.newFileSystem((Path)path, new HashMap());
    }

    @Test
    public void checkNewInputStream() throws java.io.IOException {
        File temp = File.createTempFile("foo", "bar");
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)temp);
        InputStream stream = fsProvider.newInputStream((Path)path, new OpenOption[0]);
        Assertions.assertThat((InputStream)stream).isNotNull();
        stream.close();
    }

    @Test(expected=NoSuchFileException.class)
    public void inputStreamFileDoesntExists() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.newInputStream((Path)path, new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void inputStreamNull() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newInputStream(null, new OpenOption[0]);
    }

    @Test
    public void checkNewOutputStream() throws java.io.IOException {
        File temp = File.createTempFile("foo", "bar");
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)temp);
        OutputStream stream = fsProvider.newOutputStream((Path)path, new OpenOption[0]);
        Assertions.assertThat((Object)stream).isNotNull();
        stream.close();
    }

    @Test(expected=IOException.class)
    public void outputStreamFileDoesntExists() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.newOutputStream((Path)path, new OpenOption[0]);
    }

    @Test(expected=IOException.class)
    public void outputStreamOnDirectory() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/", (boolean)false);
        fsProvider.newOutputStream((Path)path, new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void outputStreamNull() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newOutputStream(null, new OpenOption[0]);
    }

    @Test
    public void checkNewFileChannel() throws java.io.IOException {
        File temp = File.createTempFile("foo", "bar");
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)temp);
        FileChannel stream = fsProvider.newFileChannel((Path)path, null, new FileAttribute[0]);
        Assertions.assertThat((Object)stream).isNotNull();
        stream.close();
    }

    @Test(expected=IOException.class)
    public void fileChannelFileDoesntExists() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.newFileChannel((Path)path, null, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void fileChannelNull() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newFileChannel(null, null, new FileAttribute[0]);
    }

    @Test
    public void checkNewByteChannelToCreateFile() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userBasedPath = System.getProperty("user.dir") + "/byte_some_file_here.txt";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userBasedPath, (boolean)false);
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
        SeekableByteChannel channel = fsProvider.newByteChannel((Path)path, null, new FileAttribute[0]);
        Assertions.assertThat((Object)channel).isNotNull();
        Assertions.assertThat((boolean)path.toFile().exists()).isTrue();
        path.toFile().delete();
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void newByteChannelFileAlreadyExists() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThat((boolean)path.toFile().exists()).isTrue();
        Assertions.assertThat((File)path.toFile()).isEqualTo((Object)tempFile);
        fsProvider.newByteChannel((Path)path, null, new FileAttribute[0]);
    }

    @Test(expected=IOException.class)
    public void newByteChannelInvalidPath() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userBasedPath = System.getProperty("user.dir") + "path/to/some_file_here.txt";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userBasedPath, (boolean)false);
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
        fsProvider.newByteChannel((Path)path, null, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newByteChannelNull() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newByteChannel(null, null, new FileAttribute[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void newAsynchronousFileChannelUnsupportedOp() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.newAsynchronousFileChannel((Path)path, null, null, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newAsynchronousFileChannelNull() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newAsynchronousFileChannel(null, null, null, new FileAttribute[0]);
    }

    @Test
    public void seekableByteChannel() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userBasedPath = System.getProperty("user.dir") + "/my_byte_some_file_here.txt";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userBasedPath, (boolean)false);
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
        SeekableByteChannel channel = fsProvider.newByteChannel((Path)path, null, new FileAttribute[0]);
        Assertions.assertThat((Object)channel).isNotNull();
        Assertions.assertThat((boolean)path.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)channel.isOpen()).isTrue();
        channel.close();
        Assertions.assertThat((boolean)channel.isOpen()).isFalse();
        path.toFile().delete();
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
    }

    @Test
    public void checkCreateDirectory() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userBasedPath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userBasedPath, (boolean)false);
        path.toFile().delete();
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
        fsProvider.createDirectory((Path)path, new FileAttribute[0]);
        Assertions.assertThat((boolean)path.toFile().exists()).isTrue();
        path.toFile().delete();
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void checkCreateDirectoryAlreadyExists() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userBasedPath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userBasedPath, (boolean)false);
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
        fsProvider.createDirectory((Path)path, new FileAttribute[0]);
        Assertions.assertThat((boolean)path.toFile().exists()).isTrue();
        fsProvider.createDirectory((Path)path, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createDirectoryNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.createDirectory(null, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createSymbolicLinkNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.createSymbolicLink(null, null, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createSymbolicLinkNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.createSymbolicLink((Path)path, null, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createSymbolicLinkNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.createSymbolicLink(null, (Path)path, new FileAttribute[0]);
    }

    @Test(expected=IllegalStateException.class)
    public void createSymbolicLinkSame() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.createSymbolicLink((Path)path, (Path)path, new FileAttribute[0]);
    }

    @Test(expected=IllegalStateException.class)
    public void createSymbolicLinkTargetMustExists() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file2.txt", (boolean)false);
        fsProvider.createSymbolicLink((Path)path, (Path)path2, new FileAttribute[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void createSymbolicLinkUnsupportedOp() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path2 = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.createSymbolicLink((Path)path, (Path)path2, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createLinkNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.createLink(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createLinkNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.createLink((Path)path, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createLinkNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.createLink(null, (Path)path);
    }

    @Test(expected=IllegalStateException.class)
    public void createLinkSame() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.createLink((Path)path, (Path)path);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void createLinkUnsupportedOp() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path2 = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.createLink((Path)path, (Path)path2);
    }

    @Test
    public void checkDelete() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThat((boolean)path.toFile().exists()).isTrue();
        fsProvider.delete((Path)path, new DeleteOption[0]);
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
    }

    @Test(expected=NoSuchFileException.class)
    public void checkDeleteNonExistent() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
        fsProvider.delete((Path)path, new DeleteOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkDeleteNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.delete(null, new DeleteOption[0]);
    }

    @Test
    public void checkDeleteIfExists() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThat((boolean)path.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)fsProvider.deleteIfExists((Path)path, new DeleteOption[0])).isTrue();
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
    }

    @Test
    public void checkDeleteIfExistsNonExistent() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
        Assertions.assertThat((boolean)fsProvider.deleteIfExists((Path)path, new DeleteOption[0])).isFalse();
        Assertions.assertThat((boolean)path.toFile().exists()).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkDeleteIfExistsNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.deleteIfExists(null, new DeleteOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readSymbolicLinkNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.readSymbolicLink(null);
    }

    @Test(expected=NotLinkException.class)
    public void readSymbolicLinkNotLink() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.readSymbolicLink((Path)path);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void readSymbolicLinkUnsupportedOp() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.readSymbolicLink((Path)path);
    }

    @Test
    public void checkIsSameFile() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((boolean)fsProvider.isSameFile((Path)path, (Path)path2)).isTrue();
        GeneralPathImpl path3 = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"path/to/file.txt", (boolean)false);
        Assertions.assertThat((boolean)fsProvider.isSameFile((Path)path, (Path)path3)).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void sameFileNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.isSameFile(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void sameFileNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.isSameFile((Path)path, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void sameFileNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.isSameFile(null, (Path)path);
    }

    @Test
    public void checkCopyDir() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp";
        String userDestPath = System.getProperty("user.dir") + "/temp2";
        GeneralPathImpl source = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        GeneralPathImpl dest = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userDestPath, (boolean)false);
        fsProvider.createDirectory((Path)source, new FileAttribute[0]);
        fsProvider.copy((Path)source, (Path)dest, new CopyOption[0]);
        Assertions.assertThat((boolean)dest.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)source.toFile().exists()).isTrue();
        source.toFile().delete();
        dest.toFile().delete();
    }

    @Test
    public void checkCopyFile() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp.txt";
        String userDestPath = System.getProperty("user.dir") + "/temp2.txt";
        GeneralPathImpl source = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        GeneralPathImpl dest = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userDestPath, (boolean)false);
        OutputStream stream = fsProvider.newOutputStream((Path)source, new OpenOption[0]);
        stream.write(97);
        stream.close();
        fsProvider.copy((Path)source, (Path)dest, new CopyOption[0]);
        Assertions.assertThat((boolean)dest.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)source.toFile().exists()).isTrue();
        Assertions.assertThat((long)dest.toFile().length()).isEqualTo(source.toFile().length());
        source.toFile().delete();
        dest.toFile().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void copyFileInvalidSourceAndTarget() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp";
        String userDestPath = System.getProperty("user.dir") + "/temp2";
        GeneralPathImpl source = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        GeneralPathImpl dest = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userDestPath, (boolean)false);
        fsProvider.createDirectory((Path)source, new FileAttribute[0]);
        GeneralPathImpl sourceFile = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)(userSourcePath + "/file.txt"), (boolean)false);
        OutputStream stream = fsProvider.newOutputStream((Path)sourceFile, new OpenOption[0]);
        stream.write(97);
        stream.close();
        try {
            fsProvider.copy((Path)source, (Path)dest, new CopyOption[0]);
            Assertions.fail((String)"source isn't empty");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sourceFile.toFile().delete();
        fsProvider.copy((Path)source, (Path)dest, new CopyOption[0]);
        try {
            fsProvider.copy((Path)source, (Path)dest, new CopyOption[0]);
            Assertions.fail((String)"dest already exists");
        }
        catch (Exception exception) {
            // empty catch block
        }
        dest.toFile().delete();
        source.toFile().delete();
        try {
            fsProvider.copy((Path)source, (Path)dest, new CopyOption[0]);
            Assertions.fail((String)"source doesn't exists");
        }
        catch (Exception exception) {}
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyFileNull1() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userPath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userPath, (boolean)false);
        fsProvider.copy((Path)path, null, new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyFileNull2() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userPath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userPath, (boolean)false);
        fsProvider.copy(null, (Path)path, new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyFileNull3() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.copy(null, null, new CopyOption[0]);
    }

    @Test
    public void checkMoveDir() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp";
        String userDestPath = System.getProperty("user.dir") + "/temp2";
        GeneralPathImpl source = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        GeneralPathImpl dest = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userDestPath, (boolean)false);
        fsProvider.createDirectory((Path)source, new FileAttribute[0]);
        fsProvider.move((Path)source, (Path)dest, new CopyOption[0]);
        Assertions.assertThat((boolean)source.toFile().exists()).isFalse();
        Assertions.assertThat((boolean)dest.toFile().exists()).isTrue();
        dest.toFile().delete();
    }

    @Test
    public void checkMoveFile() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp.txt";
        String userDestPath = System.getProperty("user.dir") + "/temp2.txt";
        GeneralPathImpl source = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        GeneralPathImpl dest = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userDestPath, (boolean)false);
        OutputStream stream = fsProvider.newOutputStream((Path)source, new OpenOption[0]);
        stream.write(97);
        stream.close();
        long lenght = source.toFile().length();
        fsProvider.move((Path)source, (Path)dest, new CopyOption[0]);
        Assertions.assertThat((boolean)dest.toFile().exists()).isTrue();
        Assertions.assertThat((boolean)source.toFile().exists()).isFalse();
        Assertions.assertThat((long)dest.toFile().length()).isEqualTo(lenght);
        dest.toFile().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void moveFileInvalidSourceAndTarget() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp";
        String userDestPath = System.getProperty("user.dir") + "/temp2";
        GeneralPathImpl source = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        GeneralPathImpl dest = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userDestPath, (boolean)false);
        fsProvider.createDirectory((Path)source, new FileAttribute[0]);
        GeneralPathImpl sourceFile = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)(userSourcePath + "/file.txt"), (boolean)false);
        OutputStream stream = fsProvider.newOutputStream((Path)sourceFile, new OpenOption[0]);
        stream.write(97);
        stream.close();
        try {
            fsProvider.move((Path)source, (Path)dest, new CopyOption[0]);
            Assertions.fail((String)"source isn't empty");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sourceFile.toFile().delete();
        fsProvider.copy((Path)source, (Path)dest, new CopyOption[0]);
        try {
            fsProvider.move((Path)source, (Path)dest, new CopyOption[0]);
            Assertions.fail((String)"dest already exists");
        }
        catch (Exception exception) {
            // empty catch block
        }
        dest.toFile().delete();
        source.toFile().delete();
        try {
            fsProvider.move((Path)source, (Path)dest, new CopyOption[0]);
            Assertions.fail((String)"source doesn't exists");
        }
        catch (Exception exception) {}
    }

    @Test(expected=IllegalArgumentException.class)
    public void moveFileNull1() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userPath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userPath, (boolean)false);
        fsProvider.move((Path)path, null, new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void moveFileNull2() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userPath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userPath, (boolean)false);
        fsProvider.move(null, (Path)path, new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void moveFileNull3() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.move(null, null, new CopyOption[0]);
    }

    @Test
    public void checkNewDirectoryStream() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl dir = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        FileUtils.deleteDirectory((File)dir.toFile());
        fsProvider.createDirectory((Path)dir, new FileAttribute[0]);
        DirectoryStream stream = fsProvider.newDirectoryStream((Path)dir, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return true;
            }
        });
        Assertions.assertThat((Iterable)stream).hasSize(0);
        try {
            stream.iterator().next();
            Assertions.fail((String)"can't navigate to next on empty iterator");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        File tempFile = File.createTempFile("foo", "bar", dir.toFile());
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        DirectoryStream stream2 = fsProvider.newDirectoryStream((Path)dir, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return true;
            }
        });
        Assertions.assertThat((Iterable)stream2).hasSize(1);
        Iterator iterator = stream2.iterator();
        iterator.next();
        try {
            iterator.remove();
            Assertions.fail((String)"can't remove elements");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        stream2.close();
        try {
            stream2.close();
            Assertions.fail((String)"stram already closed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        File tempFile2 = File.createTempFile("bar", "foo", dir.toFile());
        GeneralPathImpl path2 = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile2);
        DirectoryStream stream3 = fsProvider.newDirectoryStream((Path)dir, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return true;
            }
        });
        ((IterableAssert)Assertions.assertThat((Iterable)stream3).hasSize(2)).contains((Object[])new Path[]{path, path2});
        stream3.close();
        try {
            stream3.iterator().next();
            Assertions.fail((String)"can't interact in an already closed stream");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DirectoryStream stream4 = fsProvider.newDirectoryStream((Path)dir, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return entry.getFileName().toString().startsWith("foo");
            }
        });
        ((IterableAssert)Assertions.assertThat((Iterable)stream4).hasSize(1)).contains((Object[])new Path[]{path});
        FileUtils.deleteDirectory((File)dir.toFile());
    }

    @Test
    public void checkDeleteNonEmptyDir() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl dir = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        FileUtils.deleteDirectory((File)dir.toFile());
        fsProvider.createDirectory((Path)dir, new FileAttribute[0]);
        File.createTempFile("foo", "bar", dir.toFile());
        File.createTempFile("bar", "foo", dir.toFile());
        File.createTempFile("bar", "foo", dir.toFile());
        fsProvider.createDirectory(dir.resolve("other_dir"), new FileAttribute[0]);
        DirectoryStream stream5 = fsProvider.newDirectoryStream((Path)dir, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return true;
            }
        });
        ((IterableAssert)Assertions.assertThat((Iterable)stream5).hasSize(4)).contains((Object[])new Path[]{dir.resolve("other_dir")});
        try {
            fsProvider.delete((Path)dir, new DeleteOption[0]);
            Assertions.fail((String)"must throw error");
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            // empty catch block
        }
        fsProvider.delete((Path)dir, new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES});
        Assertions.assertThat((boolean)dir.toFile().exists()).isEqualTo(false);
    }

    @Test(expected=NotDirectoryException.class)
    public void newDirectoryStreamInvalidDir() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/xxxxxx";
        GeneralPathImpl dir = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        fsProvider.newDirectoryStream((Path)dir, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return true;
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull1() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newDirectoryStream(null, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return true;
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull2() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/xxxxxx";
        GeneralPathImpl dir = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        fsProvider.newDirectoryStream((Path)dir, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull3() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/xxxxxx";
        GeneralPathImpl dir = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        fsProvider.newDirectoryStream(null, null);
    }
}

