/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.kie.soup.commons.validation.Preconditions;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.BaseSimpleFileStore;

public class SimpleWindowsFileStore
extends BaseSimpleFileStore {
    private static final Set<String> EXCLUDED_DRIVERS = new HashSet<String>(){
        {
            this.add("A");
            this.add("B");
        }
    };
    private final File[] roots;
    private int fstoreIndex = -1;

    public SimpleWindowsFileStore(File[] roots, FileSystem fs, String path) {
        this(roots, (Path)GeneralPathImpl.create((FileSystem)fs, (String)path, (boolean)false));
    }

    SimpleWindowsFileStore(File[] roots, Path path) {
        super(roots, path);
        Preconditions.checkNotNull((String)"roots", (Object)roots);
        Preconditions.checkCondition((String)"should have at least one root", (roots.length > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((String)"path", (Object)path);
        this.roots = roots;
        if (path.isAbsolute()) {
            for (int i = 0; i < this.listRoots().length; ++i) {
                if (!this.listRoots()[i].toString().equals(path.getRoot().toString())) continue;
                this.fstoreIndex = i;
                break;
            }
        } else {
            for (int i = 0; i < this.listRoots().length; ++i) {
                if (EXCLUDED_DRIVERS.contains(this.listRoots()[i].toString().substring(0, 1).toUpperCase())) continue;
                this.fstoreIndex = i;
                break;
            }
        }
        if (this.fstoreIndex == -1) {
            throw new IllegalStateException();
        }
    }

    public String name() {
        return this.listRoots()[this.fstoreIndex].getName();
    }

    public long getTotalSpace() throws IOException {
        return this.listRoots()[this.fstoreIndex].getTotalSpace();
    }

    public long getUsableSpace() throws IOException {
        return this.listRoots()[this.fstoreIndex].getUsableSpace();
    }

    public long getUnallocatedSpace() throws IOException {
        throw new UnsupportedOperationException();
    }

    File[] listRoots() {
        return this.roots;
    }
}

