/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.IterableAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;
import org.uberfire.java.nio.fs.file.SimpleUnixFileSystem;

public class SimpleUnixFileSystemTest {
    final FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);

    @Test
    public void simpleTests() {
        SimpleUnixFileSystem fileSystem = new SimpleUnixFileSystem(this.fsProvider, "/");
        AssertionsForClassTypes.assertThat((boolean)fileSystem.isOpen()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        AssertionsForClassTypes.assertThat((String)fileSystem.getSeparator()).isEqualTo((Object)System.getProperty("file.separator"));
        AssertionsForClassTypes.assertThat((Object)fileSystem.provider()).isEqualTo((Object)this.fsProvider);
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.supportedFileAttributeViews()).hasSize(1)).contains((Object[])new String[]{"basic"});
        AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("/path/to/file.txt", new String[0])).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/path/to/file.txt", (boolean)false));
        AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("/path/to/file.txt", null)).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/path/to/file.txt", (boolean)false));
        AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("/path", new String[]{"to", "file.txt"})).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/path/to/file.txt", (boolean)false));
        AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("/", new String[]{"path", "to", "file.txt"})).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/path/to/file.txt", (boolean)false));
        Assertions.assertThatThrownBy(() -> SimpleUnixFileSystemTest.lambda$simpleTests$0((FileSystem)fileSystem)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThat((Iterable)fileSystem.getFileStores()).hasSize(1);
        AssertionsForClassTypes.assertThat((String)((FileStore)fileSystem.getFileStores().iterator().next()).name()).isEqualTo((Object)"/");
        Assertions.assertThat((Iterable)fileSystem.getRootDirectories()).hasSize(1);
        AssertionsForClassTypes.assertThat((String)((Path)fileSystem.getRootDirectories().iterator().next()).toString()).isEqualTo((Object)"/");
        AssertionsForClassTypes.assertThat((boolean)((Path)fileSystem.getRootDirectories().iterator().next()).isAbsolute()).isTrue();
    }

    @Test
    public void simpleRootTests() throws URISyntaxException {
        SimpleFileSystemProvider fs = new SimpleFileSystemProvider();
        SimpleUnixFileSystem fileSystem = new SimpleUnixFileSystem(this.fsProvider, "/");
        AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("/", new String[0])).isEqualTo((Object)fileSystem.getPath("/path", new String[0]).getParent());
        URL parentUrl = this.getClass().getResource("/");
        Path parentNioPath = fs.getPath(parentUrl.toURI());
        URL childUrl = this.getClass().getResource("/Folder");
        Path childNioPath = fs.getPath(childUrl.toURI());
        Path childParentNioPath = childNioPath.getParent();
        AssertionsForClassTypes.assertThat((Object)parentNioPath).isEqualTo((Object)childParentNioPath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidCOnstructorPath() {
        new SimpleUnixFileSystem(this.fsProvider, "home");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getPathMatcherUnsupportedOp() {
        new SimpleUnixFileSystem(this.fsProvider, "/").getPathMatcher("*.*");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getUserPrincipalLookupServiceUnsupportedOp() {
        new SimpleUnixFileSystem(this.fsProvider, "/").getUserPrincipalLookupService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void newWatchServiceUnsupportedOp() {
        new SimpleUnixFileSystem(this.fsProvider, "/").newWatchService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeElementFromRootIteratorUnsupportedOp() {
        new SimpleUnixFileSystem(this.fsProvider, "/").getRootDirectories().iterator().remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void invalidElementFromRootIterator() {
        Iterator iterator = new SimpleUnixFileSystem(this.fsProvider, "/").getRootDirectories().iterator();
        try {
            iterator.next();
        }
        catch (Exception e) {
            Assertions.fail((String)"first is valid");
        }
        iterator.next();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeElementFromFStoreIteratorUnsupportedOp() {
        new SimpleUnixFileSystem(this.fsProvider, "/").getFileStores().iterator().remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void invalidElementFromFStoreIterator() {
        Iterator iterator = new SimpleUnixFileSystem(this.fsProvider, "/").getFileStores().iterator();
        try {
            iterator.next();
        }
        catch (Exception e) {
            Assertions.fail((String)"first is valid");
        }
        iterator.next();
    }

    private static /* synthetic */ void lambda$simpleTests$0(FileSystem fileSystem) throws Throwable {
        fileSystem.close();
    }
}

