/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.io.File;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.attribute.FileStoreAttributeView;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;
import org.uberfire.java.nio.fs.file.SimpleWindowsFileStore;
import org.uberfire.java.nio.fs.file.SimpleWindowsFileSystem;

public class SimpleWindowsFileStoreTest {
    final FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
    final File[] roots = new File[]{new File("c:\\"), new File("a:\\")};
    final FileSystem fileSystem = new SimpleWindowsFileSystem(this.roots, this.fsProvider, "c:\\");
    final Path nonNullPath = GeneralPathImpl.create((FileSystem)this.fileSystem, (String)"c:\\something", (boolean)false);

    @Test
    public void simpleTests() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fileSystem, (String)"something", (boolean)false);
        SimpleWindowsFileStore fileStore = new SimpleWindowsFileStore(this.roots, (Path)path);
        ((StringAssert)Assertions.assertThat((String)fileStore.name()).isNotNull()).isEqualTo((Object)"c:\\");
        Assertions.assertThat((String)fileStore.type()).isNull();
        Assertions.assertThat((boolean)fileStore.isReadOnly()).isFalse();
        if (SimpleFileSystemProvider.OSType.currentOS().equals((Object)SimpleFileSystemProvider.OSType.WINDOWS)) {
            Assertions.assertThat((long)fileStore.getTotalSpace()).isNotEqualTo(0L);
            Assertions.assertThat((long)fileStore.getUsableSpace()).isNotEqualTo(0L);
        } else {
            Assertions.assertThat((long)fileStore.getTotalSpace()).isEqualTo(0L);
            Assertions.assertThat((long)fileStore.getUsableSpace()).isEqualTo(0L);
        }
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView(BasicFileAttributeView.class)).isTrue();
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView(MyFileAttributeView.class)).isFalse();
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView(MyAlsoInvalidFileAttributeView.class)).isFalse();
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView("basic")).isTrue();
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView("any")).isFalse();
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView(BasicFileAttributeView.class.getName())).isFalse();
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView(MyAlsoInvalidFileAttributeView.class.getName())).isFalse();
        Assertions.assertThat((Object)fileStore.getFileStoreAttributeView(FileStoreAttributeView.class)).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)fileStore.getAttribute("name")).isNotNull()).isEqualTo((Object)fileStore.name());
        ((ObjectAssert)Assertions.assertThat((Object)fileStore.getAttribute("totalSpace")).isNotNull()).isEqualTo((Object)fileStore.getTotalSpace());
        ((ObjectAssert)Assertions.assertThat((Object)fileStore.getAttribute("usableSpace")).isNotNull()).isEqualTo((Object)fileStore.getUsableSpace());
        ((ObjectAssert)Assertions.assertThat((Object)fileStore.getAttribute("readOnly")).isNotNull()).isEqualTo((Object)fileStore.isReadOnly());
    }

    @Test(expected=IllegalArgumentException.class)
    public void contructorWithNullRootsAndPath() {
        new SimpleWindowsFileStore((File[])null, (Path)null);
    }

    @Test(expected=IllegalStateException.class)
    public void contructorWithEmptyRoots() {
        new SimpleWindowsFileStore(new File[0], null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getUnallocatedSpaceUnsupportedOp() {
        new SimpleWindowsFileStore(this.roots, this.nonNullPath).getUnallocatedSpace();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getAttributeUnsupportedOp() {
        new SimpleWindowsFileStore(this.roots, this.nonNullPath).getAttribute("someValueHere");
    }

    @Test(expected=IllegalArgumentException.class)
    public void supportsFileAttributeViewNull1() {
        new SimpleWindowsFileStore(this.roots, this.nonNullPath).supportsFileAttributeView((Class)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void supportsFileAttributeViewNull2() {
        new SimpleWindowsFileStore(this.roots, this.nonNullPath).supportsFileAttributeView((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void supportsFileAttributeViewEmpty() {
        new SimpleWindowsFileStore(this.roots, this.nonNullPath).supportsFileAttributeView("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFileStoreAttributeViewNull() {
        new SimpleWindowsFileStore(this.roots, this.nonNullPath).getFileStoreAttributeView(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAttributeNull() {
        new SimpleWindowsFileStore(this.roots, this.nonNullPath).getAttribute(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAttributeEmpty() {
        new SimpleWindowsFileStore(this.roots, this.nonNullPath).getAttribute("");
    }

    private static class MyAlsoInvalidFileAttributeView
    implements BasicFileAttributeView {
        private MyAlsoInvalidFileAttributeView() {
        }

        public BasicFileAttributes readAttributes() throws IOException {
            return null;
        }

        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        }

        public String name() {
            return null;
        }
    }

    private static class MyFileAttributeView
    implements FileAttributeView {
        private MyFileAttributeView() {
        }

        public String name() {
            return null;
        }
    }
}

