/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.junit.Test;
import org.uberfire.java.nio.base.BasicFileAttributesImpl;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.base.NotImplementedException;
import org.uberfire.java.nio.file.AccessDeniedException;
import org.uberfire.java.nio.file.AccessMode;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;

public class SimpleFileSystemProviderAttrsRelatedTest {
    @Test
    public void checkIsHidden() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((boolean)fsProvider.isHidden((Path)path)).isFalse();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path2 = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThat((boolean)fsProvider.isHidden((Path)path2)).isEqualTo(tempFile.isHidden());
    }

    @Test
    public void isHiddenNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fsProvider.isHidden(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void checkAccess() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$checkAccess$1(fsProvider, (Path)path)).isInstanceOf(NoSuchFileException.class);
        Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$checkAccess$2(fsProvider, (Path)path)).isInstanceOf(NoSuchFileException.class);
        Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$checkAccess$3(fsProvider, (Path)path)).isInstanceOf(NoSuchFileException.class);
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path2 = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.checkAccess((Path)path2, new AccessMode[]{AccessMode.WRITE});
        Assertions.assertThat((boolean)tempFile.setWritable(false)).isTrue();
        Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$checkAccess$4(fsProvider, (Path)path2)).isInstanceOf(AccessDeniedException.class);
        Assertions.assertThat((boolean)tempFile.setWritable(true)).isTrue();
        fsProvider.checkAccess((Path)path2, new AccessMode[]{AccessMode.READ});
        Assertions.assertThat((boolean)tempFile.setReadable(false)).isTrue();
        if (SimpleFileSystemProvider.OSType.currentOS().equals((Object)SimpleFileSystemProvider.OSType.UNIX_LIKE)) {
            Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$checkAccess$5(fsProvider, (Path)path2)).isInstanceOf(AccessDeniedException.class);
        }
        Assertions.assertThat((boolean)tempFile.setReadable(true)).isTrue();
        if (SimpleFileSystemProvider.OSType.currentOS().equals((Object)SimpleFileSystemProvider.OSType.UNIX_LIKE)) {
            Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$checkAccess$6(fsProvider, (Path)path2)).isInstanceOf(AccessDeniedException.class);
        }
        Assertions.assertThat((boolean)tempFile.setExecutable(true)).isTrue();
        fsProvider.checkAccess((Path)path2, new AccessMode[]{AccessMode.EXECUTE});
        fsProvider.checkAccess((Path)path2, new AccessMode[]{AccessMode.READ, AccessMode.WRITE, AccessMode.EXECUTE});
    }

    @Test
    public void checkAccessNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fsProvider.checkAccess(null, new AccessMode[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void checkAccessNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$checkAccessNull2$8(fsProvider, (Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'modes' should be not null!");
    }

    @Test
    public void checkAccessNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fsProvider.checkAccess(null, new AccessMode[]{AccessMode.READ})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void checkAccessNull4() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$checkAccessNull4$10(fsProvider, (Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'mode' should be not null!");
    }

    @Test
    public void checkGetFileStore() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((Object)fsProvider.getFileStore((Path)path)).isNotNull();
        ((IterableAssert)Assertions.assertThat((Iterable)fsProvider.getFileSystem(path.toUri()).getFileStores()).isNotNull()).contains((Object[])new FileStore[]{fsProvider.getFileStore((Path)path)});
    }

    @Test
    public void getFileStoreNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fsProvider.getFileStore(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void checkGetFileAttributeViewGeneral() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        BasicFileAttributeView view = (BasicFileAttributeView)fsProvider.getFileAttributeView((Path)path, BasicFileAttributeView.class, new LinkOption[0]);
        Assertions.assertThat((Object)view).isNotNull();
        Assertions.assertThat((Object)view.readAttributes()).isNotNull();
        Assertions.assertThat((boolean)view.readAttributes().isRegularFile()).isTrue();
        Assertions.assertThat((boolean)view.readAttributes().isDirectory()).isFalse();
        Assertions.assertThat((boolean)view.readAttributes().isSymbolicLink()).isFalse();
        Assertions.assertThat((boolean)view.readAttributes().isOther()).isFalse();
        Assertions.assertThat((long)view.readAttributes().size()).isEqualTo(0L);
    }

    @Test
    public void checkGetFileAttributeViewBasic() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        BasicFileAttributeView view = (BasicFileAttributeView)fsProvider.getFileAttributeView((Path)path, BasicFileAttributeView.class, new LinkOption[0]);
        Assertions.assertThat((Object)view).isNotNull();
        Assertions.assertThat((Object)view.readAttributes()).isNotNull();
        Assertions.assertThat((boolean)view.readAttributes().isRegularFile()).isTrue();
        Assertions.assertThat((boolean)view.readAttributes().isDirectory()).isFalse();
        Assertions.assertThat((boolean)view.readAttributes().isSymbolicLink()).isFalse();
        Assertions.assertThat((boolean)view.readAttributes().isOther()).isFalse();
        Assertions.assertThat((long)view.readAttributes().size()).isEqualTo(0L);
    }

    @Test
    public void getFileAttributeViewInvalidView() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThat((Object)fsProvider.getFileAttributeView((Path)path, MyAttrsView.class, new LinkOption[0])).isNull();
    }

    @Test
    public void getFileAttributeViewNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            MyAttrsView cfr_ignored_0 = (MyAttrsView)fsProvider.getFileAttributeView(null, MyAttrsView.class, new LinkOption[0]);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void getFileAttributeViewNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$getFileAttributeViewNull2$13(fsProvider, (Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'type' should be not null!");
    }

    @Test
    public void getFileAttributeViewNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fsProvider.getFileAttributeView(null, null, new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void checkReadAttributesGeneral() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        BasicFileAttributesImpl attrs = (BasicFileAttributesImpl)fsProvider.readAttributes((Path)path, BasicFileAttributesImpl.class, new LinkOption[0]);
        Assertions.assertThat((Object)attrs).isNotNull();
        Assertions.assertThat((boolean)attrs.isRegularFile()).isTrue();
        Assertions.assertThat((boolean)attrs.isDirectory()).isFalse();
        Assertions.assertThat((boolean)attrs.isSymbolicLink()).isFalse();
        Assertions.assertThat((boolean)attrs.isOther()).isFalse();
        Assertions.assertThat((long)attrs.size()).isEqualTo(0L);
    }

    @Test
    public void checkReadAttributesBasic() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        BasicFileAttributes attrs = fsProvider.readAttributes((Path)path, BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertThat((Object)attrs).isNotNull();
        Assertions.assertThat((boolean)attrs.isRegularFile()).isTrue();
        Assertions.assertThat((boolean)attrs.isDirectory()).isFalse();
        Assertions.assertThat((boolean)attrs.isSymbolicLink()).isFalse();
        Assertions.assertThat((boolean)attrs.isOther()).isFalse();
        Assertions.assertThat((long)attrs.size()).isEqualTo(0L);
    }

    @Test
    public void readAttributesNonExistentFile() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$readAttributesNonExistentFile$15(fsProvider, (Path)path)).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void readAttributesInvalid() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThat((Object)fsProvider.readAttributes((Path)path, MyAttrs.class, new LinkOption[0])).isNull();
    }

    @Test
    public void readAttributesNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            MyAttrs cfr_ignored_0 = (MyAttrs)fsProvider.readAttributes(null, MyAttrs.class, new LinkOption[0]);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void readAttributesNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$readAttributesNull2$17(fsProvider, (Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'type' should be not null!");
    }

    @Test
    public void readAttributesNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            MyAttrs cfr_ignored_0 = (MyAttrs)fsProvider.readAttributes(null, (Class)null, new LinkOption[0]);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void checkReadAttributesMap() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "*", new LinkOption[0])).isNotNull()).hasSize(9);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "basic:*", new LinkOption[0])).isNotNull()).hasSize(9);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "basic:isRegularFile", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "basic:isRegularFile,isDirectory", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "basic:isRegularFile,isDirectory,someThing", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "basic:someThing", new LinkOption[0])).isNotNull()).hasSize(0);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "isRegularFile", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "isRegularFile,isDirectory", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "isRegularFile,isDirectory,someThing", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "someThing", new LinkOption[0])).isNotNull()).hasSize(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$checkReadAttributesMap$19(fsProvider, (Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage(":someThing");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$checkReadAttributesMap$20(fsProvider, (Path)path)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("View 'advanced' not available");
    }

    @Test
    public void readAttributesMapNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fsProvider.readAttributes(null, "*", new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void readAttributesMapNull2() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$readAttributesMapNull2$22(fsProvider, (Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'attributes' should be filled!");
    }

    @Test
    public void readAttributesMapNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fsProvider.readAttributes(null, (String)null, new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void readAttributesMapEmpty() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$readAttributesMapEmpty$24(fsProvider, (Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'attributes' should be filled!");
    }

    @Test
    public void setAttributeNull1() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$setAttributeNull1$25(fsProvider, (Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'attributes' should be filled!");
    }

    @Test
    public void setAttributeNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fsProvider.setAttribute(null, "some", null, new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void setAttributeNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fsProvider.setAttribute(null, null, null, new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void setAttributeEmpty() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$setAttributeEmpty$28(fsProvider, (Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'attributes' should be filled!");
    }

    @Test
    public void setAttributeInvalidAttr() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$setAttributeInvalidAttr$29(fsProvider, (Path)path)).isInstanceOf(IllegalStateException.class)).hasMessage("Condition 'invalid attribute' is invalid!");
    }

    @Test
    public void setAttributeInvalidView() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$setAttributeInvalidView$30(fsProvider, (Path)path)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("View 'advanced' not available");
    }

    @Test
    public void setAttributeInvalidView2() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$setAttributeInvalidView2$31(fsProvider, (Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage(":isRegularFile");
    }

    @Test
    public void setAttributeNotImpl() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderAttrsRelatedTest.lambda$setAttributeNotImpl$32(fsProvider, (Path)path)).isInstanceOf(NotImplementedException.class);
    }

    private static /* synthetic */ void lambda$setAttributeNotImpl$32(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.setAttribute(path, "isRegularFile", null, new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$setAttributeInvalidView2$31(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.setAttribute(path, ":isRegularFile", null, new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$setAttributeInvalidView$30(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.setAttribute(path, "advanced:isRegularFile", null, new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$setAttributeInvalidAttr$29(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.setAttribute(path, "myattr", null, new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$setAttributeEmpty$28(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.setAttribute(path, "", null, new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$setAttributeNull1$25(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.setAttribute(path, null, null, new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$readAttributesMapEmpty$24(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.readAttributes(path, "", new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$readAttributesMapNull2$22(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.readAttributes(path, (String)null, new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$checkReadAttributesMap$20(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.readAttributes(path, "advanced:isRegularFile", new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$checkReadAttributesMap$19(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.readAttributes(path, ":someThing", new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$readAttributesNull2$17(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        MyAttrs cfr_ignored_0 = (MyAttrs)fsProvider.readAttributes(path, (Class)null, new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$readAttributesNonExistentFile$15(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$getFileAttributeViewNull2$13(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.getFileAttributeView(path, null, new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$checkAccessNull4$10(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.checkAccess(path, new AccessMode[]{null, AccessMode.READ});
    }

    private static /* synthetic */ void lambda$checkAccessNull2$8(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.checkAccess(path, null);
    }

    private static /* synthetic */ void lambda$checkAccess$6(SimpleFileSystemProvider fsProvider, Path path2) throws Throwable {
        fsProvider.checkAccess(path2, new AccessMode[]{AccessMode.EXECUTE});
    }

    private static /* synthetic */ void lambda$checkAccess$5(SimpleFileSystemProvider fsProvider, Path path2) throws Throwable {
        fsProvider.checkAccess(path2, new AccessMode[]{AccessMode.READ});
    }

    private static /* synthetic */ void lambda$checkAccess$4(SimpleFileSystemProvider fsProvider, Path path2) throws Throwable {
        fsProvider.checkAccess(path2, new AccessMode[]{AccessMode.WRITE});
    }

    private static /* synthetic */ void lambda$checkAccess$3(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.checkAccess(path, new AccessMode[]{AccessMode.EXECUTE});
    }

    private static /* synthetic */ void lambda$checkAccess$2(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.checkAccess(path, new AccessMode[]{AccessMode.READ});
    }

    private static /* synthetic */ void lambda$checkAccess$1(SimpleFileSystemProvider fsProvider, Path path) throws Throwable {
        fsProvider.checkAccess(path, new AccessMode[]{AccessMode.WRITE});
    }

    private static interface MyAttrs
    extends BasicFileAttributes {
    }

    private static interface MyAttrsView
    extends BasicFileAttributeView {
    }
}

