/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.file.SimpleWindowsFileSystem;

public class SimpleWindowsFileSystemTest {
    final FileSystemProvider fsProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
    final File[] roots = new File[]{new File("c:\\"), new File("a:\\")};
    final File[] singleRoot = new File[]{new File("c:\\")};

    @Test
    public void simpleTests() {
        SimpleWindowsFileSystem fileSystem = new SimpleWindowsFileSystem(this.roots, this.fsProvider, "c:\\");
        AssertionsForClassTypes.assertThat((boolean)fileSystem.isOpen()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)fileSystem.isReadOnly()).isFalse();
        AssertionsForClassTypes.assertThat((String)fileSystem.getSeparator()).isEqualTo("\\");
        AssertionsForClassTypes.assertThat((Object)fileSystem.provider()).isEqualTo((Object)this.fsProvider);
        ((IterableAssert)Assertions.assertThat((Iterable)fileSystem.supportedFileAttributeViews()).hasSize(1)).contains((Object[])new String[]{"basic"});
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("c:\\path\\to\\file.txt", new String[0])).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"c:\\path\\to\\file.txt", (boolean)false));
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("/c:/path/to/file.txt", new String[0])).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/c:/path/to/file.txt", (boolean)false));
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("c:\\path\\to\\", new String[0])).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"c:\\path\\to", (boolean)false));
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("/c:/path/to/", new String[0])).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/c:/path/to", (boolean)false));
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("c:\\path\\to\\file.txt", null)).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"c:\\path\\to\\file.txt", (boolean)false));
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("c:\\path", new String[]{"to", "file.txt"})).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"c:\\path\\to\\file.txt", (boolean)false));
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("c:\\path\\", new String[]{"to", "file.txt"})).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"c:\\path\\to\\file.txt", (boolean)false));
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("/c:/path", new String[]{"to", "file.txt"})).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/c:/path/to/file.txt", (boolean)false));
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("/c:/path/", new String[]{"to", "file.txt"})).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/c:/path/to/file.txt", (boolean)false));
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)fileSystem.getPath("/", new String[]{"c:", "path"})).isNotNull()).isEqualTo((Object)GeneralPathImpl.create((FileSystem)fileSystem, (String)"/c:/path", (boolean)false));
        Assertions.assertThatThrownBy(() -> SimpleWindowsFileSystemTest.lambda$simpleTests$0((FileSystem)fileSystem)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThat((Iterable)fileSystem.getFileStores()).hasSize(2);
        AssertionsForClassTypes.assertThat((String)((FileStore)fileSystem.getFileStores().iterator().next()).name()).isEqualTo("c:\\");
        Assertions.assertThat((Iterable)fileSystem.getRootDirectories()).hasSize(2);
        AssertionsForClassTypes.assertThat((String)((Path)fileSystem.getRootDirectories().iterator().next()).toString()).isEqualTo("c:\\");
        AssertionsForClassTypes.assertThat((boolean)((Path)fileSystem.getRootDirectories().iterator().next()).isAbsolute()).isTrue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidCOnstructorPath() {
        new SimpleWindowsFileSystem(this.fsProvider, "home");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getPathMatcherUnsupportedOp() {
        new SimpleWindowsFileSystem(this.fsProvider, "c:\\").getPathMatcher("*.*");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getUserPrincipalLookupServiceUnsupportedOp() {
        new SimpleWindowsFileSystem(this.fsProvider, "c:\\").getUserPrincipalLookupService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void newWatchServiceUnsupportedOp() {
        new SimpleWindowsFileSystem(this.fsProvider, "c:\\").newWatchService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeElementFromRootIteratorUnsupportedOp() {
        new SimpleWindowsFileSystem(this.fsProvider, "c:\\").getRootDirectories().iterator().remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void invalidElementFromRootIterator() {
        Iterator iterator = new SimpleWindowsFileSystem(this.singleRoot, this.fsProvider, "c:\\").getRootDirectories().iterator();
        try {
            iterator.next();
        }
        catch (Exception e) {
            Assertions.fail((String)"first is valid");
        }
        iterator.next();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeElementFromFStoreIteratorUnsupportedOp() {
        new SimpleWindowsFileSystem(this.fsProvider, "c:\\").getFileStores().iterator().remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void invalidElementFromFStoreIterator() {
        Iterator iterator = new SimpleWindowsFileSystem(this.singleRoot, this.fsProvider, "c:\\").getFileStores().iterator();
        try {
            iterator.next();
        }
        catch (Exception e) {
            Assertions.fail((String)"first is valid");
        }
        iterator.next();
    }

    private static /* synthetic */ void lambda$simpleTests$0(FileSystem fileSystem) throws Throwable {
        fileSystem.close();
    }
}

