/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.IterableAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.NotLinkException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;

public class SimpleFileSystemProviderTest {
    @Before
    @After
    public void cleanup() {
        FileUtils.deleteQuietly((File)new File(System.getProperty("user.dir") + "/temp"));
        FileUtils.deleteQuietly((File)new File(System.getProperty("user.dir") + "/temp2"));
        FileUtils.deleteQuietly((File)new File(System.getProperty("user.dir") + "/xxxxxx"));
    }

    @Test
    public void simpleStateTest() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        Assertions.assertThat((Object)fsProvider).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)fsProvider.getScheme()).isNotEmpty()).isEqualTo("file");
        Assertions.assertThat((boolean)fsProvider.isDefault()).isFalse();
        fsProvider.forceAsDefault();
        Assertions.assertThat((boolean)fsProvider.isDefault()).isTrue();
    }

    @Test
    public void validateGetPath() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        URI uri = URI.create("file:///path/to/file.txt");
        Path path = fsProvider.getPath(uri);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((Object)path.getFileSystem()).isEqualTo((Object)fsProvider.getFileSystem(uri));
        Assertions.assertThat((Object)path.getFileSystem().provider()).isEqualTo((Object)fsProvider);
        Assertions.assertThat((String)path.toString()).isEqualTo("/path/to/file.txt");
    }

    @Test(expected=IllegalArgumentException.class)
    public void getPathNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.getPath(null);
    }

    @Test(expected=IllegalStateException.class)
    public void getPathInvalidScheme() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.getPath(URI.create("http:///path/to/file.txt"));
    }

    @Test(expected=FileSystemAlreadyExistsException.class)
    public void newFileSystemCantCreateURI() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newFileSystem(URI.create("file:///"), Collections.emptyMap());
    }

    @Test(expected=FileSystemAlreadyExistsException.class)
    public void newFileSystemCantCreatePath() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        URI uri = URI.create("file:///");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(uri), (String)uri.getPath(), (boolean)false);
        fsProvider.newFileSystem((Path)path, Collections.emptyMap());
    }

    @Test
    public void checkNewInputStream() throws java.io.IOException {
        File temp = File.createTempFile("foo", "bar");
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)temp);
        InputStream stream = fsProvider.newInputStream((Path)path, new OpenOption[0]);
        Assertions.assertThat((InputStream)stream).isNotNull();
        stream.close();
    }

    @Test(expected=NoSuchFileException.class)
    public void inputStreamFileDoesntExists() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.newInputStream((Path)path, new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void inputStreamNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newInputStream(null, new OpenOption[0]);
    }

    @Test
    public void checkNewOutputStream() throws java.io.IOException {
        File temp = File.createTempFile("foo", "bar");
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)temp);
        OutputStream stream = fsProvider.newOutputStream((Path)path, new OpenOption[0]);
        Assertions.assertThat((Object)stream).isNotNull();
        stream.close();
    }

    @Test(expected=IOException.class)
    public void outputStreamFileDoesntExists() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.newOutputStream((Path)path, new OpenOption[0]);
    }

    @Test(expected=IOException.class)
    public void outputStreamOnDirectory() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/", (boolean)false);
        fsProvider.newOutputStream((Path)path, new OpenOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void outputStreamNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newOutputStream(null, new OpenOption[0]);
    }

    @Test
    public void checkNewFileChannel() throws java.io.IOException {
        File temp = File.createTempFile("foo", "bar");
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)temp);
        FileChannel stream = fsProvider.newFileChannel((Path)path, null, new FileAttribute[0]);
        Assertions.assertThat((Object)stream).isNotNull();
        stream.close();
    }

    @Test(expected=IOException.class)
    public void fileChannelFileDoesntExists() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.newFileChannel((Path)path, null, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void fileChannelNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newFileChannel(null, null, new FileAttribute[0]);
    }

    @Test
    public void checkNewByteChannelToCreateFile() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userBasedPath = System.getProperty("user.dir") + "/byte_some_file_here.txt";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userBasedPath, (boolean)false);
        Assertions.assertThat((File)path.toFile()).doesNotExist();
        try (SeekableByteChannel channel = fsProvider.newByteChannel((Path)path, null, new FileAttribute[0]);){
            Assertions.assertThat((Object)channel).isNotNull();
            Assertions.assertThat((File)path.toFile()).exists();
        }
        path.toFile().delete();
        Assertions.assertThat((File)path.toFile()).doesNotExist();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void newByteChannelFileAlreadyExists() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThat((File)path.toFile()).exists();
        Assertions.assertThat((File)path.toFile()).isEqualTo((Object)tempFile);
        fsProvider.newByteChannel((Path)path, null, new FileAttribute[0]);
    }

    @Test(expected=IOException.class)
    public void newByteChannelInvalidPath() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userBasedPath = System.getProperty("user.dir") + "path/to/some_file_here.txt";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userBasedPath, (boolean)false);
        Assertions.assertThat((File)path.toFile()).doesNotExist();
        fsProvider.newByteChannel((Path)path, null, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newByteChannelNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newByteChannel(null, null, new FileAttribute[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void newAsynchronousFileChannelUnsupportedOp() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.newAsynchronousFileChannel((Path)path, null, null, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newAsynchronousFileChannelNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newAsynchronousFileChannel(null, null, null, new FileAttribute[0]);
    }

    @Test
    public void seekableByteChannel() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userBasedPath = System.getProperty("user.dir") + "/my_byte_some_file_here.txt";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userBasedPath, (boolean)false);
        Assertions.assertThat((File)path.toFile()).doesNotExist();
        SeekableByteChannel channel = fsProvider.newByteChannel((Path)path, null, new FileAttribute[0]);
        Assertions.assertThat((Object)channel).isNotNull();
        Assertions.assertThat((File)path.toFile()).exists();
        Assertions.assertThat((boolean)channel.isOpen()).isTrue();
        channel.close();
        Assertions.assertThat((boolean)channel.isOpen()).isFalse();
        path.toFile().delete();
        Assertions.assertThat((File)path.toFile()).doesNotExist();
    }

    @Test
    public void checkCreateDirectory() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userBasedPath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userBasedPath, (boolean)false);
        path.toFile().delete();
        Assertions.assertThat((File)path.toFile()).doesNotExist();
        fsProvider.createDirectory((Path)path, new FileAttribute[0]);
        Assertions.assertThat((File)path.toFile()).exists();
        path.toFile().delete();
        Assertions.assertThat((File)path.toFile()).doesNotExist();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void checkCreateDirectoryAlreadyExists() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userBasedPath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userBasedPath, (boolean)false);
        Assertions.assertThat((File)path.toFile()).doesNotExist();
        fsProvider.createDirectory((Path)path, new FileAttribute[0]);
        Assertions.assertThat((File)path.toFile()).exists();
        fsProvider.createDirectory((Path)path, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createDirectoryNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.createDirectory(null, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createSymbolicLinkNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.createSymbolicLink(null, null, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createSymbolicLinkNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.createSymbolicLink((Path)path, null, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createSymbolicLinkNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.createSymbolicLink(null, (Path)path, new FileAttribute[0]);
    }

    @Test(expected=IllegalStateException.class)
    public void createSymbolicLinkSame() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.createSymbolicLink((Path)path, (Path)path, new FileAttribute[0]);
    }

    @Test(expected=IllegalStateException.class)
    public void createSymbolicLinkTargetMustExists() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file2.txt", (boolean)false);
        fsProvider.createSymbolicLink((Path)path, (Path)path2, new FileAttribute[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void createSymbolicLinkUnsupportedOp() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path2 = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.createSymbolicLink((Path)path, (Path)path2, new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createLinkNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.createLink(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createLinkNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.createLink((Path)path, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createLinkNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.createLink(null, (Path)path);
    }

    @Test(expected=IllegalStateException.class)
    public void createLinkSame() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.createLink((Path)path, (Path)path);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void createLinkUnsupportedOp() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path2 = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.createLink((Path)path, (Path)path2);
    }

    @Test
    public void checkDelete() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThat((File)path.toFile()).exists();
        fsProvider.delete((Path)path, new DeleteOption[0]);
        Assertions.assertThat((File)path.toFile()).doesNotExist();
    }

    @Test(expected=NoSuchFileException.class)
    public void checkDeleteNonExistent() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((File)path.toFile()).doesNotExist();
        fsProvider.delete((Path)path, new DeleteOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkDeleteNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.delete(null, new DeleteOption[0]);
    }

    @Test
    public void checkDeleteIfExists() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThat((File)path.toFile()).exists();
        Assertions.assertThat((boolean)fsProvider.deleteIfExists((Path)path, new DeleteOption[0])).isTrue();
        Assertions.assertThat((File)path.toFile()).doesNotExist();
    }

    @Test
    public void checkDeleteIfExistsNonExistent() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((File)path.toFile()).doesNotExist();
        Assertions.assertThat((boolean)fsProvider.deleteIfExists((Path)path, new DeleteOption[0])).isFalse();
        Assertions.assertThat((File)path.toFile()).doesNotExist();
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkDeleteIfExistsNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.deleteIfExists(null, new DeleteOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readSymbolicLinkNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.readSymbolicLink(null);
    }

    @Test(expected=NotLinkException.class)
    public void readSymbolicLinkNotLink() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.readSymbolicLink((Path)path);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void readSymbolicLinkUnsupportedOp() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.readSymbolicLink((Path)path);
    }

    @Test
    public void checkIsSameFile() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((boolean)fsProvider.isSameFile((Path)path, (Path)path2)).isTrue();
        GeneralPathImpl path3 = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"path/to/file.txt", (boolean)false);
        Assertions.assertThat((boolean)fsProvider.isSameFile((Path)path, (Path)path3)).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void sameFileNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.isSameFile(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void sameFileNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.isSameFile((Path)path, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void sameFileNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.isSameFile(null, (Path)path);
    }

    @Test
    public void checkCopyDir() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp";
        String userDestPath = System.getProperty("user.dir") + "/temp2";
        GeneralPathImpl source = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        GeneralPathImpl dest = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userDestPath, (boolean)false);
        fsProvider.createDirectory((Path)source, new FileAttribute[0]);
        fsProvider.copy((Path)source, (Path)dest, new CopyOption[0]);
        Assertions.assertThat((File)dest.toFile()).exists();
        Assertions.assertThat((File)source.toFile()).exists();
        source.toFile().delete();
        dest.toFile().delete();
    }

    @Test
    public void checkCopyFile() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp.txt";
        String userDestPath = System.getProperty("user.dir") + "/temp2.txt";
        GeneralPathImpl source = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        GeneralPathImpl dest = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userDestPath, (boolean)false);
        OutputStream stream = fsProvider.newOutputStream((Path)source, new OpenOption[0]);
        stream.write(97);
        stream.close();
        fsProvider.copy((Path)source, (Path)dest, new CopyOption[0]);
        Assertions.assertThat((File)dest.toFile()).exists();
        Assertions.assertThat((File)source.toFile()).exists();
        Assertions.assertThat((long)dest.toFile().length()).isEqualTo(source.toFile().length());
        source.toFile().delete();
        dest.toFile().delete();
    }

    @Test
    public void copyFileInvalidSourceAndTarget() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp";
        String userDestPath = System.getProperty("user.dir") + "/temp2";
        GeneralPathImpl source = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        GeneralPathImpl dest = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userDestPath, (boolean)false);
        fsProvider.createDirectory((Path)source, new FileAttribute[0]);
        GeneralPathImpl sourceFile = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)(userSourcePath + "/file.txt"), (boolean)false);
        OutputStream stream = fsProvider.newOutputStream((Path)sourceFile, new OpenOption[0]);
        stream.write(97);
        stream.close();
        Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderTest.lambda$copyFileInvalidSourceAndTarget$0(fsProvider, (Path)source, (Path)dest)).isInstanceOf(DirectoryNotEmptyException.class);
        sourceFile.toFile().delete();
        fsProvider.copy((Path)source, (Path)dest, new CopyOption[0]);
        Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderTest.lambda$copyFileInvalidSourceAndTarget$1(fsProvider, (Path)source, (Path)dest)).isInstanceOf(FileAlreadyExistsException.class);
        dest.toFile().delete();
        source.toFile().delete();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderTest.lambda$copyFileInvalidSourceAndTarget$2(fsProvider, (Path)source, (Path)dest)).isInstanceOf(IllegalStateException.class)).hasMessage("Condition 'source must exist' is invalid!");
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyFileNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userPath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userPath, (boolean)false);
        fsProvider.copy((Path)path, null, new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyFileNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userPath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userPath, (boolean)false);
        fsProvider.copy(null, (Path)path, new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void copyFileNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.copy(null, null, new CopyOption[0]);
    }

    @Test
    public void checkMoveDir() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp";
        String userDestPath = System.getProperty("user.dir") + "/temp2";
        GeneralPathImpl source = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        GeneralPathImpl dest = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userDestPath, (boolean)false);
        fsProvider.createDirectory((Path)source, new FileAttribute[0]);
        fsProvider.move((Path)source, (Path)dest, new CopyOption[0]);
        Assertions.assertThat((File)source.toFile()).doesNotExist();
        Assertions.assertThat((File)dest.toFile()).exists();
        dest.toFile().delete();
    }

    @Test
    public void checkMoveFile() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp.txt";
        String userDestPath = System.getProperty("user.dir") + "/temp2.txt";
        GeneralPathImpl source = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        GeneralPathImpl dest = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userDestPath, (boolean)false);
        OutputStream stream = fsProvider.newOutputStream((Path)source, new OpenOption[0]);
        stream.write(97);
        stream.close();
        long lenght = source.toFile().length();
        fsProvider.move((Path)source, (Path)dest, new CopyOption[0]);
        Assertions.assertThat((File)dest.toFile()).exists();
        Assertions.assertThat((File)source.toFile()).doesNotExist();
        Assertions.assertThat((long)dest.toFile().length()).isEqualTo(lenght);
        dest.toFile().delete();
    }

    @Test
    public void moveFileInvalidSourceAndTarget() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp";
        String userDestPath = System.getProperty("user.dir") + "/temp2";
        GeneralPathImpl source = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        GeneralPathImpl dest = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userDestPath, (boolean)false);
        fsProvider.createDirectory((Path)source, new FileAttribute[0]);
        GeneralPathImpl sourceFile = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)(userSourcePath + "/file.txt"), (boolean)false);
        OutputStream stream = fsProvider.newOutputStream((Path)sourceFile, new OpenOption[0]);
        stream.write(97);
        stream.close();
        Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderTest.lambda$moveFileInvalidSourceAndTarget$3(fsProvider, (Path)source, (Path)dest)).isInstanceOf(DirectoryNotEmptyException.class);
        sourceFile.toFile().delete();
        fsProvider.copy((Path)source, (Path)dest, new CopyOption[0]);
        Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderTest.lambda$moveFileInvalidSourceAndTarget$4(fsProvider, (Path)source, (Path)dest)).isInstanceOf(FileAlreadyExistsException.class);
        dest.toFile().delete();
        source.toFile().delete();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderTest.lambda$moveFileInvalidSourceAndTarget$5(fsProvider, (Path)source, (Path)dest)).isInstanceOf(IllegalStateException.class)).hasMessage("Condition 'source must exist' is invalid!");
    }

    @Test(expected=IllegalArgumentException.class)
    public void moveFileNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userPath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userPath, (boolean)false);
        fsProvider.move((Path)path, null, new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void moveFileNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userPath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userPath, (boolean)false);
        fsProvider.move(null, (Path)path, new CopyOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void moveFileNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.move(null, null, new CopyOption[0]);
    }

    @Test
    public void checkNewDirectoryStream() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/temp";
        GeneralPathImpl dir = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        FileUtils.deleteDirectory((File)dir.toFile());
        fsProvider.createDirectory((Path)dir, new FileAttribute[0]);
        DirectoryStream stream = fsProvider.newDirectoryStream((Path)dir, entry -> true);
        Assertions.assertThat((Iterable)stream).hasSize(0);
        Assertions.assertThatThrownBy(() -> stream.iterator().next()).isInstanceOf(NoSuchElementException.class);
        File tempFile = File.createTempFile("foo", "bar", dir.toFile());
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        DirectoryStream stream2 = fsProvider.newDirectoryStream((Path)dir, entry -> true);
        Assertions.assertThat((Iterable)stream2).hasSize(1);
        Iterator iterator = stream2.iterator();
        iterator.next();
        Assertions.assertThatThrownBy(() -> iterator.remove()).isInstanceOf(UnsupportedOperationException.class);
        stream2.close();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> stream2.close()).isInstanceOf(IOException.class)).hasMessage("This stream is closed.");
        File tempFile2 = File.createTempFile("bar", "foo", dir.toFile());
        GeneralPathImpl path2 = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile2);
        DirectoryStream stream3 = fsProvider.newDirectoryStream((Path)dir, entry -> true);
        ((IterableAssert)Assertions.assertThat((Iterable)stream3).hasSize(2)).contains((Object[])new Path[]{path, path2});
        stream3.close();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> stream3.iterator().next()).isInstanceOf(IOException.class)).hasMessage("This stream is closed.");
        DirectoryStream stream4 = fsProvider.newDirectoryStream((Path)dir, entry -> entry.getFileName().toString().startsWith("foo"));
        ((IterableAssert)Assertions.assertThat((Iterable)stream4).hasSize(1)).contains((Object[])new Path[]{path});
        FileUtils.deleteDirectory((File)dir.toFile());
    }

    @Test
    public void checkDeleteNonEmptyDir() throws java.io.IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + System.getProperty("file.separator") + "temp";
        GeneralPathImpl dir = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        FileUtils.deleteDirectory((File)dir.toFile());
        fsProvider.createDirectory((Path)dir, new FileAttribute[0]);
        File.createTempFile("foo", "bar", dir.toFile());
        File.createTempFile("bar", "foo", dir.toFile());
        File.createTempFile("bar", "foo", dir.toFile());
        fsProvider.createDirectory(dir.resolve("other_dir"), new FileAttribute[0]);
        DirectoryStream stream5 = fsProvider.newDirectoryStream((Path)dir, entry -> true);
        ((IterableAssert)Assertions.assertThat((Iterable)stream5).hasSize(4)).contains((Object[])new Path[]{dir.resolve("other_dir")});
        Assertions.assertThatThrownBy(() -> SimpleFileSystemProviderTest.lambda$checkDeleteNonEmptyDir$15(fsProvider, (Path)dir)).isInstanceOf(DirectoryNotEmptyException.class);
        fsProvider.delete((Path)dir, new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES});
        Assertions.assertThat((boolean)dir.toFile().exists()).isEqualTo(false);
    }

    @Test(expected=NotDirectoryException.class)
    public void newDirectoryStreamInvalidDir() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/xxxxxx";
        GeneralPathImpl dir = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        fsProvider.newDirectoryStream((Path)dir, entry -> true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull1() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.newDirectoryStream(null, entry -> true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull2() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/xxxxxx";
        GeneralPathImpl dir = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        fsProvider.newDirectoryStream((Path)dir, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull3() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        String userSourcePath = System.getProperty("user.dir") + "/xxxxxx";
        GeneralPathImpl dir = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)userSourcePath, (boolean)false);
        fsProvider.newDirectoryStream(null, null);
    }

    private static /* synthetic */ void lambda$checkDeleteNonEmptyDir$15(SimpleFileSystemProvider fsProvider, Path dir) throws Throwable {
        fsProvider.delete(dir, new DeleteOption[0]);
    }

    private static /* synthetic */ void lambda$moveFileInvalidSourceAndTarget$5(SimpleFileSystemProvider fsProvider, Path source, Path dest) throws Throwable {
        fsProvider.move(source, dest, new CopyOption[0]);
    }

    private static /* synthetic */ void lambda$moveFileInvalidSourceAndTarget$4(SimpleFileSystemProvider fsProvider, Path source, Path dest) throws Throwable {
        fsProvider.move(source, dest, new CopyOption[0]);
    }

    private static /* synthetic */ void lambda$moveFileInvalidSourceAndTarget$3(SimpleFileSystemProvider fsProvider, Path source, Path dest) throws Throwable {
        fsProvider.move(source, dest, new CopyOption[0]);
    }

    private static /* synthetic */ void lambda$copyFileInvalidSourceAndTarget$2(SimpleFileSystemProvider fsProvider, Path source, Path dest) throws Throwable {
        fsProvider.copy(source, dest, new CopyOption[0]);
    }

    private static /* synthetic */ void lambda$copyFileInvalidSourceAndTarget$1(SimpleFileSystemProvider fsProvider, Path source, Path dest) throws Throwable {
        fsProvider.copy(source, dest, new CopyOption[0]);
    }

    private static /* synthetic */ void lambda$copyFileInvalidSourceAndTarget$0(SimpleFileSystemProvider fsProvider, Path source, Path dest) throws Throwable {
        fsProvider.copy(source, dest, new CopyOption[0]);
    }
}

