/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.File;
import java.io.IOException;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.command.UnknownCommand;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitReceiveCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitUploadCommand;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.Subject;
import org.uberfire.security.auth.AuthenticationManager;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.server.UserPassSecurityContext;

public class GitSSHService {
    final SshServer sshd = SshServer.setUpDefaultServer();
    private AuthenticationManager authenticationManager;
    private AuthorizationManager authorizationManager;

    public void setup(File certDir, int port, AuthenticationManager authenticationManager, AuthorizationManager authorizationManager, final ReceivePackFactory receivePackFactory, final JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver) {
        this.authenticationManager = authenticationManager;
        this.authorizationManager = authorizationManager;
        this.sshd.getProperties().put("idle-timeout", "10000");
        this.sshd.setPort(port);
        if (!certDir.exists()) {
            certDir.mkdirs();
        }
        this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(new File(certDir, "hostkey.ser").getAbsolutePath()));
        this.sshd.setCommandFactory(new CommandFactory(){

            public Command createCommand(String command) {
                if (command.startsWith("git-upload-pack")) {
                    return new GitUploadCommand(command, repositoryResolver, GitSSHService.this.getAuthorizationManager());
                }
                if (command.startsWith("git-receive-pack")) {
                    return new GitReceiveCommand(command, repositoryResolver, GitSSHService.this.getAuthorizationManager(), (ReceivePackFactory<BaseGitCommand>)receivePackFactory);
                }
                return new UnknownCommand(command);
            }
        });
        this.sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                try {
                    UserPassSecurityContext context = new UserPassSecurityContext(null, username, password);
                    Subject result = GitSSHService.this.getAuthenticationManager().authenticate((SecurityContext)context);
                    if (result != null) {
                        session.setAttribute(BaseGitCommand.SUBJECT_KEY, (Object)result);
                    }
                    return result != null;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        });
    }

    public void stop() {
        try {
            this.sshd.stop(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void start() {
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    private AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }
}

